# log_service.py
import logging.config
import os
import sys

# Ensure log directory exists
LOG_DIR = os.path.join(os.path.dirname(__file__), 'logs')
if not os.path.exists(LOG_DIR):
    os.makedirs(LOG_DIR, exist_ok=True)

# Configure logging using logging.conf
LOG_CONFIG_PATH = os.path.join(os.path.dirname(__file__), 'logging.conf')
logging.config.fileConfig(LOG_CONFIG_PATH, disable_existing_loggers=False)

# Create a logger for the Flask app
logger = logging.getLogger('flask-app')

# Test logger output
logger.info("Logger initialized and ready to log.")
