$(document).ready(function(){
	
	$("#status").click(function(){
		loadStatus();
	});
	
	$("#configuration").click(function(){
		loadConfiguration();
	});
	
	function loadPageData(url, title, data, callback) {
		$.ajax({
			url: url,
			data: data,
			beforeSend : function(){
				$( "#pagesContainer" ).addClass('page-loading');
			},
			complete : function(){
				$( "#pagesContainer" ).removeClass('page-loading');
			},
			success : function(response){
				$("#pageNameContainer").html(title);
				$("#pagesContainer").html(response);
				if($.isFunction(callback)) {
					callback();
				}
			},
		});
	}
	
	function loadConfiguration(url, title, data, callback){
		closeOtherTreeMenu($("#configuration"));
		if(!url) {
			url = "/configuration";
		}
		if(!title) {
			title = "Configuration";
		}
		loadPageData(url, title, data, callback);
	};
	
	closeOtherTreeMenu = function (link) {
		if(link){
			link.closest('ul').find('li').removeClass('active');
			link.closest('li').addClass('active')
		}
	};
	

	function loadStatus(url, title, data, callback){
		closeOtherTreeMenu($("#status"));
		if(!url) {
			url = "/status";
		}
		if(!title) {
			title = "Status";
		}
		loadPageData(url, title, data, callback);
	};
});