 /**
  * 
  * 
         * Alert window
         * 
         * @param {type} message
         * @param {type} callback
         * @returns {undefined}
         */
        BootstrapDialog.alert = function(message, _title, callback) {
            new BootstrapDialog({
            	title: _title,
                message: message,
                type: BootstrapDialog.TYPE_INFO,
                data: {
                    'callback': callback
                },
                closable: false,
                buttons: [{
                        label: 'OK',
                        cssClass: 'btn-primary',
                        action: function(dialog) {
                            typeof dialog.getData('callback') === 'function' && dialog.getData('callback')(true);
                            dialog.close();
                        }
                    }]
            }).open();
        };
        

       /* * WARNING window
        * 
        * @param {type} message
        * @param {type} callback
        * @returns {undefined}
        */
       BootstrapDialog.warning = function(message, _title, callback) {
           new BootstrapDialog({
           	title: _title,
               message: message,
               type: BootstrapDialog.TYPE_WARNING,
               data: {
                   'callback': callback
               },
               closable: false,
               buttons: [{
                       label: 'OK',
                       cssClass: 'btn-primary',
                       action: function(dialog) {
                           typeof dialog.getData('callback') === 'function' && dialog.getData('callback')(true);
                           dialog.close();
                       }
                   }]
           }).open();
       };


        /**
         * Confirm window
         * 
         * @param {type} message
         * @param {type} callback
         * @returns {undefined}
         */
        BootstrapDialog.confirm = function(message, _title,  callback, labelParam) {
        	var okButtonLabel;
        	if(labelParam){
        		okButtonLabel = labelParam;
        	}else{
        		okButtonLabel = 'OK';
        	}
            new BootstrapDialog({
                title: _title,
                message: message,
                closable: false,
                type: BootstrapDialog.TYPE_INFO,
                data: {
                    'callback': callback
                },
                buttons: [{
                        label: 'Cancel',
                        action: function(dialog) {
                            typeof dialog.getData('callback') === 'function' && dialog.getData('callback')(false);
                            dialog.close();
                        }
                    }, {
                        label: okButtonLabel,
                        cssClass: 'btn-primary',
                        action: function(dialog) {
                            typeof dialog.getData('callback') === 'function' && dialog.getData('callback')(true);
                            dialog.close();
                        }
                    }]
            }).open();
        };
        
        /** Added by DvSum Team
         * Confirm window
         * 
         * @param {type} message
         * @param {type} callback
         * @returns {undefined}
         */
        BootstrapDialog.confirmation = function(message, _title, btn1Label, btn2Label, callback) {
        	var btnLabel1 = btn1Label ? btn1Label : 'Save',
            	btnLabel2 = btn2Label ? btn2Label : 'Cancel';
        		cssClassBtn2 = btn2Label === 'Log Out Now' ? 'btn-primary' : '' 
                new BootstrapDialog({
                    title: _title,
                    message: message,
                    closable: false,
                    type: BootstrapDialog.TYPE_INFO,
                    data: {
                        'callback': callback
                    },
                    buttons: [{
                            label: btnLabel1,
                            cssClass: 'btn-primary',
                            action: function(dialog) {
                                typeof dialog.getData('callback') === 'function' && dialog.getData('callback')(true);
                                dialog.close();
                            }
                        },{
                            label: btnLabel2,
                            cssClass: cssClassBtn2,
                            action: function(dialog) {
                                typeof dialog.getData('callback') === 'function' && dialog.getData('callback')(false);
                                dialog.close();
                          }
                        }]
                }).open();
        };