/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.security.auth.x500.X500Principal;

public final class PemReader {
    private static final Pattern CERT_PATTERN = Pattern.compile("-+BEGIN\\s+.*CERTIFICATE[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*CERTIFICATE[^-]*-+", 2);
    private static final Pattern PRIVATE_KEY_PATTERN = Pattern.compile("-+BEGIN\\s+.*PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*PRIVATE\\s+KEY[^-]*-+", 2);
    private static final Pattern PUBLIC_KEY_PATTERN = Pattern.compile("-+BEGIN\\s+.*PUBLIC\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*PUBLIC\\s+KEY[^-]*-+", 2);

    private PemReader() {
    }

    public static KeyStore loadTrustStore(File file) throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        List<X509Certificate> list = PemReader.readCertificateChain(file);
        for (X509Certificate x509Certificate : list) {
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            keyStore.setCertificateEntry(x500Principal.getName("RFC2253"), x509Certificate);
        }
        return keyStore;
    }

    public static KeyStore loadKeyStore(File file, File file2, Optional<String> optional) throws IOException, GeneralSecurityException {
        PrivateKey privateKey = PemReader.loadPrivateKey(file2, optional);
        List<X509Certificate> list = PemReader.readCertificateChain(file);
        if (list.isEmpty()) {
            throw new CertificateException("Certificate file does not contain any certificates: " + file);
        }
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        keyStore.setKeyEntry("key", privateKey, optional.orElse("").toCharArray(), list.toArray(new Certificate[0]));
        return keyStore;
    }

    public static List<X509Certificate> readCertificateChain(File file) throws IOException, GeneralSecurityException {
        String string = new String(Files.readAllBytes(file.toPath()), StandardCharsets.US_ASCII);
        return PemReader.readCertificateChain(string);
    }

    public static List<X509Certificate> readCertificateChain(String string) throws CertificateException {
        Matcher matcher = CERT_PATTERN.matcher(string);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        int n2 = 0;
        while (matcher.find(n2)) {
            byte[] byArray = PemReader.base64Decode(matcher.group(1));
            arrayList.add((X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray)));
            n2 = matcher.end();
        }
        return arrayList;
    }

    public static PrivateKey loadPrivateKey(File file, Optional<String> optional) throws IOException, GeneralSecurityException {
        String string = new String(Files.readAllBytes(file.toPath()), StandardCharsets.US_ASCII);
        return PemReader.loadPrivateKey(string, optional);
    }

    public static PrivateKey loadPrivateKey(String string, Optional<String> optional) throws IOException, GeneralSecurityException {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec;
        Object object;
        Matcher matcher = PRIVATE_KEY_PATTERN.matcher(string);
        if (!matcher.find()) {
            throw new KeyStoreException("did not find a private key");
        }
        byte[] byArray = PemReader.base64Decode(matcher.group(1));
        if (optional.isPresent()) {
            object = new EncryptedPrivateKeyInfo(byArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(((EncryptedPrivateKeyInfo)object).getAlgName());
            SecretKey secretKey = secretKeyFactory.generateSecret(new PBEKeySpec(optional.get().toCharArray()));
            Cipher cipher = Cipher.getInstance(((EncryptedPrivateKeyInfo)object).getAlgName());
            cipher.init(2, (Key)secretKey, ((EncryptedPrivateKeyInfo)object).getAlgParameters());
            pKCS8EncodedKeySpec = ((EncryptedPrivateKeyInfo)object).getKeySpec(cipher);
        } else {
            pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        }
        try {
            object = KeyFactory.getInstance("RSA");
            return ((KeyFactory)object).generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("EC");
                return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            }
            catch (InvalidKeySpecException invalidKeySpecException2) {
                KeyFactory keyFactory = KeyFactory.getInstance("DSA");
                return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            }
        }
    }

    public static PublicKey loadPublicKey(File file) throws IOException, GeneralSecurityException {
        String string = new String(Files.readAllBytes(file.toPath()), StandardCharsets.US_ASCII);
        return PemReader.loadPublicKey(string);
    }

    public static PublicKey loadPublicKey(String string) throws GeneralSecurityException {
        Matcher matcher = PUBLIC_KEY_PATTERN.matcher(string);
        if (!matcher.find()) {
            throw new KeyStoreException("did not find a public key");
        }
        String string2 = matcher.group(1);
        byte[] byArray = PemReader.base64Decode(string2);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("EC");
                return keyFactory.generatePublic(x509EncodedKeySpec);
            }
            catch (InvalidKeySpecException invalidKeySpecException2) {
                KeyFactory keyFactory = KeyFactory.getInstance("DSA");
                return keyFactory.generatePublic(x509EncodedKeySpec);
            }
        }
    }

    private static byte[] base64Decode(String string) {
        return Base64.getMimeDecoder().decode(string.getBytes(StandardCharsets.US_ASCII));
    }
}

