/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.RateLogger;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.WorkerService;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.IDeadWatcherListener;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

public class WatcherCleaner
extends Thread {
    private static final foe LOG = goe.a(WatcherCleaner.class);
    private final RateLogger RATE_LOGGER = new RateLogger(LOG);
    private volatile boolean stopped = false;
    private final Object cleanEvent = new Object();
    private final Object processingCompletedEvent = new Object();
    private final WorkerService cleaners;
    private final Set<Integer> deadWatchers;
    private final IDeadWatcherListener listener;
    private final int watcherCleanThreshold;
    private final int watcherCleanIntervalInSeconds;
    private final int maxInProcessingDeadWatchers;
    private final AtomicInteger totalDeadWatchers = new AtomicInteger();

    public WatcherCleaner(IDeadWatcherListener iDeadWatcherListener) {
        this(iDeadWatcherListener, Integer.getInteger("zookeeper.watcherCleanThreshold", 1000), Integer.getInteger("zookeeper.watcherCleanIntervalInSeconds", 600), Integer.getInteger("zookeeper.watcherCleanThreadsNum", 2), Integer.getInteger("zookeeper.maxInProcessingDeadWatchers", -1));
    }

    public WatcherCleaner(IDeadWatcherListener iDeadWatcherListener, int n2, int n3, int n4, int n5) {
        this.listener = iDeadWatcherListener;
        this.watcherCleanThreshold = n2;
        this.watcherCleanIntervalInSeconds = n3;
        int n6 = n2 * n4;
        if (n5 > 0 && n5 < n6) {
            n5 = n6;
            LOG.c("The maxInProcessingDeadWatchers config is smaller than the suggested one, change it to use {}", (Object)n5);
        }
        this.maxInProcessingDeadWatchers = n5;
        this.deadWatchers = new HashSet<Integer>();
        this.cleaners = new WorkerService("DeadWatcherCleanner", n4, false);
        LOG.c("watcherCleanThreshold={}, watcherCleanIntervalInSeconds={}, watcherCleanThreadsNum={}, maxInProcessingDeadWatchers={}", n2, n3, n4, n5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeadWatcher(int n2) {
        while (this.maxInProcessingDeadWatchers > 0 && !this.stopped && this.totalDeadWatchers.get() >= this.maxInProcessingDeadWatchers) {
            try {
                this.RATE_LOGGER.rateLimitLog("Waiting for dead watchers cleaning");
                long l2 = Time.currentElapsedTime();
                Object object = this.processingCompletedEvent;
                synchronized (object) {
                    this.processingCompletedEvent.wait(100L);
                }
                long l3 = Time.currentElapsedTime() - l2;
                ServerMetrics.getMetrics().ADD_DEAD_WATCHER_STALL_TIME.add(l3);
            }
            catch (InterruptedException interruptedException) {
                LOG.c("Got interrupted while waiting for dead watches queue size");
                break;
            }
        }
        WatcherCleaner watcherCleaner = this;
        synchronized (watcherCleaner) {
            if (this.deadWatchers.add(n2)) {
                this.totalDeadWatchers.incrementAndGet();
                ServerMetrics.getMetrics().DEAD_WATCHERS_QUEUED.add(1L);
                if (this.deadWatchers.size() >= this.watcherCleanThreshold) {
                    Object object = this.cleanEvent;
                    synchronized (object) {
                        this.cleanEvent.notifyAll();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stopped) {
            Object object = this.cleanEvent;
            synchronized (object) {
                block9: {
                    try {
                        if (this.stopped || this.deadWatchers.size() >= this.watcherCleanThreshold) break block9;
                        int n2 = (this.watcherCleanIntervalInSeconds + ThreadLocalRandom.current().nextInt(this.watcherCleanIntervalInSeconds / 2 + 1)) * 1000;
                        this.cleanEvent.wait(n2);
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.c("Received InterruptedException while waiting for cleanEvent");
                        break;
                    }
                }
            }
            if (this.deadWatchers.isEmpty()) continue;
            object = this;
            synchronized (object) {
                final HashSet<Integer> hashSet = new HashSet<Integer>(this.deadWatchers);
                this.deadWatchers.clear();
                final int n3 = hashSet.size();
                LOG.c("Processing {} dead watchers", (Object)n3);
                this.cleaners.schedule(new WorkerService.WorkRequest(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void doWork() throws Exception {
                        long l2 = Time.currentElapsedTime();
                        WatcherCleaner.this.listener.processDeadWatchers(hashSet);
                        long l3 = Time.currentElapsedTime() - l2;
                        LOG.c("Takes {} to process {} watches", (Object)l3, (Object)n3);
                        ServerMetrics.getMetrics().DEAD_WATCHERS_CLEANER_LATENCY.add(l3);
                        ServerMetrics.getMetrics().DEAD_WATCHERS_CLEARED.add(n3);
                        WatcherCleaner.this.totalDeadWatchers.addAndGet(-n3);
                        Object object = WatcherCleaner.this.processingCompletedEvent;
                        synchronized (object) {
                            WatcherCleaner.this.processingCompletedEvent.notifyAll();
                        }
                    }
                });
            }
        }
        LOG.c("WatcherCleaner thread exited");
    }

    public void shutdown() {
        this.stopped = true;
        this.deadWatchers.clear();
        this.cleaners.stop();
        this.interrupt();
        if (LOG.d()) {
            LOG.c("WatcherCleaner thread shutdown is initiated");
        }
    }
}

