/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.WatchedEvent;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Watcher;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.ACL;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerWatcher;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.BitHashSet;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.BitMap;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.IDeadWatcherListener;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.IWatchManager;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.WatcherCleaner;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.WatcherOrBitSet;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.WatchesPathReport;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.WatchesReport;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.WatchesSummary;
import java.io.PrintWriter;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class WatchManagerOptimized
implements IDeadWatcherListener,
IWatchManager {
    private static final foe LOG = goe.a(WatchManagerOptimized.class);
    private final ConcurrentHashMap<String, BitHashSet> pathWatches = new ConcurrentHashMap();
    private final BitMap<Watcher> watcherBitIdMap = new BitMap();
    private final WatcherCleaner watcherCleaner;
    private final ReentrantReadWriteLock addRemovePathRWLock = new ReentrantReadWriteLock();

    public WatchManagerOptimized() {
        this.watcherCleaner = new WatcherCleaner(this);
        this.watcherCleaner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addWatch(String string, Watcher watcher) {
        boolean bl2 = false;
        this.addRemovePathRWLock.readLock().lock();
        try {
            if (this.isDeadWatcher(watcher)) {
                LOG.b("Ignoring addWatch with closed cnxn");
            } else {
                BitHashSet bitHashSet;
                Integer n2 = this.watcherBitIdMap.add(watcher);
                BitHashSet bitHashSet2 = this.pathWatches.get(string);
                if (bitHashSet2 == null && (bitHashSet = this.pathWatches.putIfAbsent(string, bitHashSet2 = new BitHashSet())) != null) {
                    bitHashSet2 = bitHashSet;
                }
                bl2 = bitHashSet2.add(n2);
            }
        }
        finally {
            this.addRemovePathRWLock.readLock().unlock();
        }
        return bl2;
    }

    @Override
    public boolean containsWatcher(String string, Watcher watcher) {
        BitHashSet bitHashSet = this.pathWatches.get(string);
        return bitHashSet != null && bitHashSet.contains(this.watcherBitIdMap.getBit(watcher));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeWatcher(String string, Watcher watcher) {
        this.addRemovePathRWLock.writeLock().lock();
        try {
            BitHashSet bitHashSet = this.pathWatches.get(string);
            if (bitHashSet == null || !bitHashSet.remove(this.watcherBitIdMap.getBit(watcher))) {
                boolean bl2 = false;
                return bl2;
            }
            if (bitHashSet.isEmpty()) {
                this.pathWatches.remove(string);
            }
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.addRemovePathRWLock.writeLock().unlock();
        }
    }

    @Override
    public void removeWatcher(Watcher watcher) {
        Integer n2;
        this.addRemovePathRWLock.writeLock().lock();
        try {
            n2 = this.watcherBitIdMap.getBit(watcher);
            if (n2 == null) {
                return;
            }
        }
        finally {
            this.addRemovePathRWLock.writeLock().unlock();
        }
        this.watcherCleaner.addDeadWatcher(n2);
    }

    @Override
    public void processDeadWatchers(Set<Integer> set) {
        BitSet bitSet = new BitSet();
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            int n2 = iterator.next();
            bitSet.set(n2);
        }
        for (BitHashSet bitHashSet : this.pathWatches.values()) {
            bitHashSet.remove(set, bitSet);
        }
        for (Integer n3 : set) {
            this.watcherBitIdMap.remove(n3);
        }
    }

    @Override
    public WatcherOrBitSet triggerWatch(String string, Watcher.Event.EventType eventType, long l2, List<ACL> list) {
        return this.triggerWatch(string, eventType, l2, list, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WatcherOrBitSet triggerWatch(String string, Watcher.Event.EventType eventType, long l2, List<ACL> list, WatcherOrBitSet watcherOrBitSet) {
        WatchedEvent watchedEvent = new WatchedEvent(eventType, Watcher.Event.KeeperState.SyncConnected, string, l2);
        BitHashSet bitHashSet = this.remove(string);
        if (bitHashSet == null) {
            return null;
        }
        int n2 = 0;
        BitHashSet bitHashSet2 = bitHashSet;
        synchronized (bitHashSet2) {
            for (Integer n3 : bitHashSet) {
                Watcher watcher;
                if (watcherOrBitSet != null && watcherOrBitSet.contains(n3) || (watcher = this.watcherBitIdMap.get(n3)) == null || this.isDeadWatcher(watcher)) continue;
                if (watcher instanceof ServerWatcher) {
                    ((ServerWatcher)watcher).process(watchedEvent, list);
                } else {
                    watcher.process(watchedEvent);
                }
                ++n2;
            }
        }
        this.updateMetrics(eventType, n2);
        return new WatcherOrBitSet(bitHashSet);
    }

    @Override
    public int size() {
        int n2 = 0;
        for (BitHashSet bitHashSet : this.pathWatches.values()) {
            n2 += bitHashSet.size();
        }
        return n2;
    }

    @Override
    public void shutdown() {
        if (this.watcherCleaner != null) {
            this.watcherCleaner.shutdown();
        }
    }

    private BitHashSet remove(String string) {
        this.addRemovePathRWLock.writeLock().lock();
        try {
            BitHashSet bitHashSet = this.pathWatches.remove(string);
            return bitHashSet;
        }
        finally {
            this.addRemovePathRWLock.writeLock().unlock();
        }
    }

    void updateMetrics(Watcher.Event.EventType eventType, int n2) {
        switch (eventType) {
            case NodeCreated: {
                ServerMetrics.getMetrics().NODE_CREATED_WATCHER.add(n2);
                break;
            }
            case NodeDeleted: {
                ServerMetrics.getMetrics().NODE_DELETED_WATCHER.add(n2);
                break;
            }
            case NodeDataChanged: {
                ServerMetrics.getMetrics().NODE_CHANGED_WATCHER.add(n2);
                break;
            }
            case NodeChildrenChanged: {
                ServerMetrics.getMetrics().NODE_CHILDREN_WATCHER.add(n2);
                break;
            }
        }
    }

    boolean isDeadWatcher(Watcher watcher) {
        return watcher instanceof ServerCnxn && ((ServerCnxn)watcher).isStale();
    }

    int pathSize() {
        return this.pathWatches.size();
    }

    @Override
    public WatchesSummary getWatchesSummary() {
        return new WatchesSummary(this.watcherBitIdMap.size(), this.pathSize(), this.size());
    }

    @Override
    public WatchesReport getWatches() {
        HashMap<Long, Set<String>> hashMap = new HashMap<Long, Set<String>>();
        for (Map.Entry<Watcher, Set<String>> entry : this.getWatcher2PathesMap().entrySet()) {
            Long l2 = ((ServerCnxn)entry.getKey()).getSessionId();
            HashSet hashSet = new HashSet(entry.getValue());
            hashMap.put(l2, hashSet);
        }
        return new WatchesReport(hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WatchesPathReport getWatchesByPath() {
        HashMap<String, Set<Long>> hashMap = new HashMap<String, Set<Long>>();
        for (Map.Entry<String, BitHashSet> entry : this.pathWatches.entrySet()) {
            BitHashSet bitHashSet;
            BitHashSet bitHashSet2 = bitHashSet = entry.getValue();
            synchronized (bitHashSet2) {
                HashSet<Long> hashSet = new HashSet<Long>(bitHashSet.size());
                hashMap.put(entry.getKey(), hashSet);
                for (Integer n2 : bitHashSet) {
                    Watcher watcher = this.watcherBitIdMap.get(n2);
                    if (!(watcher instanceof ServerCnxn)) continue;
                    hashSet.add(((ServerCnxn)watcher).getSessionId());
                }
            }
        }
        return new WatchesPathReport(hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Watcher, Set<String>> getWatcher2PathesMap() {
        HashMap<Watcher, Set<String>> hashMap = new HashMap<Watcher, Set<String>>();
        for (Map.Entry<String, BitHashSet> entry : this.pathWatches.entrySet()) {
            BitHashSet bitHashSet;
            String string = entry.getKey();
            BitHashSet bitHashSet2 = bitHashSet = entry.getValue();
            synchronized (bitHashSet2) {
                for (Integer n2 : bitHashSet) {
                    Watcher watcher = this.watcherBitIdMap.get(n2);
                    if (watcher == null) continue;
                    if (!hashMap.containsKey(watcher)) {
                        hashMap.put(watcher, new HashSet());
                    }
                    ((Set)hashMap.get(watcher)).add(string);
                }
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpWatches(PrintWriter printWriter, boolean bl2) {
        if (bl2) {
            for (Map.Entry<String, BitHashSet> entry : this.pathWatches.entrySet()) {
                BitHashSet bitHashSet;
                printWriter.println(entry.getKey());
                BitHashSet bitHashSet2 = bitHashSet = entry.getValue();
                synchronized (bitHashSet2) {
                    for (Integer n2 : bitHashSet) {
                        Watcher watcher = this.watcherBitIdMap.get(n2);
                        if (!(watcher instanceof ServerCnxn)) continue;
                        printWriter.print("\t0x");
                        printWriter.print(Long.toHexString(((ServerCnxn)watcher).getSessionId()));
                        printWriter.print("\n");
                    }
                }
            }
        } else {
            for (Map.Entry<Watcher, Set<String>> entry : this.getWatcher2PathesMap().entrySet()) {
                printWriter.print("0x");
                printWriter.println(Long.toHexString(((ServerCnxn)entry.getKey()).getSessionId()));
                for (String string : entry.getValue()) {
                    printWriter.print("\t");
                    printWriter.println(string);
                }
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.watcherBitIdMap.size()).append(" connections watching ").append(this.pathSize()).append(" paths\n");
        stringBuilder.append("Total watches:").append(this.size());
        return stringBuilder.toString();
    }
}

