/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class RequestPathMetricsCollector {
    private static final foe LOG = goe.a(RequestPathMetricsCollector.class);
    private final int REQUEST_STATS_SLOT_DURATION;
    private final int REQUEST_STATS_SLOT_CAPACITY;
    private final int REQUEST_PREPROCESS_PATH_DEPTH;
    private final float REQUEST_PREPROCESS_SAMPLE_RATE;
    private final long COLLECTOR_INITIAL_DELAY;
    private final long COLLECTOR_DELAY;
    private final int REQUEST_PREPROCESS_TOPPATH_MAX;
    private final boolean enabled;
    public static final String PATH_STATS_SLOT_CAPACITY = "zookeeper.pathStats.slotCapacity";
    public static final String PATH_STATS_SLOT_DURATION = "zookeeper.pathStats.slotDuration";
    public static final String PATH_STATS_MAX_DEPTH = "zookeeper.pathStats.maxDepth";
    public static final String PATH_STATS_SAMPLE_RATE = "zookeeper.pathStats.sampleRate";
    public static final String PATH_STATS_COLLECTOR_INITIAL_DELAY = "zookeeper.pathStats.initialDelay";
    public static final String PATH_STATS_COLLECTOR_DELAY = "zookeeper.pathStats.delay";
    public static final String PATH_STATS_TOP_PATH_MAX = "zookeeper.pathStats.topPathMax";
    public static final String PATH_STATS_ENABLED = "zookeeper.pathStats.enabled";
    private static final String PATH_SEPERATOR = "/";
    private final Map<String, PathStatsQueue> immutableRequestsMap;
    private final ScheduledThreadPoolExecutor scheduledExecutor;
    private final boolean accurateMode;

    public RequestPathMetricsCollector() {
        this(false);
    }

    public RequestPathMetricsCollector(boolean bl2) {
        HashMap<String, PathStatsQueue> hashMap = new HashMap<String, PathStatsQueue>();
        this.accurateMode = bl2;
        this.REQUEST_PREPROCESS_TOPPATH_MAX = Integer.getInteger(PATH_STATS_TOP_PATH_MAX, 20);
        this.REQUEST_STATS_SLOT_DURATION = Integer.getInteger(PATH_STATS_SLOT_DURATION, 15);
        this.REQUEST_STATS_SLOT_CAPACITY = Integer.getInteger(PATH_STATS_SLOT_CAPACITY, 60);
        this.REQUEST_PREPROCESS_PATH_DEPTH = Integer.getInteger(PATH_STATS_MAX_DEPTH, 6);
        this.REQUEST_PREPROCESS_SAMPLE_RATE = Float.parseFloat(System.getProperty(PATH_STATS_SAMPLE_RATE, "0.1"));
        this.COLLECTOR_INITIAL_DELAY = Long.getLong(PATH_STATS_COLLECTOR_INITIAL_DELAY, 5L);
        this.COLLECTOR_DELAY = Long.getLong(PATH_STATS_COLLECTOR_DELAY, 5L);
        this.enabled = Boolean.getBoolean(PATH_STATS_ENABLED);
        LOG.c("{} = {}", (Object)PATH_STATS_SLOT_CAPACITY, (Object)this.REQUEST_STATS_SLOT_CAPACITY);
        LOG.c("{} = {}", (Object)PATH_STATS_SLOT_DURATION, (Object)this.REQUEST_STATS_SLOT_DURATION);
        LOG.c("{} = {}", (Object)PATH_STATS_MAX_DEPTH, (Object)this.REQUEST_PREPROCESS_PATH_DEPTH);
        LOG.c("{} = {}", (Object)PATH_STATS_COLLECTOR_INITIAL_DELAY, (Object)this.COLLECTOR_INITIAL_DELAY);
        LOG.c("{} = {}", (Object)PATH_STATS_COLLECTOR_DELAY, (Object)this.COLLECTOR_DELAY);
        LOG.c("{} = {}", (Object)PATH_STATS_ENABLED, (Object)this.enabled);
        this.scheduledExecutor = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
        this.scheduledExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.scheduledExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        hashMap.put(Request.op2String(1), new PathStatsQueue(1));
        hashMap.put(Request.op2String(15), new PathStatsQueue(15));
        hashMap.put(Request.op2String(19), new PathStatsQueue(19));
        hashMap.put(Request.op2String(20), new PathStatsQueue(20));
        hashMap.put(Request.op2String(2), new PathStatsQueue(2));
        hashMap.put(Request.op2String(3), new PathStatsQueue(3));
        hashMap.put(Request.op2String(5), new PathStatsQueue(5));
        hashMap.put(Request.op2String(4), new PathStatsQueue(4));
        hashMap.put(Request.op2String(6), new PathStatsQueue(6));
        hashMap.put(Request.op2String(7), new PathStatsQueue(7));
        hashMap.put(Request.op2String(8), new PathStatsQueue(8));
        hashMap.put(Request.op2String(12), new PathStatsQueue(12));
        hashMap.put(Request.op2String(17), new PathStatsQueue(17));
        hashMap.put(Request.op2String(18), new PathStatsQueue(18));
        hashMap.put(Request.op2String(105), new PathStatsQueue(105));
        hashMap.put(Request.op2String(9), new PathStatsQueue(9));
        this.immutableRequestsMap = Collections.unmodifiableMap(hashMap);
    }

    static boolean isWriteOp(int n2) {
        switch (n2) {
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    static String trimPathDepth(String string, int n2) {
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(string, PATH_SEPERATOR);
        while (stringTokenizer.hasMoreElements() && n3++ < n2) {
            stringBuilder.append(PATH_SEPERATOR);
            stringBuilder.append(stringTokenizer.nextToken());
        }
        string = stringBuilder.toString();
        return string;
    }

    public void shutdown() {
        if (!this.enabled) {
            return;
        }
        LOG.c("shutdown scheduledExecutor");
        this.scheduledExecutor.shutdownNow();
    }

    public void start() {
        if (!this.enabled) {
            return;
        }
        LOG.c("Start the RequestPath collector");
        this.immutableRequestsMap.forEach((string, pathStatsQueue) -> pathStatsQueue.start());
        this.scheduledExecutor.scheduleWithFixedDelay(() -> {
            LOG.c("%nHere are the top Read paths:");
            this.logTopPaths(this.aggregatePaths(4, pathStatsQueue -> !pathStatsQueue.isWriteOperation()), entry -> LOG.c("{} : {}", entry.getKey(), entry.getValue()));
            LOG.c("%nHere are the top Write paths:");
            this.logTopPaths(this.aggregatePaths(4, pathStatsQueue -> pathStatsQueue.isWriteOperation()), entry -> LOG.c("{} : {}", entry.getKey(), entry.getValue()));
        }, this.COLLECTOR_INITIAL_DELAY, this.COLLECTOR_DELAY, TimeUnit.MINUTES);
    }

    public void registerRequest(int n2, String string) {
        if (!this.enabled) {
            return;
        }
        if (ThreadLocalRandom.current().nextFloat() <= this.REQUEST_PREPROCESS_SAMPLE_RATE) {
            PathStatsQueue pathStatsQueue = this.immutableRequestsMap.get(Request.op2String(n2));
            if (pathStatsQueue != null) {
                pathStatsQueue.registerRequest(string);
            } else {
                LOG.e("We should not handle {}", (Object)n2);
            }
        }
    }

    public void dumpTopRequestPath(PrintWriter printWriter, String string, int n2) {
        if (n2 < 1) {
            return;
        }
        PathStatsQueue pathStatsQueue = this.immutableRequestsMap.get(string);
        if (pathStatsQueue == null) {
            printWriter.println("Can not find path stats for type: " + string);
            return;
        }
        printWriter.println("The top requests of type: " + string);
        int n3 = Math.min(n2, this.REQUEST_PREPROCESS_PATH_DEPTH);
        Map<String, Integer> map = pathStatsQueue.collectStats(n3);
        this.logTopPaths(map, entry -> printWriter.println((String)entry.getKey() + " : " + entry.getValue()));
    }

    public void dumpTopReadPaths(PrintWriter printWriter, int n2) {
        printWriter.println("The top read requests are");
        this.dumpTopAggregatedPaths(printWriter, n2, pathStatsQueue -> !((PathStatsQueue)pathStatsQueue).isWriteOperation);
    }

    public void dumpTopWritePaths(PrintWriter printWriter, int n2) {
        printWriter.println("The top write requests are");
        this.dumpTopAggregatedPaths(printWriter, n2, pathStatsQueue -> ((PathStatsQueue)pathStatsQueue).isWriteOperation);
    }

    public void dumpTopPaths(PrintWriter printWriter, int n2) {
        printWriter.println("The top requests are");
        this.dumpTopAggregatedPaths(printWriter, n2, pathStatsQueue -> true);
    }

    private void dumpTopAggregatedPaths(PrintWriter printWriter, int n2, Predicate<PathStatsQueue> predicate) {
        if (!this.enabled) {
            return;
        }
        Map<String, Integer> map = this.aggregatePaths(n2, predicate);
        this.logTopPaths(map, entry -> printWriter.println((String)entry.getKey() + " : " + entry.getValue()));
    }

    Map<String, Integer> aggregatePaths(int n2, Predicate<PathStatsQueue> predicate) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(this.REQUEST_PREPROCESS_TOPPATH_MAX);
        int n3 = Math.min(n2, this.REQUEST_PREPROCESS_PATH_DEPTH);
        this.immutableRequestsMap.values().stream().filter(predicate).forEach(pathStatsQueue -> pathStatsQueue.collectStats(n3).forEach((string, n2) -> hashMap.put((String)string, hashMap.getOrDefault(string, 0) + n2)));
        return hashMap;
    }

    void logTopPaths(Map<String, Integer> map, Consumer<Map.Entry<String, Integer>> consumer) {
        map.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue).reversed()).limit(this.REQUEST_PREPROCESS_TOPPATH_MAX).forEach(consumer);
    }

    class PathStatsQueue {
        private final String requestTypeName;
        private final AtomicReference<ConcurrentLinkedQueue<String>> currentSlot;
        private final LinkedBlockingQueue<Map<String, Integer>> requestPathStats;
        private final boolean isWriteOperation;

        public PathStatsQueue(int n2) {
            this.requestTypeName = Request.op2String(n2);
            this.isWriteOperation = RequestPathMetricsCollector.isWriteOp(n2);
            this.requestPathStats = new LinkedBlockingQueue(RequestPathMetricsCollector.this.REQUEST_STATS_SLOT_CAPACITY);
            this.currentSlot = new AtomicReference(new ConcurrentLinkedQueue());
        }

        public void registerRequest(String string) {
            if (!RequestPathMetricsCollector.this.enabled) {
                return;
            }
            this.currentSlot.get().offer(string);
        }

        ConcurrentLinkedQueue<String> getCurrentSlot() {
            return this.currentSlot.get();
        }

        Map<String, Integer> mapReducePaths(int n2, Collection<String> collection) {
            ConcurrentHashMap<String, Integer> concurrentHashMap = new ConcurrentHashMap<String, Integer>();
            collection.stream().filter(string -> string != null).forEach(string -> {
                string = RequestPathMetricsCollector.trimPathDepth(string, n2);
                concurrentHashMap.put((String)string, concurrentHashMap.getOrDefault(string, 0) + 1);
            });
            return concurrentHashMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, Integer> collectStats(int n2) {
            Map<String, Integer> map3;
            Map<String, Integer> map4 = this.mapReducePaths(n2, Arrays.asList(this.currentSlot.get().toArray(new String[0])));
            Object object = RequestPathMetricsCollector.this.accurateMode ? this.requestPathStats : new Object();
            synchronized (object) {
                map3 = this.requestPathStats.stream().reduce(map4, (map, map2) -> {
                    map2.forEach((string, n3) -> {
                        String string2 = RequestPathMetricsCollector.trimPathDepth(string, n2);
                        map.put(string2, map.getOrDefault(string2, 0) + n3);
                    });
                    return map;
                });
            }
            return map3;
        }

        public void start() {
            if (!RequestPathMetricsCollector.this.enabled) {
                return;
            }
            int n2 = ThreadLocalRandom.current().nextInt(RequestPathMetricsCollector.this.REQUEST_STATS_SLOT_DURATION);
            RequestPathMetricsCollector.this.scheduledExecutor.scheduleWithFixedDelay(() -> {
                ConcurrentLinkedQueue<String> concurrentLinkedQueue = this.currentSlot.getAndSet(new ConcurrentLinkedQueue());
                try {
                    Map<String, Integer> map = this.mapReducePaths(RequestPathMetricsCollector.this.REQUEST_PREPROCESS_PATH_DEPTH, concurrentLinkedQueue);
                    Object object = RequestPathMetricsCollector.this.accurateMode ? this.requestPathStats : new Object();
                    synchronized (object) {
                        if (this.requestPathStats.remainingCapacity() <= 0) {
                            this.requestPathStats.poll();
                        }
                        if (!this.requestPathStats.offer(map)) {
                            LOG.e("Failed to insert the new request path stats for {}", (Object)this.requestTypeName);
                        }
                    }
                }
                catch (Exception exception) {
                    LOG.e("Failed to insert the new request path stats for {} with exception {}", (Object)this.requestTypeName, (Object)exception);
                }
            }, n2, RequestPathMetricsCollector.this.REQUEST_STATS_SLOT_DURATION, TimeUnit.SECONDS);
        }

        boolean isWriteOperation() {
            return this.isWriteOperation;
        }
    }
}

