/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Leader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.CircularBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MessageTracker {
    private static final foe LOG = goe.a(MessageTracker.class);
    private final CircularBuffer<BufferedMessage> sentBuffer;
    private final CircularBuffer<BufferedMessage> receivedBuffer;
    public static final String MESSAGE_TRACKER_BUFFER_SIZE = "zookeeper.messageTracker.BufferSize";
    public static final String MESSAGE_TRACKER_ENABLED = "zookeeper.messageTracker.Enabled";
    public static final int BUFFERED_MESSAGE_SIZE = Integer.getInteger("zookeeper.messageTracker.BufferSize", 10);
    private static final boolean enabled = Boolean.getBoolean("zookeeper.messageTracker.Enabled");

    public MessageTracker(int n2) {
        this.sentBuffer = new CircularBuffer<BufferedMessage>(BufferedMessage.class, n2);
        this.receivedBuffer = new CircularBuffer<BufferedMessage>(BufferedMessage.class, n2);
    }

    public void trackSent(long l2) {
        if (enabled) {
            this.sentBuffer.write(new BufferedMessage(l2));
        }
    }

    public void trackSent(int n2) {
        if (enabled) {
            this.sentBuffer.write(new BufferedMessage(n2));
        }
    }

    public void trackReceived(long l2) {
        if (enabled) {
            this.receivedBuffer.write(new BufferedMessage(l2));
        }
    }

    public void trackReceived(int n2) {
        if (enabled) {
            this.receivedBuffer.write(new BufferedMessage(n2));
        }
    }

    public final BufferedMessage peekSent() {
        return this.sentBuffer.peek();
    }

    public final BufferedMessage peekReceived() {
        return this.receivedBuffer.peek();
    }

    public final long peekSentTimestamp() {
        return enabled ? this.sentBuffer.peek().getTimestamp() : 0L;
    }

    public final long peekReceivedTimestamp() {
        return enabled ? this.receivedBuffer.peek().getTimestamp() : 0L;
    }

    public void dumpToLog(String string) {
        if (!enabled) {
            return;
        }
        MessageTracker.logMessages(string, this.receivedBuffer, Direction.RECEIVED);
        MessageTracker.logMessages(string, this.sentBuffer, Direction.SENT);
    }

    private static void logMessages(String string, CircularBuffer<BufferedMessage> circularBuffer, Direction direction) {
        String string2;
        String string3 = string2 = direction == Direction.SENT ? "sentBuffer to" : "receivedBuffer from";
        if (circularBuffer.isEmpty()) {
            LOG.c("No buffered timestamps for messages {} {}", (Object)string2, (Object)string);
        } else {
            LOG.d("Last {} timestamps for messages {} {}:", circularBuffer.size(), string2, string);
            while (!circularBuffer.isEmpty()) {
                LOG.d("{} {}  {}", string2, string, circularBuffer.take().toString());
            }
        }
    }

    static class BufferedMessage {
        private long timestamp;
        private int messageType;

        private long getTimestamp() {
            return this.timestamp;
        }

        BufferedMessage(int n2) {
            this.messageType = n2;
            this.timestamp = System.currentTimeMillis();
        }

        BufferedMessage(long l2) {
            this.messageType = -1;
            this.timestamp = l2;
        }

        public String toString() {
            if (this.messageType == -1) {
                return "TimeStamp: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS").format(new Date(this.timestamp));
            }
            return "TimeStamp: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS").format(new Date(this.timestamp)) + " Type: " + Leader.getPacketType(this.messageType);
        }
    }

    static enum Direction {
        SENT,
        RECEIVED;

    }
}

