/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util;

import XcoreXdatabricksX240X9088.hme;
import XcoreXdatabricksX240X9088.ime;
import XcoreXdatabricksX240X9088.mme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ExitCode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.TxnLogEntry;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileHeader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileTxnLog;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.SerializeUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.ZxidUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnHeader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.util.ServiceUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Adler32;

public class LogChopper {
    public static void main(String[] stringArray) {
        ExitCode exitCode = ExitCode.INVALID_INVOCATION;
        if (stringArray.length != 3) {
            System.out.println("Usage: LogChopper zxid_to_chop_to txn_log_to_chop chopped_filename");
            System.out.println("    this program will read the txn_log_to_chop file and copy all the transactions");
            System.out.println("    from it up to (and including) the given zxid into chopped_filename.");
            ServiceUtils.requestSystemExit(exitCode.getValue());
        }
        String string = stringArray[1];
        String string2 = stringArray[2];
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));){
            long l2 = Long.decode(stringArray[0]);
            if (LogChopper.chop(bufferedInputStream, bufferedOutputStream, l2)) {
                exitCode = ExitCode.EXECUTION_FINISHED;
            }
        }
        catch (Exception exception) {
            System.out.println("Got exception: " + exception.getMessage());
        }
        ServiceUtils.requestSystemExit(exitCode.getValue());
    }

    public static boolean chop(InputStream inputStream, OutputStream outputStream, long l2) throws IOException {
        hme hme2 = hme.a(inputStream);
        ime ime2 = ime.a(outputStream);
        FileHeader fileHeader = new FileHeader();
        fileHeader.deserialize(hme2, "fileheader");
        if (fileHeader.getMagic() != FileTxnLog.TXNLOG_MAGIC) {
            System.err.println("Invalid magic number in txn log file");
            return false;
        }
        System.out.println("ZooKeeper Transactional Log File with dbid " + fileHeader.getDbid() + " txnlog format version " + fileHeader.getVersion());
        fileHeader.serialize(ime2, "fileheader");
        int n2 = 0;
        boolean bl2 = false;
        long l3 = -1L;
        while (true) {
            byte[] byArray;
            long l4;
            try {
                l4 = hme2.d("crcvalue");
                byArray = hme2.f("txnEntry");
            }
            catch (EOFException eOFException) {
                System.out.println("EOF reached after " + n2 + " txns.");
                return false;
            }
            if (byArray.length == 0) {
                System.out.println("EOF reached after " + n2 + " txns.");
                return false;
            }
            Adler32 adler32 = new Adler32();
            adler32.update(byArray, 0, byArray.length);
            if (l4 != adler32.getValue()) {
                throw new IOException("CRC doesn't match " + l4 + " vs " + adler32.getValue());
            }
            TxnLogEntry txnLogEntry = SerializeUtils.deserializeTxn(byArray);
            TxnHeader txnHeader = txnLogEntry.getHeader();
            mme mme2 = txnLogEntry.getTxn();
            if (hme2.a("EOR") != 66) {
                System.out.println("Last transaction was partial.");
                throw new EOFException("Last transaction was partial.");
            }
            long l5 = txnHeader.getZxid();
            if (l5 == l2) {
                bl2 = true;
            }
            if (l3 != -1L && l5 != l3 + 1L) {
                long l6 = ZxidUtils.getEpochFromZxid(l5);
                long l7 = ZxidUtils.getCounterFromZxid(l5);
                long l8 = ZxidUtils.getEpochFromZxid(l3);
                if (l6 == l8) {
                    System.out.println(String.format("There is intra-epoch gap between %x and %x", l3, l5));
                } else if (l7 != 1L) {
                    System.out.println(String.format("There is inter-epoch gap between %x and %x", l3, l5));
                }
            }
            l3 = l5;
            if (l5 > l2) {
                if (n2 == 0 || !bl2) {
                    System.out.println(String.format("This log does not contain zxid %x", l2));
                    return false;
                }
                System.out.println(String.format("Chopping at %x new log has %d records", l2, n2));
                return true;
            }
            ime2.a(l4, "crcvalue");
            ime2.a(byArray, "txnEntry");
            ime2.a((byte)66, "EOR");
            ++n2;
        }
    }
}

