/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Leader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LearnerHandler;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.SyncedLearnerTracker;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FilenameUtils;

public class QuorumOracleMaj
extends QuorumMaj {
    private static final foe LOG = goe.a(QuorumOracleMaj.class);
    private String oracle = null;
    private final AtomicBoolean needOracle = new AtomicBoolean(true);

    public QuorumOracleMaj(Map<Long, QuorumPeer.QuorumServer> map, String string) {
        super(map);
        this.setOracle(string);
    }

    public QuorumOracleMaj(Properties properties, String string) throws QuorumPeerConfig.ConfigException {
        super(properties);
        this.setOracle(string);
    }

    private void setOracle(String string) {
        if (this.oracle == null) {
            this.oracle = string;
            LOG.c("Oracle is set to {}", (Object)string);
        } else {
            LOG.d("Oracle is already set. Ignore:{}", (Object)string);
        }
    }

    @Override
    public boolean updateNeedOracle(List<LearnerHandler> list) {
        this.needOracle.set(list.isEmpty() && super.getVotingMembers().size() == 2);
        return this.needOracle.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean askOracle() {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new FileReader(FilenameUtils.getFullPath((String)this.oracle) + FilenameUtils.getName((String)this.oracle));
            int n2 = inputStreamReader.read();
            LOG.b("Oracle says:{}", (Object)Character.valueOf((char)n2));
            inputStreamReader.close();
            boolean bl2 = (char)n2 == '1';
            return bl2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (this.oracle == null) {
                LOG.e("Oracle is not set, return false");
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    @Override
    public boolean getNeedOracle() {
        return this.needOracle.get();
    }

    @Override
    public String getOraclePath() {
        return this.oracle;
    }

    @Override
    public boolean overrideQuorumDecision(List<LearnerHandler> list) {
        return this.updateNeedOracle(list) && this.askOracle();
    }

    @Override
    public boolean revalidateOutstandingProp(Leader leader, ArrayList<Leader.Proposal> arrayList, long l2) {
        LOG.b("Start Revalidation outstandingProposals");
        try {
            block2: while (arrayList.size() >= 1) {
                arrayList.sort((proposal, proposal2) -> (int)(proposal.getZxid() - proposal2.getZxid()));
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    Leader.Proposal proposal3 = arrayList.get(n2);
                    if (proposal3.getZxid() <= l2) continue;
                    LOG.b("Re-validate outstanding proposal: 0x{} size:{} lastCommitted:{}", Long.toHexString(proposal3.getZxid()), arrayList.size(), Long.toHexString(l2));
                    if (!leader.tryToCommit(proposal3, proposal3.getZxid(), null)) continue block2;
                    l2 = proposal3.getZxid();
                    arrayList.remove(proposal3);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        LOG.b("Finish Revalidation outstandingProposals");
        return true;
    }

    @Override
    public boolean revalidateVoteset(SyncedLearnerTracker syncedLearnerTracker, boolean bl2) {
        return syncedLearnerTracker != null && syncedLearnerTracker.hasAllQuorums() && bl2;
    }

    @Override
    public boolean containsQuorum(Set<Long> set) {
        if (this.oracle == null || this.getVotingMembers().size() > 2) {
            return super.containsQuorum(set);
        }
        if (!super.containsQuorum(set)) {
            if (this.getNeedOracle()) {
                LOG.b("We lose the quorum, but we do not have any valid followers Oracle:{}", (Object)this.askOracle());
                return this.askOracle();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        QuorumOracleMaj quorumOracleMaj = (QuorumOracleMaj)object;
        if (quorumOracleMaj.getVersion() == super.getVersion()) {
            return true;
        }
        if (super.getAllMembers().size() != quorumOracleMaj.getAllMembers().size()) {
            return false;
        }
        for (QuorumPeer.QuorumServer quorumServer : super.getAllMembers().values()) {
            QuorumPeer.QuorumServer quorumServer2 = quorumOracleMaj.getAllMembers().get(quorumServer.id);
            if (quorumServer2 != null && quorumServer.equals(quorumServer2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 43;
    }
}

