/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.auth;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth.DigestLoginModule;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;

public class SaslQuorumServerCallbackHandler
implements CallbackHandler {
    private static final String USER_PREFIX = "user_";
    private static final foe LOG = goe.a(SaslQuorumServerCallbackHandler.class);
    private String userName;
    private final boolean isDigestAuthn;
    private final Map<String, String> credentials;
    private final Set<String> authzHosts;

    public SaslQuorumServerCallbackHandler(Configuration configuration, String string, Set<String> set) throws IOException {
        AppConfigurationEntry[] appConfigurationEntryArray = configuration.getAppConfigurationEntry(string);
        if (appConfigurationEntryArray == null) {
            String string2 = "Could not find a '" + string + "' entry in this configuration: Server cannot start.";
            LOG.e(string2);
            throw new IOException(string2);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        boolean bl2 = true;
        for (AppConfigurationEntry appConfigurationEntry : appConfigurationEntryArray) {
            if (appConfigurationEntry.getLoginModuleName().equals(DigestLoginModule.class.getName())) {
                Map<String, ?> map = appConfigurationEntry.getOptions();
                for (Map.Entry<String, ?> entry : map.entrySet()) {
                    String string3 = entry.getKey();
                    if (!string3.startsWith(USER_PREFIX)) continue;
                    String string4 = string3.substring(USER_PREFIX.length());
                    hashMap.put(string4, (String)entry.getValue());
                }
                continue;
            }
            bl2 = false;
        }
        this.isDigestAuthn = bl2;
        if (bl2) {
            this.credentials = Collections.unmodifiableMap(hashMap);
            LOG.d("Using DIGEST-MD5 for quorum authorization");
        } else {
            this.credentials = Collections.emptyMap();
        }
        this.authzHosts = set;
    }

    @Override
    public void handle(Callback[] callbackArray) throws UnsupportedCallbackException {
        for (Callback callback : callbackArray) {
            if (callback instanceof NameCallback) {
                this.handleNameCallback((NameCallback)callback);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                this.handlePasswordCallback((PasswordCallback)callback);
                continue;
            }
            if (callback instanceof RealmCallback) {
                this.handleRealmCallback((RealmCallback)callback);
                continue;
            }
            if (!(callback instanceof AuthorizeCallback)) continue;
            this.handleAuthorizeCallback((AuthorizeCallback)callback);
        }
    }

    private void handleNameCallback(NameCallback nameCallback) {
        if (this.credentials.get(nameCallback.getDefaultName()) == null) {
            LOG.d("User '{}' not found in list of DIGEST-MD5 authenticateable users.", (Object)nameCallback.getDefaultName());
            return;
        }
        nameCallback.setName(nameCallback.getDefaultName());
        this.userName = nameCallback.getDefaultName();
    }

    private void handlePasswordCallback(PasswordCallback passwordCallback) {
        if (this.credentials.containsKey(this.userName)) {
            passwordCallback.setPassword(this.credentials.get(this.userName).toCharArray());
        } else {
            LOG.d("No password found for user: {}", (Object)this.userName);
        }
    }

    private void handleRealmCallback(RealmCallback realmCallback) {
        LOG.b("QuorumLearner supplied realm: {}", (Object)realmCallback.getDefaultText());
        realmCallback.setText(realmCallback.getDefaultText());
    }

    private void handleAuthorizeCallback(AuthorizeCallback authorizeCallback) {
        String[] stringArray;
        String string = authorizeCallback.getAuthenticationID();
        String string2 = authorizeCallback.getAuthorizationID();
        boolean bl2 = false;
        bl2 = string.equals(string2);
        if (!this.isDigestAuthn && bl2 && !(bl2 = (stringArray = string2.split("[/@]")).length == 3 ? this.authzHosts.contains(stringArray[1]) : false)) {
            LOG.e("SASL authorization completed, {} is not authorized to connect", (Object)string2);
        }
        authorizeCallback.setAuthorized(bl2);
        if (authorizeCallback.isAuthorized()) {
            authorizeCallback.setAuthorizedID(string2);
            LOG.c("Successfully authenticated learner: authenticationID={};  authorizationID={}.", (Object)string, (Object)string2);
        }
        LOG.b("SASL authorization completed, authorized flag set to {}", (Object)authorizeCallback.isAuthorized());
    }
}

