/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.auth;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XcoreXdatabricksX240X9088.hme;
import XcoreXdatabricksX240X9088.ime;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Login;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.ZKConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumAuthPacket;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.auth.QuorumAuth;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.auth.QuorumAuthServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.auth.SaslQuorumServerCallbackHandler;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.util.SecurityUtils;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Set;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;

public class SaslQuorumAuthServer
implements QuorumAuthServer {
    private static final foe LOG = goe.a(SaslQuorumAuthServer.class);
    private static final int MAX_RETRIES = 5;
    private final Login serverLogin;
    private final boolean quorumRequireSasl;

    public SaslQuorumAuthServer(boolean bl2, String string, Set<String> set) throws SaslException {
        this.quorumRequireSasl = bl2;
        try {
            AppConfigurationEntry[] appConfigurationEntryArray = Configuration.getConfiguration().getAppConfigurationEntry(string);
            if (appConfigurationEntryArray == null || appConfigurationEntryArray.length == 0) {
                throw new LoginException(String.format("SASL-authentication failed because the specified JAAS configuration section '%s' could not be found.", string));
            }
            SaslQuorumServerCallbackHandler saslQuorumServerCallbackHandler = new SaslQuorumServerCallbackHandler(Configuration.getConfiguration(), string, set);
            this.serverLogin = new Login(string, saslQuorumServerCallbackHandler, new ZKConfig());
            this.serverLogin.startThreadIfNeeded();
        }
        catch (Throwable throwable) {
            throw new SaslException("Failed to initialize authentication mechanism using SASL", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void authenticate(Socket socket, DataInputStream dataInputStream) throws SaslException {
        DataOutputStream dataOutputStream = null;
        SaslServer saslServer = null;
        try {
            if (!QuorumAuth.nextPacketIsAuth(dataInputStream)) {
                if (this.quorumRequireSasl) {
                    throw new SaslException("Learner not trying to authenticate and authentication is required");
                }
                return;
            }
            byte[] byArray = this.receive(dataInputStream);
            int n2 = 0;
            dataOutputStream = new DataOutputStream(socket.getOutputStream());
            byte[] byArray2 = null;
            saslServer = SecurityUtils.createSaslServer(this.serverLogin.getSubject(), "zookeeper-quorum", "zk-quorum-sasl-md5", this.serverLogin.callbackHandler, LOG);
            while (!saslServer.isComplete()) {
                byArray2 = saslServer.evaluateResponse(byArray);
                if (saslServer.isComplete()) continue;
                if (++n2 > 5) {
                    this.send(dataOutputStream, byArray2, QuorumAuth.Status.ERROR);
                    LOG.d("Failed to authenticate using SASL, server addr: {}, retries={} exceeded.", (Object)socket.getRemoteSocketAddress(), (Object)n2);
                    break;
                }
                this.send(dataOutputStream, byArray2, QuorumAuth.Status.IN_PROGRESS);
                byArray = this.receive(dataInputStream);
            }
            if (saslServer.isComplete()) {
                this.send(dataOutputStream, byArray2, QuorumAuth.Status.SUCCESS);
                LOG.c("Successfully completed the authentication using SASL. learner addr: {}", (Object)socket.getRemoteSocketAddress());
            }
        }
        catch (Exception exception) {
            try {
                if (dataOutputStream != null) {
                    this.send(dataOutputStream, new byte[0], QuorumAuth.Status.ERROR);
                }
            }
            catch (IOException iOException) {
                LOG.c("Exception while sending failed status", iOException);
            }
            if (this.quorumRequireSasl) {
                LOG.d("Failed to authenticate using SASL", exception);
                throw new SaslException("Failed to authenticate using SASL: " + exception.getMessage());
            }
            LOG.c("Failed to authenticate using SASL", exception);
            LOG.d("Maintaining learner connection despite SASL authentication failure. server addr: {}, {}: {}", socket.getRemoteSocketAddress(), "quorum.auth.serverRequireSasl", this.quorumRequireSasl);
        }
        finally {
            if (saslServer != null) {
                try {
                    saslServer.dispose();
                }
                catch (SaslException saslException) {
                    LOG.d("SaslServer dispose() failed", saslException);
                }
            }
        }
    }

    private byte[] receive(DataInputStream dataInputStream) throws IOException {
        QuorumAuthPacket quorumAuthPacket = new QuorumAuthPacket();
        hme hme2 = hme.a(dataInputStream);
        quorumAuthPacket.deserialize(hme2, "qpconnect");
        return quorumAuthPacket.getToken();
    }

    private void send(DataOutputStream dataOutputStream, byte[] byArray, QuorumAuth.Status status) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(dataOutputStream);
        ime ime2 = ime.a(bufferedOutputStream);
        QuorumAuthPacket quorumAuthPacket = byArray == null && status != QuorumAuth.Status.SUCCESS ? QuorumAuth.createPacket(QuorumAuth.Status.IN_PROGRESS, null) : QuorumAuth.createPacket(status, byArray);
        ime2.a(quorumAuthPacket, "qpconnect");
        bufferedOutputStream.flush();
    }
}

