/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.auth;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XcoreXdatabricksX240X9088.hme;
import XcoreXdatabricksX240X9088.ime;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Login;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.SaslClientCallbackHandler;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.ZKConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumAuthPacket;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.auth.QuorumAuth;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.auth.QuorumAuthLearner;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.util.SecurityUtils;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class SaslQuorumAuthLearner
implements QuorumAuthLearner {
    private static final foe LOG = goe.a(SaslQuorumAuthLearner.class);
    private final Login learnerLogin;
    private final boolean quorumRequireSasl;
    private final String quorumServicePrincipal;

    public SaslQuorumAuthLearner(boolean bl2, String string, String string2) throws SaslException {
        this.quorumRequireSasl = bl2;
        this.quorumServicePrincipal = string;
        try {
            AppConfigurationEntry[] appConfigurationEntryArray = Configuration.getConfiguration().getAppConfigurationEntry(string2);
            if (appConfigurationEntryArray == null || appConfigurationEntryArray.length == 0) {
                throw new LoginException(String.format("SASL-authentication failed because the specified JAAS configuration section '%s' could not be found.", string2));
            }
            this.learnerLogin = new Login(string2, new SaslClientCallbackHandler(null, "QuorumLearner"), new ZKConfig());
            this.learnerLogin.startThreadIfNeeded();
        }
        catch (LoginException loginException) {
            throw new SaslException("Failed to initialize authentication mechanism using SASL", loginException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void authenticate(Socket socket, String string) throws IOException {
        if (!this.quorumRequireSasl) {
            LOG.c("Skipping SASL authentication as {}={}", (Object)"quorum.auth.learnerRequireSasl", (Object)this.quorumRequireSasl);
            return;
        }
        SaslClient saslClient = null;
        String string2 = SecurityUtils.getServerPrincipal(this.quorumServicePrincipal, string);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            byte[] byArray = new byte[]{};
            saslClient = SecurityUtils.createSaslClient(this.learnerLogin.getSubject(), string2, "zookeeper-quorum", "zk-quorum-sasl-md5", LOG, "QuorumLearner");
            if (saslClient.hasInitialResponse()) {
                byArray = this.createSaslToken(new byte[0], saslClient, this.learnerLogin);
            }
            this.send(dataOutputStream, byArray);
            QuorumAuthPacket quorumAuthPacket = this.receive(dataInputStream);
            QuorumAuth.Status status = QuorumAuth.Status.getStatus(quorumAuthPacket.getStatus());
            block12: while (!saslClient.isComplete()) {
                switch (status) {
                    case SUCCESS: {
                        byArray = this.createSaslToken(quorumAuthPacket.getToken(), saslClient, this.learnerLogin);
                        if (byArray == null) continue block12;
                        throw new SaslException("Protocol error: attempting to send response after completion");
                    }
                    case IN_PROGRESS: {
                        byArray = this.createSaslToken(quorumAuthPacket.getToken(), saslClient, this.learnerLogin);
                        this.send(dataOutputStream, byArray);
                        quorumAuthPacket = this.receive(dataInputStream);
                        status = QuorumAuth.Status.getStatus(quorumAuthPacket.getStatus());
                        continue block12;
                    }
                    case ERROR: {
                        throw new SaslException("Authentication failed against server addr: " + socket.getRemoteSocketAddress());
                    }
                }
                LOG.d("Unknown status:{}!", (Object)status);
                throw new SaslException("Authentication failed against server addr: " + socket.getRemoteSocketAddress());
            }
            this.checkAuthStatus(socket, status);
        }
        finally {
            if (saslClient != null) {
                try {
                    saslClient.dispose();
                }
                catch (SaslException saslException) {
                    LOG.d("SaslClient dispose() failed", saslException);
                }
            }
        }
    }

    private void checkAuthStatus(Socket socket, QuorumAuth.Status status) throws SaslException {
        if (status != QuorumAuth.Status.SUCCESS) {
            throw new SaslException("Authentication failed against server addr: " + socket.getRemoteSocketAddress() + ", qpStatus: " + (Object)((Object)status));
        }
        LOG.c("Successfully completed the authentication using SASL. server addr: {}, status: {}", (Object)socket.getRemoteSocketAddress(), (Object)status);
    }

    private QuorumAuthPacket receive(DataInputStream dataInputStream) throws IOException {
        QuorumAuthPacket quorumAuthPacket = new QuorumAuthPacket();
        hme hme2 = hme.a(dataInputStream);
        quorumAuthPacket.deserialize(hme2, "qpconnect");
        return quorumAuthPacket;
    }

    private void send(DataOutputStream dataOutputStream, byte[] byArray) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(dataOutputStream);
        ime ime2 = ime.a(bufferedOutputStream);
        QuorumAuthPacket quorumAuthPacket = QuorumAuth.createPacket(QuorumAuth.Status.IN_PROGRESS, byArray);
        ime2.a(quorumAuthPacket, "qpconnect");
        bufferedOutputStream.flush();
    }

    private byte[] createSaslToken(final byte[] byArray, final SaslClient saslClient, Login login) throws SaslException {
        if (byArray == null) {
            throw new SaslException("Error in authenticating with a Zookeeper Quorum member: the quorum member's saslToken is null.");
        }
        if (login.getSubject() != null) {
            Login login2 = login;
            synchronized (login2) {
                try {
                    byte[] byArray2 = Subject.doAs(login.getSubject(), new PrivilegedExceptionAction<byte[]>(){

                        @Override
                        public byte[] run() throws SaslException {
                            LOG.b("saslClient.evaluateChallenge(len={})", (Object)byArray.length);
                            return saslClient.evaluateChallenge(byArray);
                        }
                    });
                    return byArray2;
                }
                catch (PrivilegedActionException privilegedActionException) {
                    String string = "An error: (" + privilegedActionException + ") occurred when evaluating Zookeeper Quorum Member's received SASL token.";
                    String string2 = "(Mechanism level: Server not found in Kerberos database (7) - UNKNOWN_SERVER)";
                    if (privilegedActionException.toString().indexOf("(Mechanism level: Server not found in Kerberos database (7) - UNKNOWN_SERVER)") > -1) {
                        string = string + " This may be caused by Java's being unable to resolve the Zookeeper Quorum Member's hostname correctly. You may want to try to adding '-Dsun.net.spi.nameservice.provider.1=dns,sun' to your server's JVMFLAGS environment.";
                    }
                    LOG.e(string);
                    throw new SaslException(string, privilegedActionException);
                }
            }
        }
        throw new SaslException("Cannot make SASL token without subject defined. For diagnosis, please look for WARNs and ERRORs in your log related to the Login class.");
    }
}

