/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.SessionTracker;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServerListener;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LocalSessionTracker;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class UpgradeableSessionTracker
implements SessionTracker {
    private static final foe LOG = goe.a(UpgradeableSessionTracker.class);
    private ConcurrentMap<Long, Integer> localSessionsWithTimeouts;
    private ConcurrentMap<Long, Integer> upgradingSessions;
    protected LocalSessionTracker localSessionTracker;
    protected boolean localSessionsEnabled;

    public void start() {
    }

    public void createLocalSessionTracker(SessionTracker.SessionExpirer sessionExpirer, int n2, long l2, ZooKeeperServerListener zooKeeperServerListener) {
        this.localSessionsWithTimeouts = new ConcurrentHashMap<Long, Integer>();
        this.localSessionTracker = new LocalSessionTracker(sessionExpirer, this.localSessionsWithTimeouts, n2, l2, zooKeeperServerListener);
        this.upgradingSessions = new ConcurrentHashMap<Long, Integer>();
    }

    @Override
    public boolean isTrackingSession(long l2) {
        return this.isLocalSession(l2) || this.isGlobalSession(l2);
    }

    public boolean isLocalSession(long l2) {
        return this.localSessionTracker != null && this.localSessionTracker.isTrackingSession(l2);
    }

    @Override
    public boolean isLocalSessionsEnabled() {
        return this.localSessionsEnabled;
    }

    public boolean isUpgradingSession(long l2) {
        return this.upgradingSessions != null && this.upgradingSessions.containsKey(l2);
    }

    public void finishedUpgrading(long l2) {
        if (this.upgradingSessions != null) {
            this.upgradingSessions.remove(l2);
        }
    }

    public abstract boolean isGlobalSession(long var1);

    public int upgradeSession(long l2) {
        if (this.localSessionsWithTimeouts == null) {
            return -1;
        }
        Integer n2 = (Integer)this.localSessionsWithTimeouts.remove(l2);
        if (n2 != null) {
            LOG.c("Upgrading session 0x{}", (Object)Long.toHexString(l2));
            this.trackSession(l2, n2);
            this.upgradingSessions.put(l2, n2);
            this.localSessionTracker.removeSession(l2);
            return n2;
        }
        return -1;
    }

    protected void removeLocalSession(long l2) {
        if (this.localSessionTracker == null) {
            return;
        }
        this.localSessionTracker.removeSession(l2);
    }

    @Override
    public void checkGlobalSession(long l2, Object object) throws KeeperException.SessionExpiredException, KeeperException.SessionMovedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLocalSessionCount() {
        if (this.localSessionsWithTimeouts == null) {
            return 0L;
        }
        return this.localSessionsWithTimeouts.size();
    }

    @Override
    public Set<Long> localSessions() {
        return this.localSessionTracker == null ? Collections.emptySet() : this.localSessionTracker.localSessions();
    }
}

