/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.RequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Learner;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPacket;
import java.io.Flushable;
import java.io.IOException;

public class SendAckRequestProcessor
implements Flushable,
RequestProcessor {
    private static final foe LOG = goe.a(SendAckRequestProcessor.class);
    Learner learner;

    SendAckRequestProcessor(Learner learner) {
        this.learner = learner;
    }

    @Override
    public void processRequest(Request request) {
        if (request.type != 9) {
            QuorumPacket quorumPacket = new QuorumPacket(3, request.getHdr().getZxid(), null, null);
            try {
                request.logLatency(ServerMetrics.getMetrics().PROPOSAL_ACK_CREATION_LATENCY);
                this.learner.writePacket(quorumPacket, false);
            }
            catch (IOException iOException) {
                LOG.c("Closing connection to leader, exception during packet send", iOException);
                try {
                    if (!this.learner.sock.isClosed()) {
                        this.learner.sock.close();
                    }
                }
                catch (IOException iOException2) {
                    LOG.a("Ignoring error closing the connection", iOException2);
                }
            }
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.learner.writePacket(null, true);
        }
        catch (IOException iOException) {
            LOG.c("Closing connection to leader, exception during packet send", iOException);
            try {
                if (!this.learner.sock.isClosed()) {
                    this.learner.sock.close();
                }
            }
            catch (IOException iOException2) {
                LOG.a("Ignoring error closing the connection", iOException2);
            }
        }
    }

    @Override
    public void shutdown() {
    }
}

