/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.NetUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.jmx.ZKMBeanInfo;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.RemotePeerMXBean;
import java.util.stream.Collectors;

public class RemotePeerBean
implements ZKMBeanInfo,
RemotePeerMXBean {
    private QuorumPeer.QuorumServer peer;
    private final QuorumPeer localPeer;

    public RemotePeerBean(QuorumPeer quorumPeer, QuorumPeer.QuorumServer quorumServer) {
        this.peer = quorumServer;
        this.localPeer = quorumPeer;
    }

    public void setQuorumServer(QuorumPeer.QuorumServer quorumServer) {
        this.peer = quorumServer;
    }

    @Override
    public String getName() {
        return "replica." + this.peer.id;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public String getQuorumAddress() {
        return this.peer.addr.getAllAddresses().stream().map(NetUtils::formatInetAddr).collect(Collectors.joining("|"));
    }

    @Override
    public String getElectionAddress() {
        return this.peer.electionAddr.getAllAddresses().stream().map(NetUtils::formatInetAddr).collect(Collectors.joining("|"));
    }

    @Override
    public String getClientAddress() {
        if (null == this.peer.clientAddr) {
            return "";
        }
        return NetUtils.formatInetAddr(this.peer.clientAddr);
    }

    @Override
    public String getLearnerType() {
        return this.peer.type.toString();
    }

    @Override
    public boolean isLeader() {
        return this.localPeer.isLeader(this.peer.getId());
    }
}

