/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.jmx.MBeanRegistry;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataTreeBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.FinalRequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.PrepRequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZKDatabase;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServerBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LearnerSessionTracker;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LocalPeerBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.ReadOnlyBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.ReadOnlyRequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.UpgradeableSessionTracker;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Objects;
import java.util.stream.Collectors;

public class ReadOnlyZooKeeperServer
extends ZooKeeperServer {
    protected final QuorumPeer self;
    private volatile boolean shutdown = false;

    ReadOnlyZooKeeperServer(FileTxnSnapLog fileTxnSnapLog, QuorumPeer quorumPeer, ZKDatabase zKDatabase) {
        super(fileTxnSnapLog, quorumPeer.tickTime, quorumPeer.minSessionTimeout, quorumPeer.maxSessionTimeout, quorumPeer.clientPortListenBacklog, zKDatabase, quorumPeer.getInitialConfig(), quorumPeer.isReconfigEnabled());
        this.self = quorumPeer;
    }

    @Override
    protected void setupRequestProcessors() {
        FinalRequestProcessor finalRequestProcessor = new FinalRequestProcessor(this);
        PrepRequestProcessor prepRequestProcessor = new PrepRequestProcessor(this, finalRequestProcessor);
        prepRequestProcessor.start();
        this.firstProcessor = new ReadOnlyRequestProcessor(this, prepRequestProcessor);
        ((ReadOnlyRequestProcessor)this.firstProcessor).start();
    }

    @Override
    public synchronized void startup() {
        if (this.shutdown) {
            LOG.d("Not starting Read-only server as startup follows shutdown!");
            return;
        }
        this.registerJMX(new ReadOnlyBean(this), this.self.jmxLocalPeerBean);
        super.startup();
        this.self.setZooKeeperServer(this);
        this.self.adminServer.setZooKeeperServer(this);
        LOG.c("Read-only server started");
    }

    @Override
    public void createSessionTracker() {
        this.sessionTracker = new LearnerSessionTracker(this, this.getZKDatabase().getSessionWithTimeOuts(), this.tickTime, this.self.getMyId(), this.self.areLocalSessionsEnabled(), this.getZooKeeperServerListener());
    }

    @Override
    protected void startSessionTracker() {
        ((LearnerSessionTracker)this.sessionTracker).start();
    }

    @Override
    protected void setLocalSessionFlag(Request request) {
        switch (request.type) {
            case -10: {
                if (!this.self.areLocalSessionsEnabled()) break;
                request.setLocalSession(true);
                break;
            }
            case -11: {
                if (((UpgradeableSessionTracker)this.sessionTracker).isLocalSession(request.sessionId)) {
                    request.setLocalSession(true);
                    break;
                }
                LOG.d("Submitting global closeSession request for session 0x{} in ReadOnly mode", (Object)Long.toHexString(request.sessionId));
                break;
            }
        }
    }

    @Override
    protected void validateSession(ServerCnxn serverCnxn, long l2) throws IOException {
        if (((LearnerSessionTracker)this.sessionTracker).isGlobalSession(l2)) {
            String string = "Refusing global session reconnection in RO mode " + serverCnxn.getRemoteSocketAddress();
            LOG.c(string);
            throw new ServerCnxn.CloseRequestException(string, ServerCnxn.DisconnectReason.RENEW_GLOBAL_SESSION_IN_RO_MODE);
        }
    }

    @Override
    protected void registerJMX() {
        try {
            this.jmxDataTreeBean = new DataTreeBean(this.getZKDatabase().getDataTree());
            MBeanRegistry.getInstance().register(this.jmxDataTreeBean, this.jmxServerBean);
        }
        catch (Exception exception) {
            LOG.c("Failed to register with JMX", exception);
            this.jmxDataTreeBean = null;
        }
    }

    public void registerJMX(ZooKeeperServerBean zooKeeperServerBean, LocalPeerBean localPeerBean) {
        try {
            this.jmxServerBean = zooKeeperServerBean;
            MBeanRegistry.getInstance().register(zooKeeperServerBean, localPeerBean);
        }
        catch (Exception exception) {
            LOG.c("Failed to register with JMX", exception);
            this.jmxServerBean = null;
        }
    }

    @Override
    protected void unregisterJMX() {
        try {
            if (this.jmxDataTreeBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxDataTreeBean);
            }
        }
        catch (Exception exception) {
            LOG.c("Failed to unregister with JMX", exception);
        }
        this.jmxDataTreeBean = null;
    }

    protected void unregisterJMX(ZooKeeperServer zooKeeperServer) {
        try {
            if (this.jmxServerBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxServerBean);
            }
        }
        catch (Exception exception) {
            LOG.c("Failed to unregister with JMX", exception);
        }
        this.jmxServerBean = null;
    }

    @Override
    public String getState() {
        return "read-only";
    }

    @Override
    public long getServerId() {
        return this.self.getMyId();
    }

    @Override
    public synchronized void shutdown() {
        if (!this.canShutdown()) {
            LOG.b("ZooKeeper server is not running, so not proceeding to shutdown!");
            return;
        }
        this.shutdown = true;
        this.unregisterJMX(this);
        this.self.setZooKeeperServer(null);
        this.self.closeAllConnections();
        this.self.adminServer.setZooKeeperServer(null);
        super.shutdown();
    }

    @Override
    public void dumpConf(PrintWriter printWriter) {
        super.dumpConf(printWriter);
        printWriter.print("initLimit=");
        printWriter.println(this.self.getInitLimit());
        printWriter.print("syncLimit=");
        printWriter.println(this.self.getSyncLimit());
        printWriter.print("electionAlg=");
        printWriter.println(this.self.getElectionType());
        printWriter.print("electionPort=");
        printWriter.println(this.self.getElectionAddress().getAllPorts().stream().map(Objects::toString).collect(Collectors.joining("|")));
        printWriter.print("quorumPort=");
        printWriter.println(this.self.getQuorumAddress().getAllPorts().stream().map(Objects::toString).collect(Collectors.joining("|")));
        printWriter.print("peerType=");
        printWriter.println(this.self.getLearnerType().ordinal());
    }

    @Override
    protected void setState(ZooKeeperServer.State state) {
        this.state = state;
    }
}

