/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.CreateMode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.MultiOperationRecord;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Op;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.MetricsContext;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.CreateRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.RequestRecord;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZKDatabase;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.UpgradeableSessionTracker;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.CreateSessionTxn;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public abstract class QuorumZooKeeperServer
extends ZooKeeperServer {
    public final QuorumPeer self;
    protected UpgradeableSessionTracker upgradeableSessionTracker;

    protected QuorumZooKeeperServer(FileTxnSnapLog fileTxnSnapLog, int n2, int n3, int n4, int n5, ZKDatabase zKDatabase, QuorumPeer quorumPeer) {
        super(fileTxnSnapLog, n2, n3, n4, n5, zKDatabase, quorumPeer.getInitialConfig(), quorumPeer.isReconfigEnabled());
        this.self = quorumPeer;
    }

    @Override
    protected void startSessionTracker() {
        this.upgradeableSessionTracker = (UpgradeableSessionTracker)this.sessionTracker;
        this.upgradeableSessionTracker.start();
    }

    public Request checkUpgradeSession(Request request) throws IOException, KeeperException {
        if (request.isThrottled()) {
            return null;
        }
        if (request.type != 1 && request.type != 15 && request.type != 14 || !this.upgradeableSessionTracker.isLocalSession(request.sessionId)) {
            return null;
        }
        if (14 == request.type) {
            MultiOperationRecord multiOperationRecord = request.readRequestRecord(MultiOperationRecord::new);
            boolean bl2 = false;
            for (Op op2 : multiOperationRecord) {
                CreateRequest createRequest;
                CreateMode createMode;
                if (op2.getType() != 1 && op2.getType() != 15 || !(createMode = CreateMode.fromFlag((createRequest = (CreateRequest)op2.toRequestRecord()).getFlags())).isEphemeral()) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                return null;
            }
        } else {
            CreateRequest createRequest = request.readRequestRecord(CreateRequest::new);
            CreateMode createMode = CreateMode.fromFlag(createRequest.getFlags());
            if (!createMode.isEphemeral()) {
                return null;
            }
        }
        if (!this.self.isLocalSessionsUpgradingEnabled()) {
            throw new KeeperException.EphemeralOnLocalSessionException();
        }
        return this.makeUpgradeRequest(request.sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Request makeUpgradeRequest(long l2) {
        UpgradeableSessionTracker upgradeableSessionTracker = this.upgradeableSessionTracker;
        synchronized (upgradeableSessionTracker) {
            if (this.upgradeableSessionTracker.isLocalSession(l2)) {
                int n2 = this.upgradeableSessionTracker.upgradeSession(l2);
                CreateSessionTxn createSessionTxn = new CreateSessionTxn(n2);
                return new Request(null, l2, 0, -10, RequestRecord.fromRecord(createSessionTxn), null);
            }
        }
        return null;
    }

    public void upgrade(long l2) {
        Request request = this.makeUpgradeRequest(l2);
        if (request != null) {
            LOG.c("Upgrading session 0x{}", (Object)Long.toHexString(l2));
            this.submitRequest(request);
        }
    }

    @Override
    protected void setLocalSessionFlag(Request request) {
        switch (request.type) {
            case -10: {
                if (!this.self.areLocalSessionsEnabled()) break;
                request.setLocalSession(true);
                break;
            }
            case -11: {
                String string = "global";
                if (this.upgradeableSessionTracker.isLocalSession(request.sessionId)) {
                    request.setLocalSession(true);
                    string = "local";
                }
                LOG.c("Submitting {} closeSession request for session 0x{}", (Object)string, (Object)Long.toHexString(request.sessionId));
                break;
            }
        }
    }

    @Override
    public void dumpConf(PrintWriter printWriter) {
        super.dumpConf(printWriter);
        printWriter.print("initLimit=");
        printWriter.println(this.self.getInitLimit());
        printWriter.print("syncLimit=");
        printWriter.println(this.self.getSyncLimit());
        printWriter.print("electionAlg=");
        printWriter.println(this.self.getElectionType());
        printWriter.print("electionPort=");
        printWriter.println(this.self.getElectionAddress().getAllPorts().stream().map(Objects::toString).collect(Collectors.joining("|")));
        printWriter.print("quorumPort=");
        printWriter.println(this.self.getQuorumAddress().getAllPorts().stream().map(Objects::toString).collect(Collectors.joining("|")));
        printWriter.print("peerType=");
        printWriter.println(this.self.getLearnerType().ordinal());
        printWriter.println("membership: ");
        printWriter.print(this.self.getQuorumVerifier().toString());
    }

    @Override
    protected void setState(ZooKeeperServer.State state) {
        this.state = state;
    }

    @Override
    protected void registerMetrics() {
        super.registerMetrics();
        MetricsContext metricsContext = ServerMetrics.getMetrics().getMetricsProvider().getRootContext();
        metricsContext.registerGauge("quorum_size", () -> this.self.getQuorumSize());
    }

    @Override
    protected void unregisterMetrics() {
        super.unregisterMetrics();
        MetricsContext metricsContext = ServerMetrics.getMetrics().getMetricsProvider().getRootContext();
        metricsContext.unregisterGauge("quorum_size");
    }

    @Override
    public void dumpMonitorValues(BiConsumer<String, Object> biConsumer) {
        super.dumpMonitorValues(biConsumer);
        biConsumer.accept("peer_state", this.self.getDetailedPeerState());
    }
}

