/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.audit.ZKAuditProvider;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.jmx.ManagedUtil;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.MetricsProvider;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.MetricsProviderLifeCycleException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.impl.MetricsProviderBootstrap;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DatadirCleanupManager;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ExitCode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxnFactory;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZKDatabase;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServerMain;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin.AdminServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth.ProviderRegistry;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.JvmPauseMonitor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.util.ServiceUtils;
import java.io.IOException;
import javax.management.JMException;
import javax.security.sasl.SaslException;

public class QuorumPeerMain {
    private static final foe LOG = goe.a(QuorumPeerMain.class);
    private static final String USAGE = "Usage: QuorumPeerMain configfile";
    protected QuorumPeer quorumPeer;

    public static void main(String[] stringArray) {
        QuorumPeerMain quorumPeerMain = new QuorumPeerMain();
        try {
            quorumPeerMain.initializeAndRun(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.d("Invalid arguments, exiting abnormally", illegalArgumentException);
            LOG.c(USAGE);
            System.err.println(USAGE);
            ZKAuditProvider.addServerStartFailureAuditLog();
            ServiceUtils.requestSystemExit(ExitCode.INVALID_INVOCATION.getValue());
        }
        catch (QuorumPeerConfig.ConfigException configException) {
            LOG.d("Invalid config, exiting abnormally", configException);
            System.err.println("Invalid config, exiting abnormally");
            ZKAuditProvider.addServerStartFailureAuditLog();
            ServiceUtils.requestSystemExit(ExitCode.INVALID_INVOCATION.getValue());
        }
        catch (FileTxnSnapLog.DatadirException datadirException) {
            LOG.d("Unable to access datadir, exiting abnormally", datadirException);
            System.err.println("Unable to access datadir, exiting abnormally");
            ZKAuditProvider.addServerStartFailureAuditLog();
            ServiceUtils.requestSystemExit(ExitCode.UNABLE_TO_ACCESS_DATADIR.getValue());
        }
        catch (AdminServer.AdminServerException adminServerException) {
            LOG.d("Unable to start AdminServer, exiting abnormally", adminServerException);
            System.err.println("Unable to start AdminServer, exiting abnormally");
            ZKAuditProvider.addServerStartFailureAuditLog();
            ServiceUtils.requestSystemExit(ExitCode.ERROR_STARTING_ADMIN_SERVER.getValue());
        }
        catch (Exception exception) {
            LOG.d("Unexpected exception, exiting abnormally", exception);
            ZKAuditProvider.addServerStartFailureAuditLog();
            ServiceUtils.requestSystemExit(ExitCode.UNEXPECTED_ERROR.getValue());
        }
        LOG.c("Exiting normally");
        ServiceUtils.requestSystemExit(ExitCode.EXECUTION_FINISHED.getValue());
    }

    protected void initializeAndRun(String[] stringArray) throws QuorumPeerConfig.ConfigException, IOException, AdminServer.AdminServerException {
        QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
        if (stringArray.length == 1) {
            quorumPeerConfig.parse(stringArray[0]);
        }
        DatadirCleanupManager datadirCleanupManager = new DatadirCleanupManager(quorumPeerConfig.getDataDir(), quorumPeerConfig.getDataLogDir(), quorumPeerConfig.getSnapRetainCount(), quorumPeerConfig.getPurgeInterval());
        datadirCleanupManager.start();
        if (stringArray.length == 1 && quorumPeerConfig.isDistributed()) {
            this.runFromConfig(quorumPeerConfig);
        } else {
            LOG.d("Either no config or no quorum defined in config, running in standalone mode");
            ZooKeeperServerMain.main(stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runFromConfig(QuorumPeerConfig quorumPeerConfig) throws IOException, AdminServer.AdminServerException {
        MetricsProvider metricsProvider;
        try {
            ManagedUtil.registerLog4jMBeans();
        }
        catch (JMException jMException) {
            LOG.c("Unable to register log4j JMX control", jMException);
        }
        LOG.c("Starting quorum peer, myid=" + quorumPeerConfig.getServerId());
        try {
            metricsProvider = MetricsProviderBootstrap.startMetricsProvider(quorumPeerConfig.getMetricsProviderClassName(), quorumPeerConfig.getMetricsProviderConfiguration());
        }
        catch (MetricsProviderLifeCycleException metricsProviderLifeCycleException) {
            throw new IOException("Cannot boot MetricsProvider " + quorumPeerConfig.getMetricsProviderClassName(), metricsProviderLifeCycleException);
        }
        try {
            ServerMetrics.metricsProviderInitialized(metricsProvider);
            ProviderRegistry.initialize();
            ServerCnxnFactory serverCnxnFactory = null;
            ServerCnxnFactory serverCnxnFactory2 = null;
            if (quorumPeerConfig.getClientPortAddress() != null) {
                serverCnxnFactory = ServerCnxnFactory.createFactory();
                serverCnxnFactory.configure(quorumPeerConfig.getClientPortAddress(), quorumPeerConfig.getMaxClientCnxns(), quorumPeerConfig.getClientPortListenBacklog(), false);
            }
            if (quorumPeerConfig.getSecureClientPortAddress() != null) {
                serverCnxnFactory2 = ServerCnxnFactory.createFactory();
                serverCnxnFactory2.configure(quorumPeerConfig.getSecureClientPortAddress(), quorumPeerConfig.getMaxClientCnxns(), quorumPeerConfig.getClientPortListenBacklog(), true);
            }
            this.quorumPeer = this.getQuorumPeer();
            this.quorumPeer.setTxnFactory(new FileTxnSnapLog(quorumPeerConfig.getDataLogDir(), quorumPeerConfig.getDataDir()));
            this.quorumPeer.enableLocalSessions(quorumPeerConfig.areLocalSessionsEnabled());
            this.quorumPeer.enableLocalSessionsUpgrading(quorumPeerConfig.isLocalSessionsUpgradingEnabled());
            this.quorumPeer.setElectionType(quorumPeerConfig.getElectionAlg());
            this.quorumPeer.setMyid(quorumPeerConfig.getServerId());
            this.quorumPeer.setTickTime(quorumPeerConfig.getTickTime());
            this.quorumPeer.setMinSessionTimeout(quorumPeerConfig.getMinSessionTimeout());
            this.quorumPeer.setMaxSessionTimeout(quorumPeerConfig.getMaxSessionTimeout());
            this.quorumPeer.setInitLimit(quorumPeerConfig.getInitLimit());
            this.quorumPeer.setSyncLimit(quorumPeerConfig.getSyncLimit());
            this.quorumPeer.setConnectToLearnerMasterLimit(quorumPeerConfig.getConnectToLearnerMasterLimit());
            this.quorumPeer.setObserverMasterPort(quorumPeerConfig.getObserverMasterPort());
            this.quorumPeer.setConfigFileName(quorumPeerConfig.getConfigFilename());
            this.quorumPeer.setClientPortListenBacklog(quorumPeerConfig.getClientPortListenBacklog());
            this.quorumPeer.setZKDatabase(new ZKDatabase(this.quorumPeer.getTxnFactory()));
            this.quorumPeer.setQuorumVerifier(quorumPeerConfig.getQuorumVerifier(), false);
            if (quorumPeerConfig.getLastSeenQuorumVerifier() != null) {
                this.quorumPeer.setLastSeenQuorumVerifier(quorumPeerConfig.getLastSeenQuorumVerifier(), false);
            }
            this.quorumPeer.initConfigInZKDatabase();
            this.quorumPeer.setCnxnFactory(serverCnxnFactory);
            this.quorumPeer.setSecureCnxnFactory(serverCnxnFactory2);
            this.quorumPeer.setSslQuorum(quorumPeerConfig.isSslQuorum());
            this.quorumPeer.setUsePortUnification(quorumPeerConfig.shouldUsePortUnification());
            this.quorumPeer.setLearnerType(quorumPeerConfig.getPeerType());
            this.quorumPeer.setSyncEnabled(quorumPeerConfig.getSyncEnabled());
            this.quorumPeer.setQuorumListenOnAllIPs(quorumPeerConfig.getQuorumListenOnAllIPs());
            if (quorumPeerConfig.sslQuorumReloadCertFiles) {
                this.quorumPeer.getX509Util().enableCertFileReloading();
            }
            this.quorumPeer.setMultiAddressEnabled(quorumPeerConfig.isMultiAddressEnabled());
            this.quorumPeer.setMultiAddressReachabilityCheckEnabled(quorumPeerConfig.isMultiAddressReachabilityCheckEnabled());
            this.quorumPeer.setMultiAddressReachabilityCheckTimeoutMs(quorumPeerConfig.getMultiAddressReachabilityCheckTimeoutMs());
            this.quorumPeer.setQuorumSaslEnabled(quorumPeerConfig.quorumEnableSasl);
            if (this.quorumPeer.isQuorumSaslAuthEnabled()) {
                this.quorumPeer.setQuorumServerSaslRequired(quorumPeerConfig.quorumServerRequireSasl);
                this.quorumPeer.setQuorumLearnerSaslRequired(quorumPeerConfig.quorumLearnerRequireSasl);
                this.quorumPeer.setQuorumServicePrincipal(quorumPeerConfig.quorumServicePrincipal);
                this.quorumPeer.setQuorumServerLoginContext(quorumPeerConfig.quorumServerLoginContext);
                this.quorumPeer.setQuorumLearnerLoginContext(quorumPeerConfig.quorumLearnerLoginContext);
            }
            this.quorumPeer.setQuorumCnxnThreadsSize(quorumPeerConfig.quorumCnxnThreadsSize);
            this.quorumPeer.initialize();
            if (quorumPeerConfig.jvmPauseMonitorToRun) {
                this.quorumPeer.setJvmPauseMonitor(new JvmPauseMonitor(quorumPeerConfig));
            }
            this.quorumPeer.start();
            ZKAuditProvider.addZKStartStopAuditLog();
            this.quorumPeer.join();
        }
        catch (InterruptedException interruptedException) {
            LOG.c("Quorum Peer interrupted", interruptedException);
        }
        finally {
            try {
                metricsProvider.stop();
            }
            catch (Throwable throwable) {
                LOG.c("Error while stopping metrics", throwable);
            }
        }
    }

    public QuorumPeer getQuorumPeer() throws SaslException {
        return new QuorumPeer();
    }

    public void close() {
        if (this.quorumPeer != null) {
            try {
                this.quorumPeer.shutdown();
            }
            finally {
                this.quorumPeer = null;
            }
        }
    }

    public String toString() {
        QuorumPeer quorumPeer = this.quorumPeer;
        return quorumPeer == null ? "" : quorumPeer.toString();
    }
}

