/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.FinalRequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.SyncRequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZKDatabase;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.CommitProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Learner;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LearnerZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Observer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.ObserverRequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;

public class ObserverZooKeeperServer
extends LearnerZooKeeperServer {
    private static final foe LOG = goe.a(ObserverZooKeeperServer.class);
    private boolean syncRequestProcessorEnabled;
    ConcurrentLinkedQueue<Request> pendingSyncs;

    ObserverZooKeeperServer(FileTxnSnapLog fileTxnSnapLog, QuorumPeer quorumPeer, ZKDatabase zKDatabase) throws IOException {
        super(fileTxnSnapLog, quorumPeer.tickTime, quorumPeer.minSessionTimeout, quorumPeer.maxSessionTimeout, quorumPeer.clientPortListenBacklog, zKDatabase, quorumPeer);
        this.syncRequestProcessorEnabled = this.self.getSyncEnabled();
        this.pendingSyncs = new ConcurrentLinkedQueue();
        LOG.c("syncEnabled ={}", (Object)this.syncRequestProcessorEnabled);
    }

    public Observer getObserver() {
        return this.self.observer;
    }

    @Override
    public Learner getLearner() {
        return this.self.observer;
    }

    public void commitRequest(Request request) {
        if (this.syncRequestProcessorEnabled) {
            this.syncProcessor.processRequest(request);
        }
        this.commitProcessor.commit(request);
    }

    @Override
    protected void setupRequestProcessors() {
        FinalRequestProcessor finalRequestProcessor = new FinalRequestProcessor(this);
        this.commitProcessor = new CommitProcessor(finalRequestProcessor, Long.toString(this.getServerId()), true, this.getZooKeeperServerListener());
        this.commitProcessor.start();
        this.firstProcessor = new ObserverRequestProcessor(this, this.commitProcessor);
        ((ObserverRequestProcessor)this.firstProcessor).start();
        if (this.syncRequestProcessorEnabled) {
            this.syncProcessor = new SyncRequestProcessor(this, null);
            this.syncProcessor.start();
        }
    }

    public synchronized void sync() {
        if (this.pendingSyncs.size() == 0) {
            LOG.d("Not expecting a sync.");
            return;
        }
        Request request = (Request)this.pendingSyncs.remove();
        this.commitProcessor.commit(request);
    }

    @Override
    public String getState() {
        return "observer";
    }

    @Override
    public synchronized void shutdown() {
        if (!this.canShutdown()) {
            LOG.b("ZooKeeper server is not running, so not proceeding to shutdown!");
            return;
        }
        super.shutdown();
        if (this.syncRequestProcessorEnabled && this.syncProcessor != null) {
            this.syncProcessor.shutdown();
        }
    }

    @Override
    public void dumpMonitorValues(BiConsumer<String, Object> biConsumer) {
        super.dumpMonitorValues(biConsumer);
        biConsumer.accept("observer_master_id", this.getObserver().getLearnerMasterId());
    }
}

