/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.RequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperCriticalThread;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooTrace;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.ObserverZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.ErrorTxn;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;

public class ObserverRequestProcessor
extends ZooKeeperCriticalThread
implements RequestProcessor {
    private static final foe LOG = goe.a(ObserverRequestProcessor.class);
    ObserverZooKeeperServer zks;
    RequestProcessor nextProcessor;
    LinkedBlockingQueue<Request> queuedRequests = new LinkedBlockingQueue();
    boolean finished = false;

    public ObserverRequestProcessor(ObserverZooKeeperServer observerZooKeeperServer, RequestProcessor requestProcessor) {
        super("ObserverRequestProcessor:" + observerZooKeeperServer.getServerId(), observerZooKeeperServer.getZooKeeperServerListener());
        this.zks = observerZooKeeperServer;
        this.nextProcessor = requestProcessor;
    }

    @Override
    public void run() {
        try {
            while (!this.finished) {
                ServerMetrics.getMetrics().LEARNER_REQUEST_PROCESSOR_QUEUE_SIZE.add(this.queuedRequests.size());
                Request request = this.queuedRequests.take();
                if (LOG.b()) {
                    ZooTrace.logRequest(LOG, 2L, 'F', request, "");
                }
                if (request != Request.requestOfDeath) {
                    if (!this.zks.authWriteRequest(request)) continue;
                    this.nextProcessor.processRequest(request);
                    if (request.isThrottled()) continue;
                    switch (request.type) {
                        case 9: {
                            this.zks.pendingSyncs.add(request);
                            this.zks.getObserver().request(request);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 5: 
                        case 7: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 19: 
                        case 20: 
                        case 21: {
                            this.zks.getObserver().request(request);
                            break;
                        }
                        case -11: 
                        case -10: {
                            if (request.isLocalSession()) break;
                            this.zks.getObserver().request(request);
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (RuntimeException runtimeException) {
            this.handleException(this.getName(), runtimeException);
        }
        catch (Exception exception) {
            this.handleException(this.getName(), exception);
        }
        LOG.c("ObserverRequestProcessor exited loop!");
    }

    @Override
    public void processRequest(Request request) {
        if (!this.finished) {
            Request request2 = null;
            try {
                request2 = this.zks.checkUpgradeSession(request);
            }
            catch (KeeperException keeperException) {
                if (request.getHdr() != null) {
                    request.getHdr().setType(-1);
                    request.setTxn(new ErrorTxn(keeperException.code().intValue()));
                }
                request.setException(keeperException);
                LOG.b("Error creating upgrade request", keeperException);
            }
            catch (IOException iOException) {
                LOG.d("Unexpected error in upgrade", iOException);
            }
            if (request2 != null) {
                this.queuedRequests.add(request2);
            }
            this.queuedRequests.add(request);
        }
    }

    @Override
    public void shutdown() {
        LOG.c("Shutting down");
        this.finished = true;
        this.queuedRequests.clear();
        this.queuedRequests.add(Request.requestOfDeath);
        this.nextProcessor.shutdown();
    }
}

