/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XcoreXdatabricksX240X9088.mme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ObserverBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.TxnLogEntry;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Learner;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LearnerHandler;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.ObserverZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPacket;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.SerializeUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.SetDataTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnDigest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnHeader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;

public class Observer
extends Learner {
    private static final foe LOG = goe.a(Observer.class);
    public static final String OBSERVER_RECONNECT_DELAY_MS = "zookeeper.observer.reconnectDelayMs";
    public static final String OBSERVER_ELECTION_DELAY_MS = "zookeeper.observer.election.DelayMs";
    private static final long reconnectDelayMs = Long.getLong("zookeeper.observer.reconnectDelayMs", 0L);
    private static volatile long observerElectionDelayMs;
    private static final AtomicReference<QuorumPeer.QuorumServer> nextLearnerMaster;
    private QuorumPeer.QuorumServer currentLearnerMaster = null;

    Observer(QuorumPeer quorumPeer, ObserverZooKeeperServer observerZooKeeperServer) {
        this.self = quorumPeer;
        this.zk = observerZooKeeperServer;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Observer ").append(this.sock);
        stringBuilder.append(" pendingRevalidationCount:").append(this.pendingRevalidations.size());
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void observeLeader() throws Exception {
        this.zk.registerJMX(new ObserverBean(this, this.zk), this.self.jmxLocalPeerBean);
        long l2 = 0L;
        boolean bl2 = false;
        try {
            this.self.setZabState(QuorumPeer.ZabState.DISCOVERY);
            QuorumPeer.QuorumServer quorumServer = this.findLearnerMaster();
            try {
                this.connectToLeader(quorumServer.addr, quorumServer.hostname);
                l2 = System.currentTimeMillis();
                long l3 = this.registerWithLeader(16);
                if (this.self.isReconfigStateChange()) {
                    throw new Exception("learned about role change");
                }
                long l4 = Time.currentElapsedTime();
                this.self.setLeaderAddressAndId(quorumServer.addr, quorumServer.getId());
                this.self.setZabState(QuorumPeer.ZabState.SYNCHRONIZATION);
                this.syncWithLeader(l3);
                this.self.setZabState(QuorumPeer.ZabState.BROADCAST);
                bl2 = true;
                long l5 = Time.currentElapsedTime() - l4;
                ServerMetrics.getMetrics().OBSERVER_SYNC_TIME.add(l5);
                QuorumPacket quorumPacket = new QuorumPacket();
                while (this.isRunning() && nextLearnerMaster.get() == null) {
                    this.readPacket(quorumPacket);
                    this.processPacket(quorumPacket);
                }
            }
            catch (Exception exception) {
                LOG.c("Exception when observing the leader", exception);
                this.closeSocket();
                this.pendingRevalidations.clear();
            }
            this.currentLearnerMaster = null;
            this.zk.unregisterJMX(this);
            if (l2 == 0L) return;
        }
        catch (Throwable throwable) {
            this.currentLearnerMaster = null;
            this.zk.unregisterJMX(this);
            if (l2 == 0L) throw throwable;
            long l6 = System.currentTimeMillis() - l2;
            LOG.c("Disconnected from leader (with address: {}). Was connected for {}ms. Sync state: {}", this.leaderAddr, l6, bl2);
            this.messageTracker.dumpToLog(this.leaderAddr.toString());
            throw throwable;
        }
        long l7 = System.currentTimeMillis() - l2;
        LOG.c("Disconnected from leader (with address: {}). Was connected for {}ms. Sync state: {}", this.leaderAddr, l7, bl2);
        this.messageTracker.dumpToLog(this.leaderAddr.toString());
    }

    private QuorumPeer.QuorumServer findLearnerMaster() {
        QuorumPeer.QuorumServer quorumServer;
        QuorumPeer.QuorumServer quorumServer2 = nextLearnerMaster.getAndSet(null);
        if (quorumServer2 != null && this.self.validateLearnerMaster(Long.toString(quorumServer2.id)) == null) {
            LOG.d("requested next learner master {} is no longer valid", (Object)quorumServer2);
            quorumServer2 = null;
        }
        this.currentLearnerMaster = quorumServer = quorumServer2 == null ? this.self.findLearnerMaster(this.findLeader()) : quorumServer2;
        if (quorumServer == null) {
            LOG.d("No learner master found");
        } else {
            LOG.c("Observing new leader sid={} addr={}", (Object)quorumServer.id, (Object)quorumServer.addr);
        }
        return quorumServer;
    }

    protected void processPacket(QuorumPacket quorumPacket) throws Exception {
        switch (quorumPacket.getType()) {
            case 5: {
                this.ping(quorumPacket);
                break;
            }
            case 2: {
                LOG.d("Ignoring proposal");
                break;
            }
            case 4: {
                LOG.d("Ignoring commit");
                break;
            }
            case 12: {
                LOG.e("Received an UPTODATE message after Observer started");
                break;
            }
            case 6: {
                this.revalidate(quorumPacket);
                break;
            }
            case 7: {
                ((ObserverZooKeeperServer)this.zk).sync();
                break;
            }
            case 8: {
                ServerMetrics.getMetrics().LEARNER_COMMIT_RECEIVED_COUNT.add(1L);
                TxnLogEntry txnLogEntry = SerializeUtils.deserializeTxn(quorumPacket.getData());
                TxnHeader txnHeader = txnLogEntry.getHeader();
                mme mme2 = txnLogEntry.getTxn();
                TxnDigest txnDigest = txnLogEntry.getDigest();
                Request request = new Request(txnHeader.getClientId(), txnHeader.getCxid(), txnHeader.getType(), txnHeader, mme2, 0L);
                request.logLatency(ServerMetrics.getMetrics().COMMIT_PROPAGATION_LATENCY);
                request.setTxnDigest(txnDigest);
                ObserverZooKeeperServer observerZooKeeperServer = (ObserverZooKeeperServer)this.zk;
                observerZooKeeperServer.commitRequest(request);
                break;
            }
            case 19: {
                ByteBuffer byteBuffer = ByteBuffer.wrap(quorumPacket.getData());
                long l2 = byteBuffer.getLong();
                byte[] byArray = new byte[byteBuffer.remaining()];
                byteBuffer.get(byArray);
                TxnLogEntry txnLogEntry = SerializeUtils.deserializeTxn(byArray);
                TxnHeader txnHeader = txnLogEntry.getHeader();
                mme mme3 = txnLogEntry.getTxn();
                TxnDigest txnDigest = txnLogEntry.getDigest();
                QuorumVerifier quorumVerifier = this.self.configFromString(new String(((SetDataTxn)mme3).getData(), StandardCharsets.UTF_8));
                Request request = new Request(txnHeader.getClientId(), txnHeader.getCxid(), txnHeader.getType(), txnHeader, mme3, 0L);
                request.setTxnDigest(txnDigest);
                ObserverZooKeeperServer observerZooKeeperServer = (ObserverZooKeeperServer)this.zk;
                boolean bl2 = this.self.processReconfig(quorumVerifier, l2, quorumPacket.getZxid(), true);
                observerZooKeeperServer.commitRequest(request);
                if (!bl2) break;
                throw new Exception("changes proposed in reconfig");
            }
            default: {
                LOG.d("Unknown packet type: {}", (Object)LearnerHandler.packetToString(quorumPacket));
            }
        }
    }

    @Override
    public void shutdown() {
        LOG.c("shutdown Observer");
        super.shutdown();
    }

    static void waitForReconnectDelay() {
        Observer.waitForReconnectDelayHelper(reconnectDelayMs);
    }

    static void waitForObserverElectionDelay() {
        Observer.waitForReconnectDelayHelper(observerElectionDelayMs);
    }

    private static void waitForReconnectDelayHelper(long l2) {
        if (l2 > 0L) {
            long l3 = ThreadLocalRandom.current().nextLong(l2);
            LOG.c("Waiting for {} ms before reconnecting with the leader", (Object)l3);
            try {
                Thread.sleep(l3);
            }
            catch (InterruptedException interruptedException) {
                LOG.c("Interrupted while waiting", interruptedException);
            }
        }
    }

    public long getLearnerMasterId() {
        QuorumPeer.QuorumServer quorumServer = this.currentLearnerMaster;
        return quorumServer == null ? -1L : quorumServer.id;
    }

    public boolean setLearnerMaster(String string) {
        QuorumPeer.QuorumServer quorumServer = this.self.validateLearnerMaster(string);
        if (quorumServer == null) {
            return false;
        }
        if (quorumServer.equals(this.currentLearnerMaster)) {
            LOG.c("Already connected to requested learner master sid={} addr={}", (Object)quorumServer.id, (Object)quorumServer.addr);
            return true;
        }
        LOG.c("Requesting disconnect and reconnect to new learner master sid={} addr={}", (Object)quorumServer.id, (Object)quorumServer.addr);
        nextLearnerMaster.set(quorumServer);
        return true;
    }

    public QuorumPeer.QuorumServer getCurrentLearnerMaster() {
        return this.currentLearnerMaster;
    }

    public static long getObserverElectionDelayMs() {
        return observerElectionDelayMs;
    }

    public static void setObserverElectionDelayMs(long l2) {
        observerElectionDelayMs = l2;
        LOG.c("{} = {}", (Object)OBSERVER_ELECTION_DELAY_MS, (Object)observerElectionDelayMs);
    }

    static {
        LOG.c("{} = {}", (Object)OBSERVER_RECONNECT_DELAY_MS, (Object)reconnectDelayMs);
        observerElectionDelayMs = Long.getLong(OBSERVER_ELECTION_DELAY_MS, 200L);
        LOG.c("{} = {}", (Object)OBSERVER_ELECTION_DELAY_MS, (Object)observerElectionDelayMs);
        nextLearnerMaster = new AtomicReference();
    }
}

