/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public final class MultipleAddresses {
    public static final Duration DEFAULT_TIMEOUT = Duration.ofMillis(1000L);
    private Set<InetSocketAddress> addresses = MultipleAddresses.newConcurrentHashSet();
    private final Duration timeout;

    private static Set<InetSocketAddress> newConcurrentHashSet() {
        return Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public MultipleAddresses() {
        this(Collections.emptyList());
    }

    public MultipleAddresses(Collection<InetSocketAddress> collection) {
        this(collection, DEFAULT_TIMEOUT);
    }

    public MultipleAddresses(InetSocketAddress inetSocketAddress) {
        this(Arrays.asList(inetSocketAddress), DEFAULT_TIMEOUT);
    }

    public MultipleAddresses(Collection<InetSocketAddress> collection, Duration duration) {
        this.addresses.addAll(collection);
        this.timeout = duration;
    }

    public boolean isEmpty() {
        return this.addresses.isEmpty();
    }

    public Set<InetSocketAddress> getAllAddresses() {
        return Collections.unmodifiableSet(this.addresses);
    }

    public Set<InetSocketAddress> getWildcardAddresses() {
        return this.addresses.stream().map(inetSocketAddress -> new InetSocketAddress(inetSocketAddress.getPort())).collect(Collectors.toSet());
    }

    public List<Integer> getAllPorts() {
        return this.addresses.stream().map(InetSocketAddress::getPort).distinct().collect(Collectors.toList());
    }

    public List<String> getAllHostStrings() {
        return this.addresses.stream().map(InetSocketAddress::getHostString).distinct().collect(Collectors.toList());
    }

    public void addAddress(InetSocketAddress inetSocketAddress) {
        this.addresses.add(inetSocketAddress);
    }

    public InetSocketAddress getReachableAddress() throws NoRouteToHostException {
        return this.addresses.parallelStream().filter(this::checkIfAddressIsReachable).findAny().orElseThrow(() -> new NoRouteToHostException("No valid address among " + this.addresses));
    }

    public Set<InetSocketAddress> getAllReachableAddresses() {
        return this.addresses.parallelStream().filter(this::checkIfAddressIsReachable).collect(Collectors.toSet());
    }

    public Set<InetSocketAddress> getAllReachableAddressesOrAll() {
        if (this.addresses.size() == 1) {
            return this.getAllAddresses();
        }
        Set<InetSocketAddress> set = this.getAllReachableAddresses();
        if (set.isEmpty()) {
            return this.getAllAddresses();
        }
        return set;
    }

    public InetSocketAddress getReachableOrOne() {
        InetSocketAddress inetSocketAddress;
        if (this.addresses.size() == 1) {
            return this.getOne();
        }
        try {
            inetSocketAddress = this.getReachableAddress();
        }
        catch (NoRouteToHostException noRouteToHostException) {
            inetSocketAddress = this.getOne();
        }
        return inetSocketAddress;
    }

    public void recreateSocketAddresses() {
        this.addresses = this.addresses.parallelStream().map(this::recreateSocketAddress).collect(Collectors.toCollection(MultipleAddresses::newConcurrentHashSet));
    }

    public InetSocketAddress getOne() {
        return this.addresses.iterator().next();
    }

    public int size() {
        return this.addresses.size();
    }

    private boolean checkIfAddressIsReachable(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress.isUnresolved()) {
            return false;
        }
        try {
            if (inetSocketAddress.getAddress().isReachable((int)this.timeout.toMillis())) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private InetSocketAddress recreateSocketAddress(InetSocketAddress inetSocketAddress) {
        try {
            return new InetSocketAddress(InetAddress.getByName(inetSocketAddress.getHostString()), inetSocketAddress.getPort());
        }
        catch (UnknownHostException unknownHostException) {
            return inetSocketAddress;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MultipleAddresses multipleAddresses = (MultipleAddresses)object;
        return Objects.equals(this.addresses, multipleAddresses.addresses);
    }

    public int hashCode() {
        return Objects.hash(this.addresses);
    }

    public String toString() {
        return this.addresses.stream().map(InetSocketAddress::toString).collect(Collectors.joining("|"));
    }
}

