/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.jmx.MBeanRegistry;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataTreeBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.SyncRequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZKDatabase;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServerBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.CommitProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Learner;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LearnerSessionTracker;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LocalPeerBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumZooKeeperServer;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;

public abstract class LearnerZooKeeperServer
extends QuorumZooKeeperServer {
    protected CommitProcessor commitProcessor;
    protected SyncRequestProcessor syncProcessor;

    public LearnerZooKeeperServer(FileTxnSnapLog fileTxnSnapLog, int n2, int n3, int n4, int n5, ZKDatabase zKDatabase, QuorumPeer quorumPeer) throws IOException {
        super(fileTxnSnapLog, n2, n3, n4, n5, zKDatabase, quorumPeer);
    }

    public abstract Learner getLearner();

    protected Map<Long, Integer> getTouchSnapshot() {
        if (this.sessionTracker != null) {
            return ((LearnerSessionTracker)this.sessionTracker).snapshot();
        }
        Map<Long, Integer> map = Collections.emptyMap();
        return map;
    }

    @Override
    public long getServerId() {
        return this.self.getMyId();
    }

    @Override
    public void createSessionTracker() {
        this.sessionTracker = new LearnerSessionTracker(this, this.getZKDatabase().getSessionWithTimeOuts(), this.tickTime, this.self.getMyId(), this.self.areLocalSessionsEnabled(), this.getZooKeeperServerListener());
    }

    @Override
    protected void revalidateSession(ServerCnxn serverCnxn, long l2, int n2) throws IOException {
        if (this.upgradeableSessionTracker.isLocalSession(l2)) {
            super.revalidateSession(serverCnxn, l2, n2);
        } else {
            this.getLearner().validateSession(serverCnxn, l2, n2);
        }
    }

    @Override
    protected void registerJMX() {
        try {
            this.jmxDataTreeBean = new DataTreeBean(this.getZKDatabase().getDataTree());
            MBeanRegistry.getInstance().register(this.jmxDataTreeBean, this.jmxServerBean);
        }
        catch (Exception exception) {
            LOG.c("Failed to register with JMX", exception);
            this.jmxDataTreeBean = null;
        }
    }

    public void registerJMX(ZooKeeperServerBean zooKeeperServerBean, LocalPeerBean localPeerBean) {
        if (this.self.jmxLeaderElectionBean != null) {
            try {
                MBeanRegistry.getInstance().unregister(this.self.jmxLeaderElectionBean);
            }
            catch (Exception exception) {
                LOG.c("Failed to register with JMX", exception);
            }
            this.self.jmxLeaderElectionBean = null;
        }
        try {
            this.jmxServerBean = zooKeeperServerBean;
            MBeanRegistry.getInstance().register(zooKeeperServerBean, localPeerBean);
        }
        catch (Exception exception) {
            LOG.c("Failed to register with JMX", exception);
            this.jmxServerBean = null;
        }
    }

    @Override
    protected void unregisterJMX() {
        try {
            if (this.jmxDataTreeBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxDataTreeBean);
            }
        }
        catch (Exception exception) {
            LOG.c("Failed to unregister with JMX", exception);
        }
        this.jmxDataTreeBean = null;
    }

    protected void unregisterJMX(Learner learner) {
        try {
            if (this.jmxServerBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxServerBean);
            }
        }
        catch (Exception exception) {
            LOG.c("Failed to unregister with JMX", exception);
        }
        this.jmxServerBean = null;
    }

    @Override
    public synchronized void shutdown() {
        if (!this.canShutdown()) {
            LOG.b("ZooKeeper server is not running, so not proceeding to shutdown!");
            return;
        }
        LOG.c("Shutting down");
        try {
            super.shutdown();
        }
        catch (Exception exception) {
            LOG.c("Ignoring unexpected exception during shutdown", exception);
        }
        try {
            if (this.syncProcessor != null) {
                this.syncProcessor.shutdown();
            }
        }
        catch (Exception exception) {
            LOG.c("Ignoring unexpected exception in syncprocessor shutdown", exception);
        }
    }
}

