/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.jmx.MBeanRegistry;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.Gauge;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.MetricsContext;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ContainerManager;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataTreeBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.FinalRequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.PrepRequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZKDatabase;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.CommitProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Leader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LeaderBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LeaderRequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LeaderSessionTracker;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LearnerHandlerBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LocalPeerBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.ProposalRequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumZooKeeperServer;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.management.JMException;

public class LeaderZooKeeperServer
extends QuorumZooKeeperServer {
    private ContainerManager containerManager;
    CommitProcessor commitProcessor;
    PrepRequestProcessor prepRequestProcessor;

    public LeaderZooKeeperServer(FileTxnSnapLog fileTxnSnapLog, QuorumPeer quorumPeer, ZKDatabase zKDatabase) throws IOException {
        super(fileTxnSnapLog, quorumPeer.tickTime, quorumPeer.minSessionTimeout, quorumPeer.maxSessionTimeout, quorumPeer.clientPortListenBacklog, zKDatabase, quorumPeer);
    }

    public Leader getLeader() {
        return this.self.leader;
    }

    @Override
    protected void setupRequestProcessors() {
        FinalRequestProcessor finalRequestProcessor = new FinalRequestProcessor(this);
        Leader.ToBeAppliedRequestProcessor toBeAppliedRequestProcessor = new Leader.ToBeAppliedRequestProcessor(finalRequestProcessor, this.getLeader());
        this.commitProcessor = new CommitProcessor(toBeAppliedRequestProcessor, Long.toString(this.getServerId()), false, this.getZooKeeperServerListener());
        this.commitProcessor.start();
        ProposalRequestProcessor proposalRequestProcessor = new ProposalRequestProcessor(this, this.commitProcessor);
        proposalRequestProcessor.initialize();
        this.prepRequestProcessor = new PrepRequestProcessor(this, proposalRequestProcessor);
        this.prepRequestProcessor.start();
        this.firstProcessor = new LeaderRequestProcessor(this, this.prepRequestProcessor);
        this.setupContainerManager();
    }

    private synchronized void setupContainerManager() {
        this.containerManager = new ContainerManager(this.getZKDatabase(), this.prepRequestProcessor, Integer.getInteger("znode.container.checkIntervalMs", (int)TimeUnit.MINUTES.toMillis(1L)), Integer.getInteger("znode.container.maxPerMinute", 10000), Long.getLong("znode.container.maxNeverUsedIntervalMs", 0L));
    }

    @Override
    public synchronized void startup() {
        super.startup();
        if (this.containerManager != null) {
            this.containerManager.start();
        }
    }

    @Override
    protected void registerMetrics() {
        super.registerMetrics();
        MetricsContext metricsContext = ServerMetrics.getMetrics().getMetricsProvider().getRootContext();
        metricsContext.registerGauge("learners", this.gaugeWithLeader(leader -> leader.getLearners().size()));
        metricsContext.registerGauge("synced_followers", this.gaugeWithLeader(leader -> leader.getForwardingFollowers().size()));
        metricsContext.registerGauge("synced_non_voting_followers", this.gaugeWithLeader(leader -> leader.getNonVotingFollowers().size()));
        metricsContext.registerGauge("synced_observers", this.self::getSynced_observers_metric);
        metricsContext.registerGauge("pending_syncs", this.gaugeWithLeader(leader -> leader.getNumPendingSyncs()));
        metricsContext.registerGauge("leader_uptime", this.gaugeWithLeader(leader -> leader.getUptime()));
        metricsContext.registerGauge("last_proposal_size", this.gaugeWithLeader(leader -> leader.getProposalStats().getLastBufferSize()));
        metricsContext.registerGauge("max_proposal_size", this.gaugeWithLeader(leader -> leader.getProposalStats().getMaxBufferSize()));
        metricsContext.registerGauge("min_proposal_size", this.gaugeWithLeader(leader -> leader.getProposalStats().getMinBufferSize()));
    }

    private Gauge gaugeWithLeader(Function<Leader, Number> function) {
        return () -> {
            Leader leader = this.getLeader();
            if (leader == null) {
                return null;
            }
            return (Number)function.apply(leader);
        };
    }

    @Override
    protected void unregisterMetrics() {
        super.unregisterMetrics();
        MetricsContext metricsContext = ServerMetrics.getMetrics().getMetricsProvider().getRootContext();
        metricsContext.unregisterGauge("learners");
        metricsContext.unregisterGauge("synced_followers");
        metricsContext.unregisterGauge("synced_non_voting_followers");
        metricsContext.unregisterGauge("synced_observers");
        metricsContext.unregisterGauge("pending_syncs");
        metricsContext.unregisterGauge("leader_uptime");
        metricsContext.unregisterGauge("last_proposal_size");
        metricsContext.unregisterGauge("max_proposal_size");
        metricsContext.unregisterGauge("min_proposal_size");
    }

    @Override
    public synchronized void shutdown() {
        if (this.containerManager != null) {
            this.containerManager.stop();
        }
        super.shutdown();
    }

    @Override
    public int getGlobalOutstandingLimit() {
        int n2 = this.self.getQuorumSize() > 2 ? this.self.getQuorumSize() - 1 : 1;
        int n3 = super.getGlobalOutstandingLimit() / n2;
        return n3;
    }

    @Override
    public void createSessionTracker() {
        this.sessionTracker = new LeaderSessionTracker(this, this.getZKDatabase().getSessionWithTimeOuts(), this.tickTime, this.self.getMyId(), this.self.areLocalSessionsEnabled(), this.getZooKeeperServerListener());
    }

    public boolean touch(long l2, int n2) {
        return this.sessionTracker.touchSession(l2, n2);
    }

    public boolean checkIfValidGlobalSession(long l2, int n2) {
        if (this.self.areLocalSessionsEnabled() && !this.upgradeableSessionTracker.isGlobalSession(l2)) {
            return false;
        }
        return this.sessionTracker.touchSession(l2, n2);
    }

    public void submitLearnerRequest(Request request) {
        this.prepRequestProcessor.processRequest(request);
    }

    @Override
    protected void registerJMX() {
        try {
            this.jmxDataTreeBean = new DataTreeBean(this.getZKDatabase().getDataTree());
            MBeanRegistry.getInstance().register(this.jmxDataTreeBean, this.jmxServerBean);
        }
        catch (Exception exception) {
            LOG.c("Failed to register with JMX", exception);
            this.jmxDataTreeBean = null;
        }
    }

    public void registerJMX(LeaderBean leaderBean, LocalPeerBean localPeerBean) {
        if (this.self.jmxLeaderElectionBean != null) {
            try {
                MBeanRegistry.getInstance().unregister(this.self.jmxLeaderElectionBean);
            }
            catch (Exception exception) {
                LOG.c("Failed to register with JMX", exception);
            }
            this.self.jmxLeaderElectionBean = null;
        }
        try {
            this.jmxServerBean = leaderBean;
            MBeanRegistry.getInstance().register(leaderBean, localPeerBean);
        }
        catch (Exception exception) {
            LOG.c("Failed to register with JMX", exception);
            this.jmxServerBean = null;
        }
    }

    boolean registerJMX(LearnerHandlerBean learnerHandlerBean) {
        try {
            MBeanRegistry.getInstance().register(learnerHandlerBean, this.jmxServerBean);
            return true;
        }
        catch (JMException jMException) {
            LOG.c("Could not register connection", jMException);
            return false;
        }
    }

    @Override
    protected void unregisterJMX() {
        try {
            if (this.jmxDataTreeBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxDataTreeBean);
            }
        }
        catch (Exception exception) {
            LOG.c("Failed to unregister with JMX", exception);
        }
        this.jmxDataTreeBean = null;
    }

    protected void unregisterJMX(Leader leader) {
        try {
            if (this.jmxServerBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxServerBean);
            }
        }
        catch (Exception exception) {
            LOG.c("Failed to unregister with JMX", exception);
        }
        this.jmxServerBean = null;
    }

    @Override
    public String getState() {
        return "leader";
    }

    @Override
    public long getServerId() {
        return this.self.getMyId();
    }

    @Override
    protected void revalidateSession(ServerCnxn serverCnxn, long l2, int n2) throws IOException {
        super.revalidateSession(serverCnxn, l2, n2);
        try {
            this.setOwner(l2, ServerCnxn.me);
        }
        catch (KeeperException.SessionExpiredException sessionExpiredException) {
            // empty catch block
        }
    }
}

