/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.SessionTracker;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.SessionTrackerImpl;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServerListener;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.UpgradeableSessionTracker;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;

public class LeaderSessionTracker
extends UpgradeableSessionTracker {
    private static final foe LOG = goe.a(LeaderSessionTracker.class);
    private final SessionTrackerImpl globalSessionTracker;
    private final long serverId;

    public LeaderSessionTracker(SessionTracker.SessionExpirer sessionExpirer, ConcurrentMap<Long, Integer> concurrentMap, int n2, long l2, boolean bl2, ZooKeeperServerListener zooKeeperServerListener) {
        this.globalSessionTracker = new SessionTrackerImpl(sessionExpirer, concurrentMap, n2, l2, zooKeeperServerListener);
        this.localSessionsEnabled = bl2;
        if (this.localSessionsEnabled) {
            this.createLocalSessionTracker(sessionExpirer, n2, l2, zooKeeperServerListener);
        }
        this.serverId = l2;
    }

    @Override
    public void removeSession(long l2) {
        if (this.localSessionTracker != null) {
            this.localSessionTracker.removeSession(l2);
        }
        this.globalSessionTracker.removeSession(l2);
    }

    @Override
    public void start() {
        this.globalSessionTracker.start();
        if (this.localSessionTracker != null) {
            this.localSessionTracker.start();
        }
    }

    @Override
    public void shutdown() {
        if (this.localSessionTracker != null) {
            this.localSessionTracker.shutdown();
        }
        this.globalSessionTracker.shutdown();
    }

    @Override
    public boolean isGlobalSession(long l2) {
        return this.globalSessionTracker.isTrackingSession(l2);
    }

    @Override
    public boolean trackSession(long l2, int n2) {
        boolean bl2 = this.globalSessionTracker.trackSession(l2, n2);
        if (this.localSessionsEnabled && bl2) {
            LOG.c("Tracking global session 0x{}", (Object)Long.toHexString(l2));
        }
        return bl2;
    }

    @Override
    public synchronized boolean commitSession(long l2, int n2) {
        boolean bl2 = this.globalSessionTracker.commitSession(l2, n2);
        if (bl2) {
            LOG.c("Committing global session 0x{}", (Object)Long.toHexString(l2));
        }
        if (this.localSessionsEnabled) {
            this.removeLocalSession(l2);
            this.finishedUpgrading(l2);
        }
        return bl2;
    }

    @Override
    public boolean touchSession(long l2, int n2) {
        if (this.localSessionTracker != null && this.localSessionTracker.touchSession(l2, n2)) {
            return true;
        }
        return this.globalSessionTracker.touchSession(l2, n2);
    }

    @Override
    public long createSession(int n2) {
        if (this.localSessionsEnabled) {
            return this.localSessionTracker.createSession(n2);
        }
        return this.globalSessionTracker.createSession(n2);
    }

    public static long getServerIdFromSessionId(long l2) {
        return l2 >> 56;
    }

    @Override
    public void checkSession(long l2, Object object) throws KeeperException.SessionExpiredException, KeeperException.SessionMovedException, KeeperException.UnknownSessionException {
        if (this.localSessionTracker != null) {
            try {
                this.localSessionTracker.checkSession(l2, object);
                if (!this.isGlobalSession(l2)) {
                    return;
                }
            }
            catch (KeeperException.UnknownSessionException unknownSessionException) {
                // empty catch block
            }
        }
        try {
            this.globalSessionTracker.checkSession(l2, object);
            return;
        }
        catch (KeeperException.UnknownSessionException unknownSessionException) {
            if (!this.localSessionsEnabled || LeaderSessionTracker.getServerIdFromSessionId(l2) == this.serverId) {
                throw new KeeperException.SessionExpiredException();
            }
            return;
        }
    }

    @Override
    public void checkGlobalSession(long l2, Object object) throws KeeperException.SessionExpiredException, KeeperException.SessionMovedException {
        try {
            this.globalSessionTracker.checkSession(l2, object);
        }
        catch (KeeperException.UnknownSessionException unknownSessionException) {
            throw new KeeperException.SessionExpiredException();
        }
    }

    @Override
    public void setOwner(long l2, Object object) throws KeeperException.SessionExpiredException {
        if (this.localSessionTracker != null) {
            try {
                this.localSessionTracker.setOwner(l2, object);
                return;
            }
            catch (KeeperException.SessionExpiredException sessionExpiredException) {
                // empty catch block
            }
        }
        this.globalSessionTracker.setOwner(l2, object);
    }

    @Override
    public void dumpSessions(PrintWriter printWriter) {
        if (this.localSessionTracker != null) {
            printWriter.print("Local ");
            this.localSessionTracker.dumpSessions(printWriter);
            printWriter.print("Global ");
        }
        this.globalSessionTracker.dumpSessions(printWriter);
    }

    @Override
    public void setSessionClosing(long l2) {
        if (this.localSessionTracker != null) {
            this.localSessionTracker.setSessionClosing(l2);
        }
        this.globalSessionTracker.setSessionClosing(l2);
    }

    @Override
    public Map<Long, Set<Long>> getSessionExpiryMap() {
        Map<Long, Set<Long>> map = this.localSessionTracker != null ? this.localSessionTracker.getSessionExpiryMap() : new TreeMap<Long, Set<Long>>();
        map.putAll(this.globalSessionTracker.getSessionExpiryMap());
        return map;
    }

    @Override
    public Set<Long> globalSessions() {
        return this.globalSessionTracker.globalSessions();
    }
}

