/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.jmx.MBeanRegistry;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperThread;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Election;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LeaderElectionBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumCnxManager;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.SyncedLearnerTracker;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Vote;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible.QuorumOracleMaj;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.ZxidUtils;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class FastLeaderElection
implements Election {
    private static final foe LOG = goe.a(FastLeaderElection.class);
    static final int finalizeWait = 200;
    private static int maxNotificationInterval = 60000;
    private static int minNotificationInterval = 200;
    public static final String MIN_NOTIFICATION_INTERVAL = "zookeeper.fastleader.minNotificationInterval";
    public static final String MAX_NOTIFICATION_INTERVAL = "zookeeper.fastleader.maxNotificationInterval";
    QuorumCnxManager manager;
    private SyncedLearnerTracker leadingVoteSet;
    static byte[] dummyData;
    LinkedBlockingQueue<ToSend> sendqueue;
    LinkedBlockingQueue<Notification> recvqueue;
    QuorumPeer self;
    Messenger messenger;
    AtomicLong logicalclock = new AtomicLong();
    long proposedLeader;
    long proposedZxid;
    long proposedEpoch;
    volatile boolean stop = false;

    public long getLogicalClock() {
        return this.logicalclock.get();
    }

    static ByteBuffer buildMsg(int n2, long l2, long l3, long l4, long l5) {
        byte[] byArray = new byte[40];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.clear();
        byteBuffer.putInt(n2);
        byteBuffer.putLong(l2);
        byteBuffer.putLong(l3);
        byteBuffer.putLong(l4);
        byteBuffer.putLong(l5);
        byteBuffer.putInt(1);
        return byteBuffer;
    }

    static ByteBuffer buildMsg(int n2, long l2, long l3, long l4, long l5, byte[] byArray) {
        byte[] byArray2 = new byte[44 + byArray.length];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
        byteBuffer.clear();
        byteBuffer.putInt(n2);
        byteBuffer.putLong(l2);
        byteBuffer.putLong(l3);
        byteBuffer.putLong(l4);
        byteBuffer.putLong(l5);
        byteBuffer.putInt(2);
        byteBuffer.putInt(byArray.length);
        byteBuffer.put(byArray);
        return byteBuffer;
    }

    public FastLeaderElection(QuorumPeer quorumPeer, QuorumCnxManager quorumCnxManager) {
        this.manager = quorumCnxManager;
        this.starter(quorumPeer, quorumCnxManager);
    }

    private void starter(QuorumPeer quorumPeer, QuorumCnxManager quorumCnxManager) {
        this.self = quorumPeer;
        this.proposedLeader = -1L;
        this.proposedZxid = -1L;
        this.sendqueue = new LinkedBlockingQueue();
        this.recvqueue = new LinkedBlockingQueue();
        this.messenger = new Messenger(quorumCnxManager);
    }

    public void start() {
        this.messenger.start();
    }

    private void leaveInstance(Vote vote) {
        LOG.b("About to leave FLE instance: leader={}, zxid=0x{}, my id={}, my state={}", new Object[]{vote.getId(), Long.toHexString(vote.getZxid()), this.self.getMyId(), this.self.getPeerState()});
        this.recvqueue.clear();
    }

    public QuorumCnxManager getCnxManager() {
        return this.manager;
    }

    @Override
    public void shutdown() {
        this.stop = true;
        this.proposedLeader = -1L;
        this.proposedZxid = -1L;
        this.leadingVoteSet = null;
        LOG.b("Shutting down connection manager");
        this.manager.halt();
        LOG.b("Shutting down messenger");
        this.messenger.halt();
        LOG.b("FLE is down");
    }

    private void sendNotifications() {
        for (long l2 : this.self.getCurrentAndNextConfigVoters()) {
            QuorumVerifier quorumVerifier = this.self.getQuorumVerifier();
            ToSend toSend = new ToSend(ToSend.mType.notification, this.proposedLeader, this.proposedZxid, this.logicalclock.get(), QuorumPeer.ServerState.LOOKING, l2, this.proposedEpoch, quorumVerifier.toString().getBytes(StandardCharsets.UTF_8));
            LOG.b("Sending Notification: {} (n.leader), 0x{} (n.zxid), 0x{} (n.peerEpoch), 0x{} (n.round), {} (recipient), {} (myid) ", this.proposedLeader, Long.toHexString(this.proposedZxid), Long.toHexString(this.proposedEpoch), Long.toHexString(this.logicalclock.get()), l2, this.self.getMyId());
            this.sendqueue.offer(toSend);
        }
    }

    protected boolean totalOrderPredicate(long l2, long l3, long l4, long l5, long l6, long l7) {
        LOG.b("id: {}, proposed id: {}, zxid: 0x{}, proposed zxid: 0x{}, epoch: 0x{}, proposed epoch: 0x{}", l2, l5, Long.toHexString(l3), Long.toHexString(l6), Long.toHexString(l4), Long.toHexString(l7));
        if (this.self.getQuorumVerifier().getWeight(l2) == 0L) {
            return false;
        }
        return l4 > l7 || l4 == l7 && (l3 > l6 || l3 == l6 && l2 > l5);
    }

    protected SyncedLearnerTracker getVoteTracker(Map<Long, Vote> map, Vote vote) {
        SyncedLearnerTracker syncedLearnerTracker = new SyncedLearnerTracker();
        syncedLearnerTracker.addQuorumVerifier(this.self.getQuorumVerifier());
        if (this.self.getLastSeenQuorumVerifier() != null && this.self.getLastSeenQuorumVerifier().getVersion() > this.self.getQuorumVerifier().getVersion()) {
            syncedLearnerTracker.addQuorumVerifier(this.self.getLastSeenQuorumVerifier());
        }
        for (Map.Entry<Long, Vote> entry : map.entrySet()) {
            if (!vote.equals(entry.getValue())) continue;
            syncedLearnerTracker.addAck(entry.getKey());
        }
        return syncedLearnerTracker;
    }

    protected boolean checkLeader(Map<Long, Vote> map, long l2, long l3) {
        boolean bl2 = true;
        if (l2 != this.self.getMyId()) {
            if (map.get(l2) == null) {
                bl2 = false;
            } else if (map.get(l2).getState() != QuorumPeer.ServerState.LEADING) {
                bl2 = false;
            }
        } else if (this.logicalclock.get() != l3) {
            bl2 = false;
        }
        return bl2;
    }

    synchronized void updateProposal(long l2, long l3, long l4) {
        LOG.b("Updating proposal: {} (newleader), 0x{} (newzxid), {} (oldleader), 0x{} (oldzxid)", l2, Long.toHexString(l3), this.proposedLeader, Long.toHexString(this.proposedZxid));
        this.proposedLeader = l2;
        this.proposedZxid = l3;
        this.proposedEpoch = l4;
    }

    public synchronized Vote getVote() {
        return new Vote(this.proposedLeader, this.proposedZxid, this.proposedEpoch);
    }

    private QuorumPeer.ServerState learningState() {
        if (this.self.getLearnerType() == QuorumPeer.LearnerType.PARTICIPANT) {
            LOG.b("I am a participant: {}", (Object)this.self.getMyId());
            return QuorumPeer.ServerState.FOLLOWING;
        }
        LOG.b("I am an observer: {}", (Object)this.self.getMyId());
        return QuorumPeer.ServerState.OBSERVING;
    }

    private long getInitId() {
        if (this.self.getQuorumVerifier().getVotingMembers().containsKey(this.self.getMyId())) {
            return this.self.getMyId();
        }
        return Long.MIN_VALUE;
    }

    private long getInitLastLoggedZxid() {
        if (this.self.getLearnerType() == QuorumPeer.LearnerType.PARTICIPANT) {
            return this.self.getLastLoggedZxid();
        }
        return Long.MIN_VALUE;
    }

    private long getPeerEpoch() {
        if (this.self.getLearnerType() == QuorumPeer.LearnerType.PARTICIPANT) {
            try {
                return this.self.getCurrentEpoch();
            }
            catch (IOException iOException) {
                RuntimeException runtimeException = new RuntimeException(iOException.getMessage());
                runtimeException.setStackTrace(iOException.getStackTrace());
                throw runtimeException;
            }
        }
        return Long.MIN_VALUE;
    }

    private void setPeerState(long l2, SyncedLearnerTracker syncedLearnerTracker) {
        QuorumPeer.ServerState serverState = l2 == this.self.getMyId() ? QuorumPeer.ServerState.LEADING : this.learningState();
        this.self.setPeerState(serverState);
        if (serverState == QuorumPeer.ServerState.LEADING) {
            this.leadingVoteSet = syncedLearnerTracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vote lookForLeader() throws InterruptedException {
        try {
            this.self.jmxLeaderElectionBean = new LeaderElectionBean();
            MBeanRegistry.getInstance().register(this.self.jmxLeaderElectionBean, this.self.jmxLocalPeerBean);
        }
        catch (Exception exception) {
            LOG.c("Failed to register with JMX", exception);
            this.self.jmxLeaderElectionBean = null;
        }
        this.self.start_fle = Time.currentElapsedTime();
        try {
            Notification notification;
            HashMap<Long, Vote> hashMap = new HashMap<Long, Vote>();
            HashMap<Long, Vote> hashMap2 = new HashMap<Long, Vote>();
            int n2 = minNotificationInterval;
            Object object = this;
            synchronized (object) {
                this.logicalclock.incrementAndGet();
                this.updateProposal(this.getInitId(), this.getInitLastLoggedZxid(), this.getPeerEpoch());
            }
            LOG.c("New election. My id = {}, proposed zxid=0x{}", (Object)this.self.getMyId(), (Object)Long.toHexString(this.proposedZxid));
            this.sendNotifications();
            object = null;
            block30: while (this.self.getPeerState() == QuorumPeer.ServerState.LOOKING && !this.stop) {
                Vote vote;
                Vote vote2;
                notification = this.recvqueue.poll(n2, TimeUnit.MILLISECONDS);
                if (notification == null) {
                    if (this.manager.haveDelivered()) {
                        this.sendNotifications();
                    } else {
                        this.manager.connectAll();
                    }
                    n2 = Math.min(n2 << 1, maxNotificationInterval);
                    if (this.self.getQuorumVerifier() instanceof QuorumOracleMaj && this.self.getQuorumVerifier().revalidateVoteset((SyncedLearnerTracker)object, n2 != minNotificationInterval)) {
                        this.setPeerState(this.proposedLeader, (SyncedLearnerTracker)object);
                        vote2 = new Vote(this.proposedLeader, this.proposedZxid, this.logicalclock.get(), this.proposedEpoch);
                        this.leaveInstance(vote2);
                        vote = vote2;
                        return vote;
                    }
                    LOG.c("Notification time out: {} ms", (Object)n2);
                    continue;
                }
                if (this.validVoter(notification.sid) && this.validVoter(notification.leader)) {
                    switch (notification.state) {
                        case LOOKING: {
                            if (this.getInitLastLoggedZxid() == -1L) {
                                LOG.b("Ignoring notification as our zxid is -1");
                                break;
                            }
                            if (notification.zxid == -1L) {
                                LOG.b("Ignoring notification from member with -1 zxid {}", (Object)notification.sid);
                                break;
                            }
                            if (notification.electionEpoch > this.logicalclock.get()) {
                                this.logicalclock.set(notification.electionEpoch);
                                hashMap.clear();
                                if (this.totalOrderPredicate(notification.leader, notification.zxid, notification.peerEpoch, this.getInitId(), this.getInitLastLoggedZxid(), this.getPeerEpoch())) {
                                    this.updateProposal(notification.leader, notification.zxid, notification.peerEpoch);
                                } else {
                                    this.updateProposal(this.getInitId(), this.getInitLastLoggedZxid(), this.getPeerEpoch());
                                }
                                this.sendNotifications();
                            } else {
                                if (notification.electionEpoch < this.logicalclock.get()) {
                                    LOG.b("Notification election epoch is smaller than logicalclock. n.electionEpoch = 0x{}, logicalclock=0x{}", (Object)Long.toHexString(notification.electionEpoch), (Object)Long.toHexString(this.logicalclock.get()));
                                    break;
                                }
                                if (this.totalOrderPredicate(notification.leader, notification.zxid, notification.peerEpoch, this.proposedLeader, this.proposedZxid, this.proposedEpoch)) {
                                    this.updateProposal(notification.leader, notification.zxid, notification.peerEpoch);
                                    this.sendNotifications();
                                }
                            }
                            LOG.b("Adding vote: from={}, proposed leader={}, proposed zxid=0x{}, proposed election epoch=0x{}", notification.sid, notification.leader, Long.toHexString(notification.zxid), Long.toHexString(notification.electionEpoch));
                            hashMap.put(notification.sid, new Vote(notification.leader, notification.zxid, notification.electionEpoch, notification.peerEpoch));
                            object = this.getVoteTracker(hashMap, new Vote(this.proposedLeader, this.proposedZxid, this.logicalclock.get(), this.proposedEpoch));
                            if (!((SyncedLearnerTracker)object).hasAllQuorums()) continue block30;
                            while ((notification = this.recvqueue.poll(200L, TimeUnit.MILLISECONDS)) != null) {
                                if (!this.totalOrderPredicate(notification.leader, notification.zxid, notification.peerEpoch, this.proposedLeader, this.proposedZxid, this.proposedEpoch)) continue;
                                this.recvqueue.put(notification);
                                break;
                            }
                            if (notification != null) continue block30;
                            this.setPeerState(this.proposedLeader, (SyncedLearnerTracker)object);
                            vote2 = new Vote(this.proposedLeader, this.proposedZxid, this.logicalclock.get(), this.proposedEpoch);
                            this.leaveInstance(vote2);
                            vote = vote2;
                            return vote;
                        }
                        case OBSERVING: {
                            LOG.b("Notification from observer: {}", (Object)notification.sid);
                            break;
                        }
                        case FOLLOWING: {
                            vote2 = this.receivedFollowingNotification(hashMap, hashMap2, (SyncedLearnerTracker)object, notification);
                            if (vote2 == null) break;
                            vote = vote2;
                            return vote;
                        }
                        case LEADING: {
                            vote = this.receivedLeadingNotification(hashMap, hashMap2, (SyncedLearnerTracker)object, notification);
                            if (vote == null) break;
                            Vote vote3 = vote;
                            return vote3;
                        }
                        default: {
                            LOG.d("Notification state unrecognized: {} (n.state), {}(n.sid)", (Object)notification.state, (Object)notification.sid);
                            break;
                        }
                    }
                    continue;
                }
                if (!this.validVoter(notification.leader)) {
                    LOG.d("Ignoring notification for non-cluster member sid {} from sid {}", (Object)notification.leader, (Object)notification.sid);
                }
                if (this.validVoter(notification.sid)) continue;
                LOG.d("Ignoring notification for sid {} from non-quorum member sid {}", (Object)notification.leader, (Object)notification.sid);
            }
            notification = null;
            return notification;
        }
        finally {
            try {
                if (this.self.jmxLeaderElectionBean != null) {
                    MBeanRegistry.getInstance().unregister(this.self.jmxLeaderElectionBean);
                }
            }
            catch (Exception exception) {
                LOG.c("Failed to unregister with JMX", exception);
            }
            this.self.jmxLeaderElectionBean = null;
            LOG.b("Number of connection processing threads: {}", (Object)this.manager.getConnectionThreadCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vote receivedFollowingNotification(Map<Long, Vote> map, Map<Long, Vote> map2, SyncedLearnerTracker syncedLearnerTracker, Notification notification) {
        if (notification.electionEpoch == this.logicalclock.get()) {
            map.put(notification.sid, new Vote(notification.leader, notification.zxid, notification.electionEpoch, notification.peerEpoch, notification.state));
            syncedLearnerTracker = this.getVoteTracker(map, new Vote(notification.version, notification.leader, notification.zxid, notification.electionEpoch, notification.peerEpoch, notification.state));
            if (syncedLearnerTracker.hasAllQuorums() && this.checkLeader(map, notification.leader, notification.electionEpoch)) {
                this.setPeerState(notification.leader, syncedLearnerTracker);
                Vote vote = new Vote(notification.leader, notification.zxid, notification.electionEpoch, notification.peerEpoch);
                this.leaveInstance(vote);
                return vote;
            }
        }
        map2.put(notification.sid, new Vote(notification.version, notification.leader, notification.zxid, notification.electionEpoch, notification.peerEpoch, notification.state));
        syncedLearnerTracker = this.getVoteTracker(map2, new Vote(notification.version, notification.leader, notification.zxid, notification.electionEpoch, notification.peerEpoch, notification.state));
        if (syncedLearnerTracker.hasAllQuorums() && this.checkLeader(map2, notification.leader, notification.electionEpoch)) {
            Object object = this;
            synchronized (object) {
                this.logicalclock.set(notification.electionEpoch);
                this.setPeerState(notification.leader, syncedLearnerTracker);
            }
            object = new Vote(notification.leader, notification.zxid, notification.electionEpoch, notification.peerEpoch);
            this.leaveInstance((Vote)object);
            return object;
        }
        return null;
    }

    private Vote receivedLeadingNotification(Map<Long, Vote> map, Map<Long, Vote> map2, SyncedLearnerTracker syncedLearnerTracker, Notification notification) {
        Vote vote = this.receivedFollowingNotification(map, map2, syncedLearnerTracker, notification);
        if (vote == null) {
            if (this.self.getQuorumVerifier().getNeedOracle() && !this.self.getQuorumVerifier().askOracle()) {
                LOG.c("Oracle indicates to follow");
                this.setPeerState(notification.leader, syncedLearnerTracker);
                Vote vote2 = new Vote(notification.leader, notification.zxid, notification.electionEpoch, notification.peerEpoch);
                this.leaveInstance(vote2);
                return vote2;
            }
            LOG.c("Oracle indicates not to follow");
            return null;
        }
        return vote;
    }

    private boolean validVoter(long l2) {
        return this.self.getCurrentAndNextConfigVoters().contains(l2);
    }

    static {
        minNotificationInterval = Integer.getInteger(MIN_NOTIFICATION_INTERVAL, minNotificationInterval);
        LOG.c("{} = {} ms", (Object)MIN_NOTIFICATION_INTERVAL, (Object)minNotificationInterval);
        maxNotificationInterval = Integer.getInteger(MAX_NOTIFICATION_INTERVAL, maxNotificationInterval);
        LOG.c("{} = {} ms", (Object)MAX_NOTIFICATION_INTERVAL, (Object)maxNotificationInterval);
        dummyData = new byte[0];
    }

    public class Messenger {
        WorkerSender ws;
        WorkerReceiver wr;
        Thread wsThread = null;
        Thread wrThread = null;

        Messenger(QuorumCnxManager quorumCnxManager) {
            this.ws = new WorkerSender(quorumCnxManager);
            this.wsThread = new Thread((Runnable)this.ws, "WorkerSender[myid=" + FastLeaderElection.this.self.getMyId() + "]");
            this.wsThread.setDaemon(true);
            this.wr = new WorkerReceiver(quorumCnxManager);
            this.wrThread = new Thread((Runnable)this.wr, "WorkerReceiver[myid=" + FastLeaderElection.this.self.getMyId() + "]");
            this.wrThread.setDaemon(true);
        }

        void start() {
            this.wsThread.start();
            this.wrThread.start();
        }

        void halt() {
            this.ws.stop = true;
            this.wr.stop = true;
        }

        class WorkerSender
        extends ZooKeeperThread {
            volatile boolean stop;
            QuorumCnxManager manager;

            WorkerSender(QuorumCnxManager quorumCnxManager) {
                super("WorkerSender");
                this.stop = false;
                this.manager = quorumCnxManager;
            }

            @Override
            public void run() {
                while (!this.stop) {
                    try {
                        ToSend toSend = FastLeaderElection.this.sendqueue.poll(3000L, TimeUnit.MILLISECONDS);
                        if (toSend == null) continue;
                        this.process(toSend);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                        break;
                    }
                }
                LOG.c("WorkerSender is down");
            }

            void process(ToSend toSend) {
                ByteBuffer byteBuffer = FastLeaderElection.buildMsg(toSend.state.ordinal(), toSend.leader, toSend.zxid, toSend.electionEpoch, toSend.peerEpoch, toSend.configData);
                this.manager.toSend(toSend.sid, byteBuffer);
            }
        }

        class WorkerReceiver
        extends ZooKeeperThread {
            volatile boolean stop;
            QuorumCnxManager manager;

            WorkerReceiver(QuorumCnxManager quorumCnxManager) {
                super("WorkerReceiver");
                this.stop = false;
                this.manager = quorumCnxManager;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block15: while (!this.stop) {
                    try {
                        Object object;
                        Object object2;
                        Object object3;
                        Object object4;
                        long l2;
                        QuorumVerifier quorumVerifier;
                        int n2;
                        long l3;
                        long l4;
                        long l5;
                        int n3;
                        Notification notification;
                        QuorumCnxManager.Message message;
                        block31: {
                            message = this.manager.pollRecvQueue(3000L, TimeUnit.MILLISECONDS);
                            if (message == null) continue;
                            int n4 = message.buffer.capacity();
                            if (n4 < 28) {
                                LOG.e("Got a short response from server {}: {}", (Object)message.sid, (Object)n4);
                                continue;
                            }
                            boolean bl2 = n4 == 28;
                            boolean bl3 = n4 == 40;
                            message.buffer.clear();
                            notification = new Notification();
                            n3 = message.buffer.getInt();
                            l5 = message.buffer.getLong();
                            l4 = message.buffer.getLong();
                            l3 = message.buffer.getLong();
                            n2 = 0;
                            quorumVerifier = null;
                            try {
                                if (!bl2) {
                                    l2 = message.buffer.getLong();
                                    if (!bl3) {
                                        n2 = message.buffer.getInt();
                                    } else {
                                        LOG.c("Backward compatibility mode (36 bits), server id: {}", (Object)message.sid);
                                    }
                                } else {
                                    LOG.c("Backward compatibility mode (28 bits), server id: {}", (Object)message.sid);
                                    l2 = ZxidUtils.getEpochFromZxid(l4);
                                }
                                if (n2 > 1) {
                                    int n5 = message.buffer.getInt();
                                    if (n5 < 0 || n5 > n4) {
                                        throw new IOException(String.format("Invalid configLength in notification message! sid=%d, capacity=%d, version=%d, configLength=%d", message.sid, n4, n2, n5));
                                    }
                                    object4 = new byte[n5];
                                    message.buffer.get((byte[])object4);
                                    object3 = FastLeaderElection.this.self;
                                    synchronized (object3) {
                                        try {
                                            quorumVerifier = FastLeaderElection.this.self.configFromString(new String((byte[])object4, StandardCharsets.UTF_8));
                                            object2 = FastLeaderElection.this.self.getQuorumVerifier();
                                            if (quorumVerifier.getVersion() > object2.getVersion()) {
                                                LOG.c("{} Received version: {} my version: {}", FastLeaderElection.this.self.getMyId(), Long.toHexString(quorumVerifier.getVersion()), Long.toHexString(FastLeaderElection.this.self.getQuorumVerifier().getVersion()));
                                                if (FastLeaderElection.this.self.getPeerState() == QuorumPeer.ServerState.LOOKING) {
                                                    LOG.b("Invoking processReconfig(), state: {}", (Object)FastLeaderElection.this.self.getServerState());
                                                    FastLeaderElection.this.self.processReconfig(quorumVerifier, null, null, false);
                                                    if (!quorumVerifier.equals(object2)) {
                                                        LOG.c("restarting leader election");
                                                        FastLeaderElection.this.self.shuttingDownLE = true;
                                                        FastLeaderElection.this.self.getElectionAlg().shutdown();
                                                        break;
                                                    }
                                                } else {
                                                    LOG.b("Skip processReconfig(), state: {}", (Object)FastLeaderElection.this.self.getServerState());
                                                }
                                            }
                                        }
                                        catch (QuorumPeerConfig.ConfigException | IOException exception) {
                                            LOG.e("Something went wrong while processing config received from {}", (Object)message.sid);
                                        }
                                        break block31;
                                    }
                                }
                                LOG.c("Backward compatibility mode (before reconfig), server id: {}", (Object)message.sid);
                            }
                            catch (IOException | BufferUnderflowException exception) {
                                LOG.d("Skipping the processing of a partial / malformed response message sent by sid={} (message length: {})", message.sid, n4, exception);
                                continue;
                            }
                        }
                        if (!FastLeaderElection.this.validVoter(message.sid)) {
                            object = FastLeaderElection.this.self.getCurrentVote();
                            object4 = FastLeaderElection.this.self.getQuorumVerifier();
                            object3 = new ToSend(ToSend.mType.notification, ((Vote)object).getId(), ((Vote)object).getZxid(), FastLeaderElection.this.logicalclock.get(), FastLeaderElection.this.self.getPeerState(), message.sid, ((Vote)object).getPeerEpoch(), object4.toString().getBytes(StandardCharsets.UTF_8));
                            FastLeaderElection.this.sendqueue.offer((ToSend)object3);
                            continue;
                        }
                        LOG.b("Receive new notification message. My id = {}", (Object)FastLeaderElection.this.self.getMyId());
                        object = QuorumPeer.ServerState.LOOKING;
                        switch (n3) {
                            case 0: {
                                object = QuorumPeer.ServerState.LOOKING;
                                break;
                            }
                            case 1: {
                                object = QuorumPeer.ServerState.FOLLOWING;
                                break;
                            }
                            case 2: {
                                object = QuorumPeer.ServerState.LEADING;
                                break;
                            }
                            case 3: {
                                object = QuorumPeer.ServerState.OBSERVING;
                                break;
                            }
                            default: {
                                continue block15;
                            }
                        }
                        notification.leader = l5;
                        notification.zxid = l4;
                        notification.electionEpoch = l3;
                        notification.state = object;
                        notification.sid = message.sid;
                        notification.peerEpoch = l2;
                        notification.version = n2;
                        notification.qv = quorumVerifier;
                        LOG.c("Notification: my state:{}; n.sid:{}, n.state:{}, n.leader:{}, n.round:0x{}, n.peerEpoch:0x{}, n.zxid:0x{}, message format version:0x{}, n.config version:0x{}", new Object[]{FastLeaderElection.this.self.getPeerState(), notification.sid, notification.state, notification.leader, Long.toHexString(notification.electionEpoch), Long.toHexString(notification.peerEpoch), Long.toHexString(notification.zxid), Long.toHexString(notification.version), notification.qv != null ? Long.toHexString(notification.qv.getVersion()) : "0"});
                        if (FastLeaderElection.this.self.getPeerState() == QuorumPeer.ServerState.LOOKING) {
                            FastLeaderElection.this.recvqueue.offer(notification);
                            if (object != QuorumPeer.ServerState.LOOKING || notification.electionEpoch >= FastLeaderElection.this.logicalclock.get()) continue;
                            object4 = FastLeaderElection.this.getVote();
                            object3 = FastLeaderElection.this.self.getQuorumVerifier();
                            object2 = new ToSend(ToSend.mType.notification, ((Vote)object4).getId(), ((Vote)object4).getZxid(), FastLeaderElection.this.logicalclock.get(), FastLeaderElection.this.self.getPeerState(), message.sid, ((Vote)object4).getPeerEpoch(), object3.toString().getBytes());
                            FastLeaderElection.this.sendqueue.offer((ToSend)object2);
                            continue;
                        }
                        object4 = FastLeaderElection.this.self.getCurrentVote();
                        if (object != QuorumPeer.ServerState.LOOKING) continue;
                        if (FastLeaderElection.this.self.leader != null) {
                            if (FastLeaderElection.this.leadingVoteSet != null) {
                                FastLeaderElection.this.self.leader.setLeadingVoteSet(FastLeaderElection.this.leadingVoteSet);
                                FastLeaderElection.this.leadingVoteSet = null;
                            }
                            FastLeaderElection.this.self.leader.reportLookingSid(message.sid);
                        }
                        LOG.b("Sending new notification. My id ={} recipient={} zxid=0x{} leader={} config version = {}", FastLeaderElection.this.self.getMyId(), message.sid, Long.toHexString(((Vote)object4).getZxid()), ((Vote)object4).getId(), Long.toHexString(FastLeaderElection.this.self.getQuorumVerifier().getVersion()));
                        object3 = FastLeaderElection.this.self.getQuorumVerifier();
                        object2 = new ToSend(ToSend.mType.notification, ((Vote)object4).getId(), ((Vote)object4).getZxid(), ((Vote)object4).getElectionEpoch(), FastLeaderElection.this.self.getPeerState(), message.sid, ((Vote)object4).getPeerEpoch(), object3.toString().getBytes());
                        FastLeaderElection.this.sendqueue.offer((ToSend)object2);
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.c("Interrupted Exception while waiting for new message", interruptedException);
                    }
                }
                LOG.c("WorkerReceiver is down");
            }
        }
    }

    public static class ToSend {
        long leader;
        long zxid;
        long electionEpoch;
        QuorumPeer.ServerState state;
        long sid;
        byte[] configData = dummyData;
        long peerEpoch;

        ToSend(mType mType2, long l2, long l3, long l4, QuorumPeer.ServerState serverState, long l5, long l6, byte[] byArray) {
            this.leader = l2;
            this.zxid = l3;
            this.electionEpoch = l4;
            this.state = serverState;
            this.sid = l5;
            this.peerEpoch = l6;
            this.configData = byArray;
        }

        static enum mType {
            crequest,
            challenge,
            notification,
            ack;

        }
    }

    public static class Notification {
        public static final int CURRENTVERSION = 2;
        int version;
        long leader;
        long zxid;
        long electionEpoch;
        QuorumPeer.ServerState state;
        long sid;
        QuorumVerifier qv;
        long peerEpoch;
    }
}

