/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence;

import XcoreXdatabricksX240X9088.hme;
import XcoreXdatabricksX240X9088.ime;
import XcoreXdatabricksX240X9088.mme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ExitCode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.TxnLogEntry;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileHeader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FilePadding;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileTxnLog;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.LogChopper;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.SerializeUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.CreateContainerTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.CreateTTLTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.CreateTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.MultiTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.SetDataTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.Txn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnHeader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.util.ServiceUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Scanner;
import java.util.zip.Adler32;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class TxnLogToolkit
implements Closeable {
    private File txnLogFile;
    private boolean recoveryMode = false;
    private boolean verbose = false;
    private FileInputStream txnFis;
    private hme logStream;
    private int crcFixed = 0;
    private FileOutputStream recoveryFos;
    private ime recoveryOa;
    private File recoveryLogFile;
    private FilePadding filePadding = new FilePadding();
    private boolean force = false;
    private long zxid = -1L;

    public static void main(String[] stringArray) throws Exception {
        try (TxnLogToolkit txnLogToolkit = TxnLogToolkit.parseCommandLine(stringArray);){
            if (txnLogToolkit.isDumpMode()) {
                txnLogToolkit.dump(new Scanner(System.in));
                txnLogToolkit.printStat();
            } else {
                txnLogToolkit.chop();
            }
        }
        catch (TxnLogToolkitParseException txnLogToolkitParseException) {
            System.err.println(txnLogToolkitParseException.getMessage() + "\n");
            TxnLogToolkit.printHelpAndExit(txnLogToolkitParseException.getExitCode(), txnLogToolkitParseException.getOptions());
        }
        catch (TxnLogToolkitException txnLogToolkitException) {
            System.err.println(txnLogToolkitException.getMessage());
            ServiceUtils.requestSystemExit(txnLogToolkitException.getExitCode());
        }
    }

    public TxnLogToolkit(boolean bl2, boolean bl3, String string, boolean bl4) throws FileNotFoundException, TxnLogToolkitException {
        this.recoveryMode = bl2;
        this.verbose = bl3;
        this.force = bl4;
        this.txnLogFile = this.loadTxnFile(string);
        if (bl2) {
            this.recoveryLogFile = new File(this.txnLogFile.toString() + ".fixed");
            if (this.recoveryLogFile.exists()) {
                throw new TxnLogToolkitException(ExitCode.UNEXPECTED_ERROR.getValue(), "Recovery file %s already exists or not writable", this.recoveryLogFile);
            }
        }
        this.openTxnLogFile();
        if (bl2) {
            this.openRecoveryFile();
        }
    }

    public TxnLogToolkit(String string, String string2) throws TxnLogToolkitException {
        this.txnLogFile = this.loadTxnFile(string);
        this.zxid = Long.decode(string2);
    }

    private File loadTxnFile(String string) throws TxnLogToolkitException {
        File file = new File(string);
        if (!file.exists() || !file.canRead()) {
            throw new TxnLogToolkitException(ExitCode.UNEXPECTED_ERROR.getValue(), "File doesn't exist or not readable: %s", file);
        }
        return file;
    }

    public void dump(Scanner scanner) throws Exception {
        this.crcFixed = 0;
        FileHeader fileHeader = new FileHeader();
        fileHeader.deserialize(this.logStream, "fileheader");
        if (fileHeader.getMagic() != FileTxnLog.TXNLOG_MAGIC) {
            throw new TxnLogToolkitException(ExitCode.INVALID_INVOCATION.getValue(), "Invalid magic number for %s", this.txnLogFile.getName());
        }
        System.out.println("ZooKeeper Transactional Log File with dbid " + fileHeader.getDbid() + " txnlog format version " + fileHeader.getVersion());
        if (this.recoveryMode) {
            fileHeader.serialize(this.recoveryOa, "fileheader");
            this.recoveryFos.flush();
            this.filePadding.setCurrentSize(this.recoveryFos.getChannel().position());
        }
        int n2 = 0;
        while (true) {
            byte[] byArray;
            long l2;
            try {
                l2 = this.logStream.d("crcvalue");
                byArray = this.logStream.f("txnEntry");
            }
            catch (EOFException eOFException) {
                System.out.println("EOF reached after " + n2 + " txns.");
                return;
            }
            if (byArray.length == 0) {
                System.out.println("EOF reached after " + n2 + " txns.");
                return;
            }
            Adler32 adler32 = new Adler32();
            adler32.update(byArray, 0, byArray.length);
            if (l2 != adler32.getValue()) {
                if (this.recoveryMode) {
                    if (!this.force) {
                        this.printTxn(byArray, "CRC ERROR");
                        if (this.askForFix(scanner)) {
                            l2 = adler32.getValue();
                            ++this.crcFixed;
                        }
                    } else {
                        l2 = adler32.getValue();
                        this.printTxn(byArray, "CRC FIXED");
                        ++this.crcFixed;
                    }
                } else {
                    this.printTxn(byArray, "CRC ERROR");
                }
            }
            if (!this.recoveryMode || this.verbose) {
                this.printTxn(byArray);
            }
            if (this.logStream.a("EOR") != 66) {
                throw new TxnLogToolkitException(ExitCode.UNEXPECTED_ERROR.getValue(), "Last transaction was partial.", new Object[0]);
            }
            if (this.recoveryMode) {
                this.filePadding.padFile(this.recoveryFos.getChannel());
                this.recoveryOa.a(l2, "crcvalue");
                this.recoveryOa.a(byArray, "txnEntry");
                this.recoveryOa.a((byte)66, "EOR");
            }
            ++n2;
        }
    }

    public void chop() {
        File file = new File(this.txnLogFile.getParentFile(), this.txnLogFile.getName() + ".chopped" + this.zxid);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.txnLogFile));
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
            if (!LogChopper.chop(bufferedInputStream, bufferedOutputStream, this.zxid)) {
                throw new TxnLogToolkitException(ExitCode.INVALID_INVOCATION.getValue(), "Failed to chop %s", this.txnLogFile.getName());
            }
        }
        catch (Exception exception) {
            System.out.println("Got exception: " + exception.getMessage());
        }
    }

    public boolean isDumpMode() {
        return this.zxid < 0L;
    }

    private boolean askForFix(Scanner scanner) throws TxnLogToolkitException {
        while (true) {
            System.out.print("Would you like to fix it (Yes/No/Abort) ? ");
            char c2 = Character.toUpperCase(scanner.next().charAt(0));
            switch (c2) {
                case 'Y': {
                    return true;
                }
                case 'N': {
                    return false;
                }
                case 'A': {
                    throw new TxnLogToolkitException(ExitCode.EXECUTION_FINISHED.getValue(), "Recovery aborted.", new Object[0]);
                }
            }
        }
    }

    private void printTxn(byte[] byArray) throws IOException {
        this.printTxn(byArray, "");
    }

    private void printTxn(byte[] byArray, String string) throws IOException {
        TxnLogEntry txnLogEntry = SerializeUtils.deserializeTxn(byArray);
        TxnHeader txnHeader = txnLogEntry.getHeader();
        mme mme2 = txnLogEntry.getTxn();
        String string2 = TxnLogToolkit.getFormattedTxnStr(mme2);
        String string3 = String.format("%s session 0x%s cxid 0x%s zxid 0x%s %s %s", DateFormat.getDateTimeInstance(3, 1).format(new Date(txnHeader.getTime())), Long.toHexString(txnHeader.getClientId()), Long.toHexString(txnHeader.getCxid()), Long.toHexString(txnHeader.getZxid()), Request.op2String(txnHeader.getType()), string2);
        if (string != null && !"".equals(string.trim())) {
            System.out.print(string + " - ");
        }
        if (string3.endsWith("\n")) {
            System.out.print(string3);
        } else {
            System.out.println(string3);
        }
    }

    private static String getFormattedTxnStr(mme mme2) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        if (mme2 == null) {
            return stringBuilder.toString();
        }
        if (mme2 instanceof CreateTxn) {
            CreateTxn createTxn = (CreateTxn)mme2;
            stringBuilder.append(createTxn.getPath() + "," + TxnLogToolkit.checkNullToEmpty(createTxn.getData())).append("," + createTxn.getAcl() + "," + createTxn.getEphemeral()).append("," + createTxn.getParentCVersion());
        } else if (mme2 instanceof SetDataTxn) {
            SetDataTxn setDataTxn = (SetDataTxn)mme2;
            stringBuilder.append(setDataTxn.getPath() + "," + TxnLogToolkit.checkNullToEmpty(setDataTxn.getData())).append("," + setDataTxn.getVersion());
        } else if (mme2 instanceof CreateContainerTxn) {
            CreateContainerTxn createContainerTxn = (CreateContainerTxn)mme2;
            stringBuilder.append(createContainerTxn.getPath() + "," + TxnLogToolkit.checkNullToEmpty(createContainerTxn.getData())).append("," + createContainerTxn.getAcl() + "," + createContainerTxn.getParentCVersion());
        } else if (mme2 instanceof CreateTTLTxn) {
            CreateTTLTxn createTTLTxn = (CreateTTLTxn)mme2;
            stringBuilder.append(createTTLTxn.getPath() + "," + TxnLogToolkit.checkNullToEmpty(createTTLTxn.getData())).append("," + createTTLTxn.getAcl() + "," + createTTLTxn.getParentCVersion()).append("," + createTTLTxn.getTtl());
        } else if (mme2 instanceof MultiTxn) {
            MultiTxn multiTxn = (MultiTxn)mme2;
            List<Txn> list = multiTxn.getTxns();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Txn txn = list.get(i2);
                if (i2 == 0) {
                    stringBuilder.append(Request.op2String(txn.getType()) + ":" + TxnLogToolkit.checkNullToEmpty(txn.getData()));
                    continue;
                }
                stringBuilder.append(";" + Request.op2String(txn.getType()) + ":" + TxnLogToolkit.checkNullToEmpty(txn.getData()));
            }
        } else {
            stringBuilder.append(mme2.toString());
        }
        return stringBuilder.toString();
    }

    private static String checkNullToEmpty(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length == 0) {
            return "";
        }
        return new String(byArray, StandardCharsets.UTF_8);
    }

    private void openTxnLogFile() throws FileNotFoundException {
        this.txnFis = new FileInputStream(this.txnLogFile);
        this.logStream = hme.a(this.txnFis);
    }

    private void closeTxnLogFile() throws IOException {
        if (this.txnFis != null) {
            this.txnFis.close();
        }
    }

    private void openRecoveryFile() throws FileNotFoundException {
        this.recoveryFos = new FileOutputStream(this.recoveryLogFile);
        this.recoveryOa = ime.a(this.recoveryFos);
    }

    private void closeRecoveryFile() throws IOException {
        if (this.recoveryFos != null) {
            this.recoveryFos.close();
        }
    }

    private static TxnLogToolkit parseCommandLine(String[] stringArray) throws TxnLogToolkitException, FileNotFoundException {
        DefaultParser defaultParser = new DefaultParser();
        Options options = new Options();
        Option option = new Option("h", "help", false, "Print help message");
        options.addOption(option);
        Option option2 = new Option("r", "recover", false, "Recovery mode. Re-calculate CRC for broken entries.");
        options.addOption(option2);
        Option option3 = new Option("v", "verbose", false, "Be verbose in recovery mode: print all entries, not just fixed ones.");
        options.addOption(option3);
        Option option4 = new Option("d", "dump", false, "Dump mode. Dump all entries of the log file with printing the content of a nodepath (default)");
        options.addOption(option4);
        Option option5 = new Option("y", "yes", false, "Non-interactive mode: repair all CRC errors without asking");
        options.addOption(option5);
        Option option6 = new Option("c", "chop", false, "Chop mode. Chop txn file to a zxid.");
        Option option7 = new Option("z", "zxid", true, "Used with chop. Zxid to which to chop.");
        options.addOption(option6);
        options.addOption(option7);
        try {
            CommandLine commandLine = defaultParser.parse(options, stringArray);
            if (commandLine.hasOption("help")) {
                TxnLogToolkit.printHelpAndExit(0, options);
            }
            if (commandLine.getArgs().length < 1) {
                TxnLogToolkit.printHelpAndExit(1, options);
            }
            if (commandLine.hasOption("chop") && commandLine.hasOption("zxid")) {
                return new TxnLogToolkit(commandLine.getArgs()[0], commandLine.getOptionValue("zxid"));
            }
            return new TxnLogToolkit(commandLine.hasOption("recover"), commandLine.hasOption("verbose"), commandLine.getArgs()[0], commandLine.hasOption("yes"));
        }
        catch (ParseException parseException) {
            throw new TxnLogToolkitParseException(options, ExitCode.UNEXPECTED_ERROR.getValue(), parseException.getMessage(), new Object[0]);
        }
    }

    private static void printHelpAndExit(int n2, Options options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(120, "TxnLogToolkit [-dhrvc] <txn_log_file_name> (-z <zxid>)", "", options, "");
        ServiceUtils.requestSystemExit(n2);
    }

    private void printStat() {
        if (this.recoveryMode) {
            System.out.printf("Recovery file %s has been written with %d fixed CRC error(s)%n", this.recoveryLogFile, this.crcFixed);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.recoveryMode) {
            this.closeRecoveryFile();
        }
        this.closeTxnLogFile();
    }

    static class TxnLogToolkitParseException
    extends TxnLogToolkitException {
        private static final long serialVersionUID = 1L;
        private Options options;

        TxnLogToolkitParseException(Options options, int n2, String string, Object ... objectArray) {
            super(n2, string, objectArray);
            this.options = options;
        }

        Options getOptions() {
            return this.options;
        }
    }

    static class TxnLogToolkitException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private int exitCode;

        TxnLogToolkitException(int n2, String string, Object ... objectArray) {
            super(String.format(string, objectArray));
            this.exitCode = n2;
        }

        int getExitCode() {
            return this.exitCode;
        }
    }
}

