/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XcoreXdatabricksX240X9088.kme;
import XcoreXdatabricksX240X9088.lme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.AtomicFileOutputStream;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.xerial.snappy.SnappyCodec;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public class SnapStream {
    private static final foe LOG = goe.a(SnapStream.class);
    public static final String ZOOKEEPER_SHAPSHOT_STREAM_MODE = "zookeeper.snapshot.compression.method";
    private static StreamMode streamMode = StreamMode.fromString(System.getProperty("zookeeper.snapshot.compression.method", StreamMode.DEFAULT_MODE.getName()));

    public static CheckedInputStream getInputStream(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            FilterInputStream filterInputStream;
            switch (SnapStream.getStreamMode(file.getName())) {
                case GZIP: {
                    filterInputStream = new GZIPInputStream(fileInputStream);
                    break;
                }
                case SNAPPY: {
                    filterInputStream = new SnappyInputStream((InputStream)fileInputStream);
                    break;
                }
                default: {
                    filterInputStream = new BufferedInputStream(fileInputStream);
                }
            }
            return new CheckedInputStream(filterInputStream, new Adler32());
        }
        catch (IOException iOException) {
            fileInputStream.close();
            throw iOException;
        }
    }

    public static CheckedOutputStream getOutputStream(File file, boolean bl2) throws IOException {
        Object object;
        OutputStream outputStream = bl2 ? new AtomicFileOutputStream(file) : new FileOutputStream(file);
        switch (streamMode) {
            case GZIP: {
                try {
                    object = new GZIPOutputStream(outputStream);
                    break;
                }
                catch (IOException iOException) {
                    outputStream.close();
                    throw iOException;
                }
            }
            case SNAPPY: {
                object = new SnappyOutputStream(outputStream);
                break;
            }
            default: {
                object = new BufferedOutputStream(outputStream);
            }
        }
        return new CheckedOutputStream((OutputStream)object, new Adler32());
    }

    public static void sealStream(CheckedOutputStream checkedOutputStream, lme lme2) throws IOException {
        long l2 = checkedOutputStream.getChecksum().getValue();
        lme2.a(l2, "val");
        lme2.a("/", "path");
    }

    public static void checkSealIntegrity(CheckedInputStream checkedInputStream, kme kme2) throws IOException {
        long l2 = checkedInputStream.getChecksum().getValue();
        long l3 = kme2.d("val");
        kme2.e("path");
        if (l3 != l2) {
            throw new IOException("CRC corruption");
        }
    }

    public static boolean isValidSnapshot(File file) throws IOException {
        if (file == null || Util.getZxidFromName(file.getName(), "snapshot") == -1L) {
            return false;
        }
        boolean bl2 = false;
        switch (SnapStream.getStreamMode(file.getName())) {
            case GZIP: {
                bl2 = SnapStream.isValidGZipStream(file);
                break;
            }
            case SNAPPY: {
                bl2 = SnapStream.isValidSnappyStream(file);
                break;
            }
            default: {
                bl2 = SnapStream.isValidCheckedStream(file);
            }
        }
        return bl2;
    }

    public static void setStreamMode(StreamMode streamMode) {
        SnapStream.streamMode = streamMode;
    }

    public static StreamMode getStreamMode() {
        return streamMode;
    }

    public static StreamMode getStreamMode(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length > 1) {
            String string2 = stringArray[stringArray.length - 1];
            return StreamMode.fromString(string2);
        }
        return StreamMode.CHECKED;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isValidGZipStream(File file) throws IOException {
        byte[] byArray = new byte[2];
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            if (2 != fileInputStream.read(byArray, 0, 2)) {
                LOG.e("Read incorrect number of bytes from {}", (Object)file.getName());
                boolean bl2 = false;
                return bl2;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byte[] byArray2 = new byte[2];
            byteBuffer.get(byArray2, 0, 2);
            int n2 = byArray2[0] & 0xFF | byArray2[1] << 8 & 0xFF00;
            boolean bl3 = n2 == 35615;
            return bl3;
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.e("Unable to open file {}", (Object)file.getName(), (Object)fileNotFoundException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isValidSnappyStream(File file) throws IOException {
        byte[] byArray = new byte[SnappyCodec.MAGIC_LEN];
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            if (SnappyCodec.MAGIC_LEN != fileInputStream.read(byArray, 0, SnappyCodec.MAGIC_LEN)) {
                LOG.e("Read incorrect number of bytes from {}", (Object)file.getName());
                boolean bl2 = false;
                return bl2;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byte[] byArray2 = new byte[SnappyCodec.MAGIC_LEN];
            byteBuffer.get(byArray2, 0, SnappyCodec.MAGIC_LEN);
            boolean bl3 = Arrays.equals(byArray2, SnappyCodec.getMagicHeader());
            return bl3;
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.e("Unable to open file {}", (Object)file.getName(), (Object)fileNotFoundException);
            return false;
        }
    }

    private static boolean isValidCheckedStream(File file) throws IOException {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            int n2;
            int n3;
            if (randomAccessFile.length() < 10L) {
                boolean bl2 = false;
                return bl2;
            }
            randomAccessFile.seek(randomAccessFile.length() - 5L);
            byte[] byArray = new byte[5];
            for (n2 = 0; n2 < 5 && (n3 = randomAccessFile.read(byArray, n2, byArray.length - n2)) >= 0; n2 += n3) {
            }
            if (n2 != byArray.length) {
                LOG.c("Invalid snapshot {}. too short, len = {} bytes", (Object)file.getName(), (Object)n2);
                boolean bl3 = false;
                return bl3;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            int n4 = byteBuffer.getInt();
            byte by2 = byteBuffer.get();
            if (n4 != 1 || by2 != 47) {
                LOG.c("Invalid snapshot {}. len = {}, byte = {}", file.getName(), n4, by2 & 0xFF);
                boolean bl4 = false;
                return bl4;
            }
        }
        return true;
    }

    static {
        LOG.c("{} = {}", (Object)ZOOKEEPER_SHAPSHOT_STREAM_MODE, (Object)streamMode);
    }

    public static enum StreamMode {
        GZIP("gz"),
        SNAPPY("snappy"),
        CHECKED("");

        public static final StreamMode DEFAULT_MODE;
        private String name;

        private StreamMode(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getFileExtension() {
            return this.name.isEmpty() ? "" : "." + this.name;
        }

        public static StreamMode fromString(String string) {
            for (StreamMode streamMode : StreamMode.values()) {
                if (streamMode.getName().compareToIgnoreCase(string) != 0) continue;
                return streamMode;
            }
            return DEFAULT_MODE;
        }

        static {
            DEFAULT_MODE = CHECKED;
        }
    }
}

