/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XcoreXdatabricksX240X9088.hme;
import XcoreXdatabricksX240X9088.ime;
import XcoreXdatabricksX240X9088.kme;
import XcoreXdatabricksX240X9088.lme;
import XcoreXdatabricksX240X9088.mme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerStats;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.TxnLogEntry;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileHeader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FilePadding;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.TxnLog;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.Util;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.SerializeUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnDigest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnHeader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.zip.Adler32;
import java.util.zip.Checksum;

public class FileTxnLog
implements Closeable,
TxnLog {
    private static final foe LOG;
    public static final int TXNLOG_MAGIC;
    public static final int VERSION = 2;
    public static final String LOG_FILE_PREFIX = "log";
    static final String FSYNC_WARNING_THRESHOLD_MS_PROPERTY = "fsync.warningthresholdms";
    static final String ZOOKEEPER_FSYNC_WARNING_THRESHOLD_MS_PROPERTY = "zookeeper.fsync.warningthresholdms";
    private static final long fsyncWarningThresholdMS;
    private static final String txnLogSizeLimitSetting = "zookeeper.txnLogSizeLimitInKb";
    private static long txnLogSizeLimit;
    long lastZxidSeen;
    volatile BufferedOutputStream logStream = null;
    volatile lme oa;
    volatile FileOutputStream fos = null;
    File logDir;
    private final boolean forceSync = !System.getProperty("zookeeper.forceSync", "yes").equals("no");
    long dbId;
    private final Queue<FileOutputStream> streamsToFlush = new ArrayDeque<FileOutputStream>();
    File logFileWrite = null;
    private FilePadding filePadding = new FilePadding();
    private ServerStats serverStats;
    private volatile long syncElapsedMS = -1L;
    private long prevLogsRunningTotal;
    long filePosition = 0L;
    private long unFlushedSize = 0L;
    private long fileSize = 0L;

    public FileTxnLog(File file) {
        this.logDir = file;
    }

    public static void setPreallocSize(long l2) {
        FilePadding.setPreallocSize(l2);
    }

    @Override
    public synchronized void setServerStats(ServerStats serverStats) {
        this.serverStats = serverStats;
    }

    public static void setTxnLogSizeLimit(long l2) {
        txnLogSizeLimit = l2;
    }

    public synchronized long getCurrentLogSize() {
        if (this.logFileWrite != null) {
            return this.fileSize;
        }
        return 0L;
    }

    @Override
    public synchronized void setTotalLogSize(long l2) {
        this.prevLogsRunningTotal = l2;
    }

    @Override
    public synchronized long getTotalLogSize() {
        return this.prevLogsRunningTotal + this.getCurrentLogSize();
    }

    protected Checksum makeChecksumAlgorithm() {
        return new Adler32();
    }

    @Override
    public synchronized void rollLog() throws IOException {
        if (this.logStream != null) {
            this.logStream.flush();
            this.prevLogsRunningTotal += this.getCurrentLogSize();
            this.logStream = null;
            this.oa = null;
            this.fileSize = 0L;
            this.filePosition = 0L;
            this.unFlushedSize = 0L;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.logStream != null) {
            this.logStream.close();
        }
        for (FileOutputStream fileOutputStream : this.streamsToFlush) {
            fileOutputStream.close();
        }
    }

    @Override
    public synchronized boolean append(Request request) throws IOException {
        long l2;
        Object object;
        TxnHeader txnHeader = request.getHdr();
        if (txnHeader == null) {
            return false;
        }
        if (txnHeader.getZxid() <= this.lastZxidSeen) {
            LOG.d("Current zxid {} is <= {} for {}", txnHeader.getZxid(), this.lastZxidSeen, Request.op2String(txnHeader.getType()));
        } else {
            this.lastZxidSeen = txnHeader.getZxid();
        }
        if (this.logStream == null) {
            LOG.c("Creating new log file: {}", (Object)Util.makeLogName(txnHeader.getZxid()));
            this.logFileWrite = new File(this.logDir, Util.makeLogName(txnHeader.getZxid()));
            this.fos = new FileOutputStream(this.logFileWrite);
            this.logStream = new BufferedOutputStream(this.fos);
            this.oa = ime.a(this.logStream);
            object = new FileHeader(TXNLOG_MAGIC, 2, this.dbId);
            l2 = this.oa.a();
            object.serialize(this.oa, "fileheader");
            this.logStream.flush();
            this.filePosition += this.oa.a() - l2;
            this.filePadding.setCurrentSize(this.filePosition);
            this.streamsToFlush.add(this.fos);
        }
        this.fileSize = this.filePadding.padFile(this.fos.getChannel(), this.filePosition);
        object = request.getSerializeData();
        if (object == null || ((byte[])object).length == 0) {
            throw new IOException("Faulty serialization for header and txn");
        }
        l2 = this.oa.a();
        Checksum checksum = this.makeChecksumAlgorithm();
        checksum.update((byte[])object, 0, ((byte[])object).length);
        this.oa.a(checksum.getValue(), "txnEntryCRC");
        Util.writeTxnBytes(this.oa, object);
        this.unFlushedSize += this.oa.a() - l2;
        return true;
    }

    public static File[] getLogFiles(File[] fileArray, long l2) {
        Object object;
        long l3;
        List<File> list = Util.sortDataDir(fileArray, LOG_FILE_PREFIX, true);
        long l4 = 0L;
        Object object2 = list.iterator();
        while (object2.hasNext() && (l3 = Util.getZxidFromName(((File)(object = object2.next())).getName(), LOG_FILE_PREFIX)) <= l2) {
            if (l3 <= l4) continue;
            l4 = l3;
        }
        object2 = new ArrayList(5);
        for (File file : list) {
            long l5 = Util.getZxidFromName(file.getName(), LOG_FILE_PREFIX);
            if (l5 < l4) continue;
            object2.add(file);
        }
        return object2.toArray(new File[0]);
    }

    @Override
    public long getLastLoggedZxid() {
        long l2;
        File[] fileArray = FileTxnLog.getLogFiles(this.logDir.listFiles(), 0L);
        long l3 = l2 = fileArray.length > 0 ? Util.getZxidFromName(fileArray[fileArray.length - 1].getName(), LOG_FILE_PREFIX) : -1L;
        try (FileTxnLog fileTxnLog = new FileTxnLog(this.logDir);
             TxnLog.TxnIterator txnIterator = fileTxnLog.read(l2);){
            while (txnIterator.next()) {
                TxnHeader txnHeader = txnIterator.getHeader();
                l3 = txnHeader.getZxid();
            }
        }
        catch (IOException iOException) {
            LOG.c("Unexpected exception", iOException);
        }
        return l3;
    }

    @Override
    public synchronized void commit() throws IOException {
        long l2;
        if (this.logStream != null) {
            this.logStream.flush();
            this.filePosition += this.unFlushedSize;
            if (this.filePosition > this.fileSize) {
                this.fileSize = this.filePosition;
            }
            this.unFlushedSize = 0L;
        }
        for (FileOutputStream fileOutputStream : this.streamsToFlush) {
            fileOutputStream.flush();
            if (!this.forceSync) continue;
            long l3 = System.nanoTime();
            FileChannel fileChannel = fileOutputStream.getChannel();
            fileChannel.force(false);
            this.syncElapsedMS = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l3);
            if (this.syncElapsedMS > fsyncWarningThresholdMS) {
                if (this.serverStats != null) {
                    this.serverStats.incrementFsyncThresholdExceedCount();
                }
                LOG.d("fsync-ing the write ahead log in {} took {}ms which will adversely effect operation latency.File size is {} bytes. See the ZooKeeper troubleshooting guide", Thread.currentThread().getName(), this.syncElapsedMS, fileChannel.size());
            }
            ServerMetrics.getMetrics().FSYNC_TIME.add(this.syncElapsedMS);
        }
        while (this.streamsToFlush.size() > 1) {
            this.streamsToFlush.poll().close();
        }
        if (txnLogSizeLimit > 0L && (l2 = this.getCurrentLogSize()) > txnLogSizeLimit) {
            LOG.b("Log size limit reached: {}", (Object)l2);
            this.rollLog();
        }
    }

    @Override
    public long getTxnLogSyncElapsedTime() {
        return this.syncElapsedMS;
    }

    @Override
    public TxnLog.TxnIterator read(long l2) throws IOException {
        return this.read(l2, true);
    }

    public TxnLog.TxnIterator read(long l2, boolean bl2) throws IOException {
        return new FileTxnIterator(this.logDir, l2, bl2);
    }

    @Override
    public boolean truncate(long l2) throws IOException {
        try (FileTxnIterator fileTxnIterator = new FileTxnIterator(this.logDir, l2);){
            PositionInputStream positionInputStream = fileTxnIterator.inputStream;
            if (positionInputStream == null) {
                throw new IOException("No log files found to truncate! This could happen if you still have snapshots from an old setup or log files were deleted accidentally or dataLogDir was changed in zoo.cfg.");
            }
            long l3 = positionInputStream.getPosition();
            RandomAccessFile randomAccessFile = new RandomAccessFile(fileTxnIterator.logFile, "rw");
            randomAccessFile.setLength(l3);
            randomAccessFile.close();
            while (fileTxnIterator.goToNextLog()) {
                if (fileTxnIterator.logFile.delete()) continue;
                LOG.d("Unable to truncate {}", (Object)fileTxnIterator.logFile);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileHeader readHeader(File file) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            hme hme2 = hme.a(inputStream);
            FileHeader fileHeader = new FileHeader();
            fileHeader.deserialize(hme2, "fileheader");
            FileHeader fileHeader2 = fileHeader;
            return fileHeader2;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                LOG.c("Ignoring exception during close", iOException);
            }
        }
    }

    @Override
    public long getDbId() throws IOException {
        FileTxnIterator fileTxnIterator = new FileTxnIterator(this.logDir, 0L);
        FileHeader fileHeader = FileTxnLog.readHeader(fileTxnIterator.logFile);
        fileTxnIterator.close();
        if (fileHeader == null) {
            throw new IOException("Unsupported Format.");
        }
        return fileHeader.getDbid();
    }

    public boolean isForceSync() {
        return this.forceSync;
    }

    static {
        TXNLOG_MAGIC = ByteBuffer.wrap("ZKLG".getBytes()).getInt();
        txnLogSizeLimit = -1L;
        LOG = goe.a(FileTxnLog.class);
        Long l2 = Long.getLong(ZOOKEEPER_FSYNC_WARNING_THRESHOLD_MS_PROPERTY);
        if (l2 == null) {
            l2 = Long.getLong(FSYNC_WARNING_THRESHOLD_MS_PROPERTY, 1000L);
        }
        fsyncWarningThresholdMS = l2;
        Long l3 = Long.getLong(txnLogSizeLimitSetting, -1L);
        if (l3 > 0L) {
            LOG.c("{} = {}", (Object)txnLogSizeLimitSetting, (Object)l3);
            l3 = l3 * 1024L;
            txnLogSizeLimit = l3;
        }
    }

    public static class FileTxnIterator
    implements TxnLog.TxnIterator {
        File logDir;
        long zxid;
        TxnHeader hdr;
        mme record;
        TxnDigest digest;
        File logFile;
        kme ia;
        static final String CRC_ERROR = "CRC check failed";
        PositionInputStream inputStream;
        private ArrayList<File> storedFiles;

        public FileTxnIterator(File file, long l2, boolean bl2) throws IOException {
            block1: {
                this.inputStream = null;
                this.logDir = file;
                this.zxid = l2;
                this.init();
                if (!bl2 || this.hdr == null) break block1;
                while (this.hdr.getZxid() < l2 && this.next()) {
                }
            }
        }

        public FileTxnIterator(File file, long l2) throws IOException {
            this(file, l2, true);
        }

        void init() throws IOException {
            this.storedFiles = new ArrayList();
            List<File> list = Util.sortDataDir(FileTxnLog.getLogFiles(this.logDir.listFiles(), 0L), FileTxnLog.LOG_FILE_PREFIX, false);
            for (File file : list) {
                if (Util.getZxidFromName(file.getName(), FileTxnLog.LOG_FILE_PREFIX) >= this.zxid) {
                    this.storedFiles.add(file);
                    continue;
                }
                if (Util.getZxidFromName(file.getName(), FileTxnLog.LOG_FILE_PREFIX) >= this.zxid) continue;
                this.storedFiles.add(file);
                break;
            }
            this.goToNextLog();
            this.next();
        }

        @Override
        public long getStorageSize() {
            long l2 = 0L;
            for (File file : this.storedFiles) {
                l2 += file.length();
            }
            return l2;
        }

        private boolean goToNextLog() throws IOException {
            if (this.storedFiles.size() > 0) {
                this.logFile = this.storedFiles.remove(this.storedFiles.size() - 1);
                this.ia = this.createInputArchive(this.logFile);
                return true;
            }
            return false;
        }

        protected void inStreamCreated(kme kme2, InputStream inputStream) throws IOException {
            FileHeader fileHeader = new FileHeader();
            fileHeader.deserialize(kme2, "fileheader");
            if (fileHeader.getMagic() != TXNLOG_MAGIC) {
                throw new IOException("Transaction log: " + this.logFile + " has invalid magic number " + fileHeader.getMagic() + " != " + TXNLOG_MAGIC);
            }
        }

        protected kme createInputArchive(File file) throws IOException {
            if (this.inputStream == null) {
                this.inputStream = new PositionInputStream(new BufferedInputStream(new FileInputStream(file)));
                LOG.b("Created new input stream: {}", (Object)file);
                this.ia = hme.a(this.inputStream);
                this.inStreamCreated(this.ia, this.inputStream);
                LOG.b("Created new input archive: {}", (Object)file);
            }
            return this.ia;
        }

        protected Checksum makeChecksumAlgorithm() {
            return new Adler32();
        }

        @Override
        public boolean next() throws IOException {
            if (this.ia == null) {
                return false;
            }
            try {
                long l2 = this.ia.d("crcvalue");
                byte[] byArray = Util.readTxnBytes(this.ia);
                if (byArray == null || byArray.length == 0) {
                    throw new EOFException("Failed to read " + this.logFile);
                }
                Checksum checksum = this.makeChecksumAlgorithm();
                checksum.update(byArray, 0, byArray.length);
                if (l2 != checksum.getValue()) {
                    throw new IOException(CRC_ERROR);
                }
                TxnLogEntry txnLogEntry = SerializeUtils.deserializeTxn(byArray);
                this.hdr = txnLogEntry.getHeader();
                this.record = txnLogEntry.getTxn();
                this.digest = txnLogEntry.getDigest();
            }
            catch (EOFException eOFException) {
                LOG.a("EOF exception", eOFException);
                this.inputStream.close();
                this.inputStream = null;
                this.ia = null;
                this.hdr = null;
                if (!this.goToNextLog()) {
                    return false;
                }
                return this.next();
            }
            catch (IOException iOException) {
                this.inputStream.close();
                throw iOException;
            }
            return true;
        }

        @Override
        public TxnHeader getHeader() {
            return this.hdr;
        }

        @Override
        public mme getTxn() {
            return this.record;
        }

        @Override
        public TxnDigest getDigest() {
            return this.digest;
        }

        @Override
        public void close() throws IOException {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
    }

    static class PositionInputStream
    extends FilterInputStream {
        long position = 0L;

        protected PositionInputStream(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public int read() throws IOException {
            int n2 = super.read();
            if (n2 > -1) {
                ++this.position;
            }
            return n2;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            int n2 = super.read(byArray);
            if (n2 > 0) {
                this.position += (long)n2;
            }
            return n2;
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            int n4 = super.read(byArray, n2, n3);
            if (n4 > 0) {
                this.position += (long)n4;
            }
            return n4;
        }

        @Override
        public long skip(long l2) throws IOException {
            long l3 = super.skip(l2);
            if (l3 > 0L) {
                this.position += l3;
            }
            return l3;
        }

        public long getPosition() {
            return this.position;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void mark(int n2) {
            throw new UnsupportedOperationException("mark");
        }

        @Override
        public void reset() {
            throw new UnsupportedOperationException("reset");
        }
    }
}

