/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.controller;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ExitCode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxnFactory;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.controller.CommandListener;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.controller.ControllerServerConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.controller.ZooKeeperServerController;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.util.ServiceUtils;
import java.io.IOException;

public class ControllerService {
    private static final foe LOG = goe.a(ControllerService.class);
    private ZooKeeperServerController controller;
    private CommandListener listener;
    protected QuorumPeerConfig config;
    private ServerCnxnFactory serverCnxnFactory = null;
    protected QuorumPeer quorumPeer = null;

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 1) {
                throw new IllegalArgumentException("Require config file as cmd line argument");
            }
            ControllerServerConfig controllerServerConfig = new ControllerServerConfig(stringArray[0]);
            new ControllerService().start(controllerServerConfig);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            System.err.println("Usage: TestControllerMain controller-port configfile");
            ServiceUtils.requestSystemExit(ExitCode.UNEXPECTED_ERROR.getValue());
        }
    }

    public Thread start(ControllerServerConfig controllerServerConfig) {
        this.config = controllerServerConfig;
        ControllerService controllerService = this;
        Thread thread = new Thread(() -> {
            try {
                controllerService.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    public synchronized void shutdown() {
        if (this.listener != null) {
            this.listener.close();
            this.listener = null;
        }
        if (this.controller != null) {
            this.controller.shutdown();
            this.controller = null;
        }
    }

    protected void initService() throws IOException {
        ControllerServerConfig controllerServerConfig = (ControllerServerConfig)this.config;
        controllerServerConfig.ensureComplete();
        this.controller = new ZooKeeperServerController(controllerServerConfig);
        this.listener = new CommandListener(this.controller, controllerServerConfig);
        this.serverCnxnFactory = this.controller.getCnxnFactory();
    }

    protected void runServices() {
        this.controller.run();
    }

    protected void cleanup() {
        if (this.listener != null) {
            this.listener.close();
            this.listener = null;
        }
    }

    public void initializeAndRun(String[] stringArray) throws QuorumPeerConfig.ConfigException {
        this.initConfig(stringArray);
        this.run();
    }

    protected void initConfig(String[] stringArray) throws QuorumPeerConfig.ConfigException {
        if (stringArray.length == 1) {
            this.config.parse(stringArray[0]);
        }
    }

    public void runFromConfig(QuorumPeerConfig quorumPeerConfig) {
        LOG.c("Starting quorum peer from peer config");
        this.config = quorumPeerConfig;
        this.run();
    }

    protected void run() {
        try {
            this.initService();
        }
        catch (Exception exception) {
            LOG.d("Failed to start ControllerService.", exception);
            ServiceUtils.requestSystemExit(ExitCode.UNEXPECTED_ERROR.getValue());
        }
        this.runServices();
        this.cleanup();
    }

    public boolean isReady() {
        return this.controller != null && this.controller.isReady();
    }
}

