/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.controller;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ExitCode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.controller.ControlCommand;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.controller.ControllerServerConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.controller.ZooKeeperServerController;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.util.ServiceUtils;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class CommandListener {
    private static final foe LOG = goe.a(CommandListener.class);
    private ZooKeeperServerController controller;
    private Server server;

    public CommandListener(ZooKeeperServerController zooKeeperServerController, ControllerServerConfig controllerServerConfig) {
        try {
            this.controller = zooKeeperServerController;
            String string = controllerServerConfig.getControllerAddress().getHostName();
            int n2 = controllerServerConfig.getControllerAddress().getPort();
            this.server = new Server(n2);
            LOG.c("CommandListener server host: {} with port: {}", (Object)string, (Object)n2);
            this.server.setHandler((Handler)new CommandHandler());
            this.server.start();
        }
        catch (Exception exception) {
            LOG.d("Failed to instantiate CommandListener.", exception);
            ServiceUtils.requestSystemExit(ExitCode.UNEXPECTED_ERROR.getValue());
        }
    }

    public void close() {
        try {
            if (this.server != null) {
                this.server.stop();
                this.server = null;
            }
        }
        catch (Exception exception) {
            LOG.c("Exception during shutdown CommandListener server", exception);
        }
    }

    class CommandHandler
    extends AbstractHandler {
        private CommandHandler() {
        }

        public void handle(String string, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
            int n2;
            String string2 = httpServletRequest.getPathInfo().substring(1);
            httpServletResponse.setContentType("text/html;charset=utf-8");
            try {
                ControlCommand controlCommand = ControlCommand.parseUri(string2);
                CommandListener.this.controller.processCommand(controlCommand);
                request.setHandled(true);
                n2 = 200;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.d("Bad argument or command", illegalArgumentException);
                n2 = 400;
            }
            catch (Exception exception) {
                LOG.d("Failed processing the request", exception);
                throw exception;
            }
            httpServletResponse.setStatus(n2);
            httpServletResponse.getWriter().println(string2);
            LOG.c("CommandListener processed command {} with response code {}", (Object)string2, (Object)n2);
        }
    }
}

