/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth.KerberosName;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;

public class SaslServerCallbackHandler
implements CallbackHandler {
    private static final String USER_PREFIX = "user_";
    private static final foe LOG = goe.a(SaslServerCallbackHandler.class);
    private static final String SYSPROP_SUPER_PASSWORD = "zookeeper.SASLAuthenticationProvider.superPassword";
    private static final String SYSPROP_REMOVE_HOST = "zookeeper.kerberos.removeHostFromPrincipal";
    private static final String SYSPROP_REMOVE_REALM = "zookeeper.kerberos.removeRealmFromPrincipal";
    private String userName;
    private final Map<String, String> credentials = new HashMap<String, String>();

    public SaslServerCallbackHandler(Configuration configuration) throws IOException {
        String string = System.getProperty("zookeeper.sasl.serverconfig", "Server");
        AppConfigurationEntry[] appConfigurationEntryArray = configuration.getAppConfigurationEntry(string);
        if (appConfigurationEntryArray == null) {
            String string2 = "Could not find a '" + string + "' entry in this configuration: Server cannot start.";
            LOG.e(string2);
            throw new IOException(string2);
        }
        this.credentials.clear();
        for (AppConfigurationEntry appConfigurationEntry : appConfigurationEntryArray) {
            Map<String, ?> map = appConfigurationEntry.getOptions();
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                String string3 = entry.getKey();
                if (!string3.startsWith(USER_PREFIX)) continue;
                String string4 = string3.substring(USER_PREFIX.length());
                this.credentials.put(string4, (String)entry.getValue());
            }
        }
    }

    @Override
    public void handle(Callback[] callbackArray) throws UnsupportedCallbackException {
        for (Callback callback : callbackArray) {
            if (callback instanceof NameCallback) {
                this.handleNameCallback((NameCallback)callback);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                this.handlePasswordCallback((PasswordCallback)callback);
                continue;
            }
            if (callback instanceof RealmCallback) {
                this.handleRealmCallback((RealmCallback)callback);
                continue;
            }
            if (!(callback instanceof AuthorizeCallback)) continue;
            this.handleAuthorizeCallback((AuthorizeCallback)callback);
        }
    }

    private void handleNameCallback(NameCallback nameCallback) {
        if (this.credentials.get(nameCallback.getDefaultName()) == null) {
            LOG.d("User '{}' not found in list of DIGEST-MD5 authenticateable users.", (Object)nameCallback.getDefaultName());
            return;
        }
        nameCallback.setName(nameCallback.getDefaultName());
        this.userName = nameCallback.getDefaultName();
    }

    private void handlePasswordCallback(PasswordCallback passwordCallback) {
        if ("super".equals(this.userName) && System.getProperty(SYSPROP_SUPER_PASSWORD) != null) {
            passwordCallback.setPassword(System.getProperty(SYSPROP_SUPER_PASSWORD).toCharArray());
        } else if (this.credentials.containsKey(this.userName)) {
            passwordCallback.setPassword(this.credentials.get(this.userName).toCharArray());
        } else {
            LOG.d("No password found for user: {}", (Object)this.userName);
        }
    }

    private void handleRealmCallback(RealmCallback realmCallback) {
        LOG.b("client supplied realm: {}", (Object)realmCallback.getDefaultText());
        realmCallback.setText(realmCallback.getDefaultText());
    }

    private void handleAuthorizeCallback(AuthorizeCallback authorizeCallback) {
        String string = authorizeCallback.getAuthenticationID();
        String string2 = authorizeCallback.getAuthorizationID();
        LOG.c("Successfully authenticated client: authenticationID={};  authorizationID={}.", (Object)string, (Object)string2);
        authorizeCallback.setAuthorized(true);
        KerberosName kerberosName = new KerberosName(string);
        try {
            StringBuilder stringBuilder = new StringBuilder(kerberosName.getShortName());
            if (this.shouldAppendHost(kerberosName)) {
                stringBuilder.append("/").append(kerberosName.getHostName());
            }
            if (this.shouldAppendRealm(kerberosName)) {
                stringBuilder.append("@").append(kerberosName.getRealm());
            }
            LOG.c("Setting authorizedID: {}", (Object)stringBuilder);
            authorizeCallback.setAuthorizedID(stringBuilder.toString());
        }
        catch (IOException iOException) {
            LOG.d("Failed to set name based on Kerberos authentication rules.", iOException);
        }
    }

    private boolean shouldAppendRealm(KerberosName kerberosName) {
        return !this.isSystemPropertyTrue(SYSPROP_REMOVE_REALM) && kerberosName.getRealm() != null;
    }

    private boolean shouldAppendHost(KerberosName kerberosName) {
        return !this.isSystemPropertyTrue(SYSPROP_REMOVE_HOST) && kerberosName.getHostName() != null;
    }

    private boolean isSystemPropertyTrue(String string) {
        return "true".equals(System.getProperty(string));
    }
}

