/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Id;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Stat;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZKDatabase;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth.ServerAuthenticationProvider;
import java.nio.charset.StandardCharsets;

public class KeyAuthenticationProvider
extends ServerAuthenticationProvider {
    private static final foe LOG = goe.a(KeyAuthenticationProvider.class);

    @Override
    public String getScheme() {
        return "key";
    }

    private byte[] getKey(ZooKeeperServer zooKeeperServer) {
        ZKDatabase zKDatabase = zooKeeperServer.getZKDatabase();
        if (zKDatabase != null) {
            try {
                Stat stat = new Stat();
                return zKDatabase.getData("/key", stat, null);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                LOG.d("getData failed", noNodeException);
            }
        }
        return null;
    }

    private boolean validate(byte[] byArray, byte[] byArray2) {
        try {
            String string = new String(byArray, StandardCharsets.UTF_8);
            String string2 = new String(byArray2, StandardCharsets.UTF_8);
            int n2 = Integer.parseInt(string);
            int n3 = Integer.parseInt(string2);
            if (n2 != 0 && n3 % n2 != 0) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            LOG.d("bad formatting", numberFormatException);
            return false;
        }
        return true;
    }

    @Override
    public KeeperException.Code handleAuthentication(ServerAuthenticationProvider.ServerObjs serverObjs, byte[] byArray) {
        byte[] byArray2 = this.getKey(serverObjs.getZks());
        String string = new String(byArray, StandardCharsets.UTF_8);
        String string2 = "";
        if (byArray2 != null && !this.validate(byArray2, byArray)) {
            string2 = new String(byArray2, StandardCharsets.UTF_8);
            LOG.b("KeyAuthenticationProvider handleAuthentication ({}, {}) -> FAIL.\n", (Object)string2, (Object)string);
            return KeeperException.Code.AUTHFAILED;
        }
        LOG.b("KeyAuthenticationProvider handleAuthentication -> OK.\n");
        serverObjs.getCnxn().addAuthInfo(new Id(this.getScheme(), string2));
        return KeeperException.Code.OK;
    }

    @Override
    public boolean matches(ServerAuthenticationProvider.ServerObjs serverObjs, ServerAuthenticationProvider.MatchValues matchValues) {
        return matchValues.getId().equals(matchValues.getAclExpr());
    }

    @Override
    public boolean isAuthenticated() {
        return true;
    }

    @Override
    public boolean isValid(String string) {
        return true;
    }
}

