/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.KerberosUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KerberosName {
    private final String serviceName;
    private final String hostName;
    private final String realm;
    private static final Pattern nameParser = Pattern.compile("([^/@]*)(/([^/@]*))?@([^/@]*)");
    private static Pattern parameterPattern = Pattern.compile("([^$]*)(\\$(\\d*))?");
    private static final Pattern ruleParser = Pattern.compile("\\s*((DEFAULT)|(RULE:\\[(\\d*):([^\\]]*)](\\(([^)]*)\\))?(s/([^/]*)/([^/]*)/(g)?)?))");
    private static final Pattern nonSimplePattern = Pattern.compile("[/@]");
    private static List<Rule> rules;
    private static String defaultRealm;

    public KerberosName(String string) {
        Matcher matcher = nameParser.matcher(string);
        if (!matcher.matches()) {
            if (string.contains("@")) {
                throw new IllegalArgumentException("Malformed Kerberos name: " + string);
            }
            this.serviceName = string;
            this.hostName = null;
            this.realm = null;
        } else {
            this.serviceName = matcher.group(1);
            this.hostName = matcher.group(3);
            this.realm = matcher.group(4);
        }
    }

    public String getDefaultRealm() {
        return defaultRealm;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.serviceName);
        if (this.hostName != null) {
            stringBuilder.append('/');
            stringBuilder.append(this.hostName);
        }
        if (this.realm != null) {
            stringBuilder.append('@');
            stringBuilder.append(this.realm);
        }
        return stringBuilder.toString();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getRealm() {
        return this.realm;
    }

    static List<Rule> parseRules(String string) {
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        String string2 = string.trim();
        while (string2.length() > 0) {
            Matcher matcher = ruleParser.matcher(string2);
            if (!matcher.lookingAt()) {
                throw new IllegalArgumentException("Invalid rule: " + string2);
            }
            if (matcher.group(2) != null) {
                arrayList.add(new Rule());
            } else {
                arrayList.add(new Rule(Integer.parseInt(matcher.group(4)), matcher.group(5), matcher.group(7), matcher.group(9), matcher.group(10), "g".equals(matcher.group(11))));
            }
            string2 = string2.substring(matcher.end());
        }
        return arrayList;
    }

    public static void setConfiguration() throws IOException {
        String string = System.getProperty("zookeeper.security.auth_to_local", "DEFAULT");
        rules = KerberosName.parseRules(string);
    }

    public String getShortName() throws IOException {
        String[] stringArray;
        if (this.hostName == null) {
            if (this.realm == null) {
                return this.serviceName;
            }
            stringArray = new String[]{this.realm, this.serviceName};
        } else {
            stringArray = new String[]{this.realm, this.serviceName, this.hostName};
        }
        for (Rule rule : rules) {
            String string = rule.apply(stringArray);
            if (string == null) continue;
            return string;
        }
        throw new NoMatchingRule("No rules applied to " + this.toString());
    }

    static void printRules() throws IOException {
        int n2 = 0;
        for (Rule rule : rules) {
            System.out.println(++n2 + " " + rule);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        for (String string : stringArray) {
            KerberosName kerberosName = new KerberosName(string);
            System.out.println("Name: " + kerberosName + " to " + kerberosName.getShortName());
        }
    }

    static {
        try {
            defaultRealm = KerberosUtil.getDefaultRealm();
        }
        catch (Exception exception) {
            if (System.getProperty("zookeeper.requireKerberosConfig") != null && System.getProperty("zookeeper.requireKerberosConfig").equals("true")) {
                throw new IllegalArgumentException("Can't get Kerberos configuration", exception);
            }
            defaultRealm = "";
        }
        try {
            KerberosName.setConfiguration();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Could not configure Kerberos principal name mapping.");
        }
    }

    public static class NoMatchingRule
    extends IOException {
        NoMatchingRule(String string) {
            super(string);
        }
    }

    public static class BadFormatString
    extends IOException {
        BadFormatString(String string) {
            super(string);
        }

        BadFormatString(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    static class Rule {
        private final boolean isDefault;
        private final int numOfComponents;
        private final String format;
        private final Pattern match;
        private final Pattern fromPattern;
        private final String toPattern;
        private final boolean repeat;

        Rule() {
            this.isDefault = true;
            this.numOfComponents = 0;
            this.format = null;
            this.match = null;
            this.fromPattern = null;
            this.toPattern = null;
            this.repeat = false;
        }

        Rule(int n2, String string, String string2, String string3, String string4, boolean bl2) {
            this.isDefault = false;
            this.numOfComponents = n2;
            this.format = string;
            this.match = string2 == null ? null : Pattern.compile(string2);
            this.fromPattern = string3 == null ? null : Pattern.compile(string3);
            this.toPattern = string4;
            this.repeat = bl2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.isDefault) {
                stringBuilder.append("DEFAULT");
            } else {
                stringBuilder.append("RULE:[");
                stringBuilder.append(this.numOfComponents);
                stringBuilder.append(':');
                stringBuilder.append(this.format);
                stringBuilder.append(']');
                if (this.match != null) {
                    stringBuilder.append('(');
                    stringBuilder.append(this.match);
                    stringBuilder.append(')');
                }
                if (this.fromPattern != null) {
                    stringBuilder.append("s/");
                    stringBuilder.append(this.fromPattern);
                    stringBuilder.append('/');
                    stringBuilder.append(this.toPattern);
                    stringBuilder.append('/');
                    if (this.repeat) {
                        stringBuilder.append('g');
                    }
                }
            }
            return stringBuilder.toString();
        }

        static String replaceParameters(String string, String[] stringArray) throws BadFormatString {
            Matcher matcher = parameterPattern.matcher(string);
            int n2 = 0;
            StringBuilder stringBuilder = new StringBuilder();
            while (n2 < string.length() && matcher.find(n2)) {
                stringBuilder.append(matcher.group(1));
                String string2 = matcher.group(3);
                if (string2 != null) {
                    try {
                        int n3 = Integer.parseInt(string2);
                        if (n3 < 0 || n3 > stringArray.length) {
                            throw new BadFormatString(String.format("index %d from %s is outside of the valid range 0 to %d", n3, string, stringArray.length - 1));
                        }
                        stringBuilder.append(stringArray[n3]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new BadFormatString("bad format in username mapping in " + string2, numberFormatException);
                    }
                }
                n2 = matcher.end();
            }
            return stringBuilder.toString();
        }

        static String replaceSubstitution(String string, Pattern pattern, String string2, boolean bl2) {
            Matcher matcher = pattern.matcher(string);
            if (bl2) {
                return matcher.replaceAll(string2);
            }
            return matcher.replaceFirst(string2);
        }

        String apply(String[] stringArray) throws IOException {
            String string = null;
            if (this.isDefault) {
                if (defaultRealm.equals(stringArray[0])) {
                    string = stringArray[1];
                }
            } else if (stringArray.length - 1 == this.numOfComponents) {
                String string2 = Rule.replaceParameters(this.format, stringArray);
                if (this.match == null || this.match.matcher(string2).matches()) {
                    string = this.fromPattern == null ? string2 : Rule.replaceSubstitution(string2, this.fromPattern, this.toPattern, this.repeat);
                }
            }
            if (string != null && nonSimplePattern.matcher(string).find()) {
                throw new NoMatchingRule("Non-simple name " + string + " after auth_to_local rule " + this);
            }
            return string;
        }
    }
}

