/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth.AuthenticationProvider;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;

public class EnsembleAuthenticationProvider
implements AuthenticationProvider {
    private static final foe LOG = goe.a(EnsembleAuthenticationProvider.class);
    public static final String ENSEMBLE_PROPERTY = "zookeeper.ensembleAuthName";
    private static final int MIN_LOGGING_INTERVAL_MS = 1000;
    private Set<String> ensembleNames;
    private long lastFailureLogged;

    public EnsembleAuthenticationProvider() {
        String string = System.getProperty(ENSEMBLE_PROPERTY);
        if (string != null) {
            LOG.c("Set expected ensemble names to {}", (Object)string);
            this.setEnsembleNames(string);
        }
    }

    public void setEnsembleNames(String string) {
        this.ensembleNames = new HashSet<String>();
        for (String string2 : string.split(",")) {
            this.ensembleNames.add(string2.trim());
        }
    }

    @Override
    public String getScheme() {
        return "ensemble";
    }

    @Override
    public KeeperException.Code handleAuthentication(ServerCnxn serverCnxn, byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            ServerMetrics.getMetrics().ENSEMBLE_AUTH_SKIP.add(1L);
            return KeeperException.Code.OK;
        }
        String string = new String(byArray, StandardCharsets.UTF_8);
        if (this.ensembleNames == null) {
            ServerMetrics.getMetrics().ENSEMBLE_AUTH_SKIP.add(1L);
            return KeeperException.Code.OK;
        }
        if (this.ensembleNames.contains(string)) {
            ServerMetrics.getMetrics().ENSEMBLE_AUTH_SUCCESS.add(1L);
            return KeeperException.Code.OK;
        }
        long l2 = System.currentTimeMillis();
        if (this.lastFailureLogged + 1000L < l2) {
            String string2 = serverCnxn.getRemoteSocketAddress().getAddress().getHostAddress();
            LOG.d("Unexpected ensemble name: ensemble name: {} client ip: {}", (Object)string, (Object)string2);
            this.lastFailureLogged = l2;
        }
        ServerMetrics.getMetrics().ENSEMBLE_AUTH_FAIL.add(1L);
        serverCnxn.close(ServerCnxn.DisconnectReason.FAILED_HANDSHAKE);
        return KeeperException.Code.BADARGUMENTS;
    }

    @Override
    public boolean matches(String string, String string2) {
        return false;
    }

    @Override
    public boolean isAuthenticated() {
        return false;
    }

    @Override
    public boolean isValid(String string) {
        return false;
    }
}

