/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Id;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth.AuthenticationProvider;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class DigestAuthenticationProvider
implements AuthenticationProvider {
    private static final foe LOG = goe.a(DigestAuthenticationProvider.class);
    private static final String DEFAULT_DIGEST_ALGORITHM = "SHA1";
    public static final String DIGEST_ALGORITHM_KEY = "zookeeper.DigestAuthenticationProvider.digestAlg";
    private static final String DIGEST_ALGORITHM = System.getProperty("zookeeper.DigestAuthenticationProvider.digestAlg", "SHA1");
    private static final String DIGEST_AUTH_ENABLED = "zookeeper.DigestAuthenticationProvider.enabled";
    private static final String superDigest;

    public static boolean isEnabled() {
        boolean bl2 = Boolean.parseBoolean(System.getProperty(DIGEST_AUTH_ENABLED, "true"));
        LOG.c("{} = {}", (Object)DIGEST_AUTH_ENABLED, (Object)bl2);
        return bl2;
    }

    @Override
    public String getScheme() {
        return "digest";
    }

    private static String base64Encode(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = 0;
            int n4 = (byArray[n2++] & 0xFF) << 16;
            if (n2 < byArray.length) {
                n4 |= (byArray[n2++] & 0xFF) << 8;
            } else {
                ++n3;
            }
            if (n2 < byArray.length) {
                n4 |= byArray[n2++] & 0xFF;
            } else {
                ++n3;
            }
            stringBuilder.append(DigestAuthenticationProvider.encode(n4 >> 18));
            stringBuilder.append(DigestAuthenticationProvider.encode(n4 >> 12));
            if (n3 < 2) {
                stringBuilder.append(DigestAuthenticationProvider.encode(n4 >> 6));
            } else {
                stringBuilder.append('=');
            }
            if (n3 < 1) {
                stringBuilder.append(DigestAuthenticationProvider.encode(n4));
                continue;
            }
            stringBuilder.append('=');
        }
        return stringBuilder.toString();
    }

    private static char encode(int n2) {
        if ((n2 &= 0x3F) < 26) {
            return (char)(65 + n2);
        }
        if (n2 < 52) {
            return (char)(97 + n2 - 26);
        }
        if (n2 < 62) {
            return (char)(48 + n2 - 52);
        }
        return n2 == 62 ? (char)'+' : '/';
    }

    public static String generateDigest(String string) throws NoSuchAlgorithmException {
        String[] stringArray = string.split(":", 2);
        byte[] byArray = DigestAuthenticationProvider.digest(string);
        return stringArray[0] + ":" + DigestAuthenticationProvider.base64Encode(byArray);
    }

    public static byte[] digest(String string) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(DIGEST_ALGORITHM).digest(string.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public KeeperException.Code handleAuthentication(ServerCnxn serverCnxn, byte[] byArray) {
        List<Id> list = this.handleAuthentication(byArray);
        if (list.isEmpty()) {
            return KeeperException.Code.AUTHFAILED;
        }
        for (Id id2 : list) {
            serverCnxn.addAuthInfo(id2);
        }
        return KeeperException.Code.OK;
    }

    @Override
    public List<Id> handleAuthentication(HttpServletRequest httpServletRequest, byte[] byArray) {
        return this.handleAuthentication(byArray);
    }

    @Override
    public boolean isAuthenticated() {
        return true;
    }

    @Override
    public boolean isValid(String string) {
        String[] stringArray = string.split(":");
        return stringArray.length == 2;
    }

    @Override
    public boolean matches(String string, String string2) {
        return string.equals(string2);
    }

    @Override
    public String getUserName(String string) {
        return string.split(":")[0];
    }

    public static void main(String[] stringArray) throws NoSuchAlgorithmException {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            System.out.println(stringArray[i2] + "->" + DigestAuthenticationProvider.generateDigest(stringArray[i2]));
        }
    }

    private List<Id> handleAuthentication(byte[] byArray) {
        ArrayList<Id> arrayList = new ArrayList<Id>();
        String string = new String(byArray);
        try {
            String string2 = DigestAuthenticationProvider.generateDigest(string);
            if (string2.equals(superDigest)) {
                arrayList.add(new Id("super", ""));
            }
            arrayList.add(new Id(this.getScheme(), string2));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.d("Missing algorithm", noSuchAlgorithmException);
        }
        return Collections.unmodifiableList(arrayList);
    }

    static {
        try {
            DigestAuthenticationProvider.generateDigest(DIGEST_ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("don't support this ACL digest algorithm: " + DIGEST_ALGORITHM + " in the current environment");
        }
        LOG.c("ACL digest algorithm is: {}", (Object)DIGEST_ALGORITHM);
        superDigest = System.getProperty("zookeeper.DigestAuthenticationProvider.superDigest");
    }
}

