/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin.CommandOutputter;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin.CommandResponse;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class JsonOutputter
implements CommandOutputter {
    static final foe LOG = goe.a(JsonOutputter.class);
    public static final String ERROR_RESPONSE = "{\"error\": \"Exception writing command response to JSON\"}";
    private ObjectMapper mapper = new ObjectMapper();
    private final String clientIP;

    public JsonOutputter(String string) {
        this.mapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        this.mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        this.mapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        this.clientIP = string;
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public void output(CommandResponse commandResponse, PrintWriter printWriter) {
        try {
            this.mapper.writeValue((Writer)printWriter, commandResponse.toMap());
        }
        catch (JsonGenerationException jsonGenerationException) {
            LOG.c("Exception writing command response to JSON:", jsonGenerationException);
            printWriter.write(ERROR_RESPONSE);
        }
        catch (JsonMappingException jsonMappingException) {
            LOG.c("Exception writing command response to JSON:", jsonMappingException);
            printWriter.write(ERROR_RESPONSE);
        }
        catch (IOException iOException) {
            LOG.d("Exception writing command response as JSON to {}", (Object)this.clientIP, (Object)iOException);
            printWriter.write(ERROR_RESPONSE);
        }
    }
}

