/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.audit.ZKAuditProvider;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.jmx.ManagedUtil;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.MetricsProvider;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.MetricsProviderLifeCycleException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.impl.MetricsProviderBootstrap;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ContainerManager;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ExitCode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxnFactory;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServerShutdownHandler;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin.AdminServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin.AdminServerFactory;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth.ProviderRegistry;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.JvmPauseMonitor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.util.ServiceUtils;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;

public class ZooKeeperServerMain {
    private static final foe LOG = goe.a(ZooKeeperServerMain.class);
    private static final String USAGE = "Usage: ZooKeeperServerMain configfile | port datadir [ticktime] [maxcnxns]";
    private ServerCnxnFactory cnxnFactory;
    private ServerCnxnFactory secureCnxnFactory;
    private ContainerManager containerManager;
    private MetricsProvider metricsProvider;
    private AdminServer adminServer;

    public static void main(String[] stringArray) {
        ZooKeeperServerMain zooKeeperServerMain = new ZooKeeperServerMain();
        try {
            zooKeeperServerMain.initializeAndRun(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.d("Invalid arguments, exiting abnormally", illegalArgumentException);
            LOG.c(USAGE);
            System.err.println(USAGE);
            ZKAuditProvider.addServerStartFailureAuditLog();
            ServiceUtils.requestSystemExit(ExitCode.INVALID_INVOCATION.getValue());
        }
        catch (QuorumPeerConfig.ConfigException configException) {
            LOG.d("Invalid config, exiting abnormally", configException);
            System.err.println("Invalid config, exiting abnormally");
            ZKAuditProvider.addServerStartFailureAuditLog();
            ServiceUtils.requestSystemExit(ExitCode.INVALID_INVOCATION.getValue());
        }
        catch (FileTxnSnapLog.DatadirException datadirException) {
            LOG.d("Unable to access datadir, exiting abnormally", datadirException);
            System.err.println("Unable to access datadir, exiting abnormally");
            ZKAuditProvider.addServerStartFailureAuditLog();
            ServiceUtils.requestSystemExit(ExitCode.UNABLE_TO_ACCESS_DATADIR.getValue());
        }
        catch (AdminServer.AdminServerException adminServerException) {
            LOG.d("Unable to start AdminServer, exiting abnormally", adminServerException);
            System.err.println("Unable to start AdminServer, exiting abnormally");
            ZKAuditProvider.addServerStartFailureAuditLog();
            ServiceUtils.requestSystemExit(ExitCode.ERROR_STARTING_ADMIN_SERVER.getValue());
        }
        catch (Exception exception) {
            LOG.d("Unexpected exception, exiting abnormally", exception);
            ZKAuditProvider.addServerStartFailureAuditLog();
            ServiceUtils.requestSystemExit(ExitCode.UNEXPECTED_ERROR.getValue());
        }
        LOG.c("Exiting normally");
        ServiceUtils.requestSystemExit(ExitCode.EXECUTION_FINISHED.getValue());
    }

    protected void initializeAndRun(String[] stringArray) throws QuorumPeerConfig.ConfigException, IOException, AdminServer.AdminServerException {
        try {
            ManagedUtil.registerLog4jMBeans();
        }
        catch (JMException jMException) {
            LOG.c("Unable to register log4j JMX control", jMException);
        }
        ServerConfig serverConfig = new ServerConfig();
        if (stringArray.length == 1) {
            serverConfig.parse(stringArray[0]);
        } else {
            serverConfig.parse(stringArray);
        }
        this.runFromConfig(serverConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runFromConfig(ServerConfig serverConfig) throws IOException, AdminServer.AdminServerException {
        LOG.c("Starting server");
        FileTxnSnapLog fileTxnSnapLog = null;
        try {
            try {
                this.metricsProvider = MetricsProviderBootstrap.startMetricsProvider(serverConfig.getMetricsProviderClassName(), serverConfig.getMetricsProviderConfiguration());
            }
            catch (MetricsProviderLifeCycleException metricsProviderLifeCycleException) {
                throw new IOException("Cannot boot MetricsProvider " + serverConfig.getMetricsProviderClassName(), metricsProviderLifeCycleException);
            }
            ServerMetrics.metricsProviderInitialized(this.metricsProvider);
            ProviderRegistry.initialize();
            fileTxnSnapLog = new FileTxnSnapLog(serverConfig.dataLogDir, serverConfig.dataDir);
            JvmPauseMonitor jvmPauseMonitor = null;
            if (serverConfig.jvmPauseMonitorToRun) {
                jvmPauseMonitor = new JvmPauseMonitor(serverConfig);
            }
            ZooKeeperServer zooKeeperServer = new ZooKeeperServer(jvmPauseMonitor, fileTxnSnapLog, serverConfig.tickTime, serverConfig.minSessionTimeout, serverConfig.maxSessionTimeout, serverConfig.listenBacklog, null, serverConfig.initialConfig);
            fileTxnSnapLog.setServerStats(zooKeeperServer.serverStats());
            CountDownLatch countDownLatch = new CountDownLatch(1);
            zooKeeperServer.registerServerShutdownHandler(new ZooKeeperServerShutdownHandler(countDownLatch));
            this.adminServer = AdminServerFactory.createAdminServer();
            this.adminServer.setZooKeeperServer(zooKeeperServer);
            this.adminServer.start();
            boolean bl2 = true;
            if (serverConfig.getClientPortAddress() != null) {
                this.cnxnFactory = ServerCnxnFactory.createFactory();
                this.cnxnFactory.configure(serverConfig.getClientPortAddress(), serverConfig.getMaxClientCnxns(), serverConfig.getClientPortListenBacklog(), false);
                this.cnxnFactory.startup(zooKeeperServer);
                bl2 = false;
            }
            if (serverConfig.getSecureClientPortAddress() != null) {
                this.secureCnxnFactory = ServerCnxnFactory.createFactory();
                this.secureCnxnFactory.configure(serverConfig.getSecureClientPortAddress(), serverConfig.getMaxClientCnxns(), serverConfig.getClientPortListenBacklog(), true);
                this.secureCnxnFactory.startup(zooKeeperServer, bl2);
            }
            this.containerManager = new ContainerManager(zooKeeperServer.getZKDatabase(), zooKeeperServer.firstProcessor, Integer.getInteger("znode.container.checkIntervalMs", (int)TimeUnit.MINUTES.toMillis(1L)), Integer.getInteger("znode.container.maxPerMinute", 10000), Long.getLong("znode.container.maxNeverUsedIntervalMs", 0L));
            this.containerManager.start();
            ZKAuditProvider.addZKStartStopAuditLog();
            this.serverStarted();
            countDownLatch.await();
            this.shutdown();
            if (this.cnxnFactory != null) {
                this.cnxnFactory.join();
            }
            if (this.secureCnxnFactory != null) {
                this.secureCnxnFactory.join();
            }
            if (zooKeeperServer.canShutdown()) {
                zooKeeperServer.shutdown(true);
            }
        }
        catch (InterruptedException interruptedException) {
            LOG.c("Server interrupted", interruptedException);
        }
        finally {
            if (fileTxnSnapLog != null) {
                fileTxnSnapLog.close();
            }
            if (this.metricsProvider != null) {
                try {
                    this.metricsProvider.stop();
                }
                catch (Throwable throwable) {
                    LOG.c("Error while stopping metrics", throwable);
                }
            }
        }
    }

    protected void shutdown() {
        if (this.containerManager != null) {
            this.containerManager.stop();
        }
        if (this.cnxnFactory != null) {
            this.cnxnFactory.shutdown();
        }
        if (this.secureCnxnFactory != null) {
            this.secureCnxnFactory.shutdown();
        }
        try {
            if (this.adminServer != null) {
                this.adminServer.shutdown();
            }
        }
        catch (AdminServer.AdminServerException adminServerException) {
            LOG.c("Problem stopping AdminServer", adminServerException);
        }
    }

    ServerCnxnFactory getCnxnFactory() {
        return this.cnxnFactory;
    }

    ServerCnxnFactory getSecureCnxnFactory() {
        return this.secureCnxnFactory;
    }

    public int getClientPort() {
        if (this.cnxnFactory != null) {
            return this.cnxnFactory.getLocalPort();
        }
        return 0;
    }

    public int getSecureClientPort() {
        if (this.secureCnxnFactory != null) {
            return this.secureCnxnFactory.getLocalPort();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ServerCnxnFactory serverCnxnFactory = this.cnxnFactory;
        ServerCnxnFactory serverCnxnFactory2 = this.secureCnxnFactory;
        try {
            if (serverCnxnFactory == null) {
                serverCnxnFactory = serverCnxnFactory2;
            }
            if (serverCnxnFactory == null || serverCnxnFactory.getZooKeeperServer() == null) {
                LOG.c("Connection factory did not start");
                return;
            }
            ZooKeeperServerShutdownHandler zooKeeperServerShutdownHandler = serverCnxnFactory.getZooKeeperServer().getZkShutdownHandler();
            zooKeeperServerShutdownHandler.handle(ZooKeeperServer.State.SHUTDOWN);
            try {
                serverCnxnFactory.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            if (serverCnxnFactory != null) {
                serverCnxnFactory.shutdown();
            }
            if (serverCnxnFactory2 != null) {
                serverCnxnFactory2.shutdown();
            }
        }
    }

    public void serverStarted() {
    }
}

