/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XcoreXdatabricksX240X9088.hme;
import XcoreXdatabricksX240X9088.ime;
import XcoreXdatabricksX240X9088.mme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Environment;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Quotas;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.StatsTrack;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Version;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ZookeeperBanner;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.PathUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.StringUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.ACL;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Id;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.StatPersisted;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.jmx.MBeanRegistry;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.MetricsContext;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.AuthPacket;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.ConnectRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.ConnectResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.CreateRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.DeleteRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetSASLRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.ReplyHeader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.RequestHeader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SetACLRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SetDataRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SetSASLResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.AuthenticationHelper;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.BlueThrottle;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ClientCnxnLimitException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataNode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataTree;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataTreeBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ExitCode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.FinalRequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.NettyServerCnxnFactory;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.PrepRequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.RateLogger;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.RequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.RequestRecord;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.RequestThrottler;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ResponseCache;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxnFactory;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerStats;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.SessionTracker;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.SessionTrackerImpl;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.SyncRequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.UnimplementedRequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZKDatabase;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperSaslServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServerBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServerConf;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServerListener;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServerListenerImpl;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServerShutdownHandler;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooTrace;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth.ProviderRegistry;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth.ServerAuthenticationProvider;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.ReadOnlyZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.JvmPauseMonitor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.OSMXBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.QuotaMetricsUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.RequestPathMetricsCollector;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.CreateSessionTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnDigest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnHeader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.util.ServiceUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import javax.security.sasl.SaslException;

public class ZooKeeperServer
implements ServerStats.Provider,
SessionTracker.SessionExpirer {
    public static final foe LOG;
    private static final RateLogger RATE_LOGGER;
    public static final String GLOBAL_OUTSTANDING_LIMIT = "zookeeper.globalOutstandingLimit";
    public static final String ENABLE_EAGER_ACL_CHECK = "zookeeper.enableEagerACLCheck";
    public static final String SKIP_ACL = "zookeeper.skipACL";
    public static final String ENFORCE_QUOTA = "zookeeper.enforceQuota";
    static boolean enableEagerACLCheck;
    static final boolean skipACL;
    public static final boolean enforceQuota;
    public static final String SASL_SUPER_USER = "zookeeper.superUser";
    public static final String ALLOW_SASL_FAILED_CLIENTS = "zookeeper.allowSaslFailedClients";
    public static final String ZOOKEEPER_DIGEST_ENABLED = "zookeeper.digest.enabled";
    private static boolean digestEnabled;
    public static final String ZOOKEEPER_SERIALIZE_LAST_PROCESSED_ZXID_ENABLED = "zookeeper.serializeLastProcessedZxid.enabled";
    private static boolean serializeLastProcessedZxidEnabled;
    public static final String CLOSE_SESSION_TXN_ENABLED = "zookeeper.closeSessionTxn.enabled";
    private static boolean closeSessionTxnEnabled;
    private volatile CountDownLatch restoreLatch;
    public ZooKeeperServerBean jmxServerBean;
    public DataTreeBean jmxDataTreeBean;
    public static final int DEFAULT_TICK_TIME = 3000;
    public int tickTime = 3000;
    public static final int DEFAULT_THROTTLED_OP_WAIT_TIME = 0;
    protected static volatile int throttledOpWaitTime;
    protected int minSessionTimeout = -1;
    protected int maxSessionTimeout = -1;
    protected int listenBacklog = -1;
    public SessionTracker sessionTracker;
    private FileTxnSnapLog txnLogFactory = null;
    private ZKDatabase zkDb;
    private ResponseCache readResponseCache;
    private ResponseCache getChildrenResponseCache;
    private final AtomicLong hzxid = new AtomicLong(0L);
    public static final Exception ok;
    public RequestProcessor firstProcessor;
    protected JvmPauseMonitor jvmPauseMonitor;
    public volatile State state = State.INITIAL;
    private boolean isResponseCachingEnabled = true;
    protected String initialConfig;
    protected boolean reconfigEnabled;
    private final RequestPathMetricsCollector requestPathMetricsCollector;
    private static final int DEFAULT_SNAP_COUNT = 100000;
    private static final int DEFAULT_GLOBAL_OUTSTANDING_LIMIT = 1000;
    private boolean localSessionEnabled = false;
    private static final long superSecret = 3007405056L;
    private final AtomicInteger requestsInProcess = new AtomicInteger(0);
    final Deque<ChangeRecord> outstandingChanges = new ArrayDeque<ChangeRecord>();
    final Map<String, ChangeRecord> outstandingChangesForPath = new HashMap<String, ChangeRecord>();
    protected ServerCnxnFactory serverCnxnFactory;
    protected ServerCnxnFactory secureServerCnxnFactory;
    private final ServerStats serverStats;
    private final ZooKeeperServerListener listener;
    private ZooKeeperServerShutdownHandler zkShutdownHandler;
    private volatile int createSessionTrackerServerId = 1;
    private static final String FLUSH_DELAY = "zookeeper.flushDelay";
    private static volatile long flushDelay;
    private static final String MAX_WRITE_QUEUE_POLL_SIZE = "zookeeper.maxWriteQueuePollTime";
    private static volatile long maxWriteQueuePollTime;
    private static final String MAX_BATCH_SIZE = "zookeeper.maxBatchSize";
    private static volatile int maxBatchSize;
    public static final String INT_BUFFER_STARTING_SIZE_BYTES = "zookeeper.intBufferStartingSizeBytes";
    public static final int DEFAULT_STARTING_BUFFER_SIZE = 1024;
    public static final int intBufferStartingSizeBytes;
    public static final String GET_DATA_RESPONSE_CACHE_SIZE = "zookeeper.maxResponseCacheSize";
    public static final String GET_CHILDREN_RESPONSE_CACHE_SIZE = "zookeeper.maxGetChildrenResponseCacheSize";
    private final BlueThrottle connThrottle = new BlueThrottle();
    private RequestThrottler requestThrottler;
    public static final String SNAP_COUNT = "zookeeper.snapCount";
    private volatile int largeRequestMaxBytes = 0x6400000;
    private volatile int largeRequestThreshold = -1;
    private final AtomicInteger currentLargeRequestBytes = new AtomicInteger(0);
    private final AuthenticationHelper authHelper = new AuthenticationHelper();

    public static boolean isEnableEagerACLCheck() {
        return enableEagerACLCheck;
    }

    public static void setEnableEagerACLCheck(boolean bl2) {
        enableEagerACLCheck = bl2;
        LOG.c("Update {} to {}", (Object)ENABLE_EAGER_ACL_CHECK, (Object)bl2);
    }

    public static boolean isCloseSessionTxnEnabled() {
        return closeSessionTxnEnabled;
    }

    public static void setCloseSessionTxnEnabled(boolean bl2) {
        closeSessionTxnEnabled = bl2;
        LOG.c("Update {} to {}", (Object)CLOSE_SESSION_TXN_ENABLED, (Object)closeSessionTxnEnabled);
    }

    void removeCnxn(ServerCnxn serverCnxn) {
        this.zkDb.removeCnxn(serverCnxn);
    }

    public ZooKeeperServer() {
        this.listener = new ZooKeeperServerListenerImpl(this);
        this.serverStats = new ServerStats(this);
        this.requestPathMetricsCollector = new RequestPathMetricsCollector();
    }

    public ZooKeeperServer(FileTxnSnapLog fileTxnSnapLog, int n2, int n3, int n4, int n5, ZKDatabase zKDatabase, String string) {
        this(fileTxnSnapLog, n2, n3, n4, n5, zKDatabase, string, QuorumPeerConfig.isReconfigEnabled());
    }

    public ZooKeeperServer(FileTxnSnapLog fileTxnSnapLog, int n2, int n3, int n4, int n5, ZKDatabase zKDatabase, String string, boolean bl2) {
        this.serverStats = new ServerStats(this);
        this.txnLogFactory = fileTxnSnapLog;
        this.txnLogFactory.setServerStats(this.serverStats);
        this.zkDb = zKDatabase;
        this.tickTime = n2;
        this.setMinSessionTimeout(n3);
        this.setMaxSessionTimeout(n4);
        this.listenBacklog = n5;
        this.reconfigEnabled = bl2;
        this.listener = new ZooKeeperServerListenerImpl(this);
        this.readResponseCache = new ResponseCache(Integer.getInteger(GET_DATA_RESPONSE_CACHE_SIZE, 400), "getData");
        this.getChildrenResponseCache = new ResponseCache(Integer.getInteger(GET_CHILDREN_RESPONSE_CACHE_SIZE, 400), "getChildren");
        this.initialConfig = string;
        this.requestPathMetricsCollector = new RequestPathMetricsCollector();
        this.initLargeRequestThrottlingSettings();
        LOG.c("Created server with tickTime {} ms minSessionTimeout {} ms maxSessionTimeout {} ms clientPortListenBacklog {} dataLogdir {} snapdir {}", n2, this.getMinSessionTimeout(), this.getMaxSessionTimeout(), this.getClientPortListenBacklog(), fileTxnSnapLog.getDataLogDir(), fileTxnSnapLog.getSnapDir());
    }

    public String getInitialConfig() {
        return this.initialConfig;
    }

    public ZooKeeperServer(JvmPauseMonitor jvmPauseMonitor, FileTxnSnapLog fileTxnSnapLog, int n2, int n3, int n4, int n5, ZKDatabase zKDatabase, String string) {
        this(fileTxnSnapLog, n2, n3, n4, n5, zKDatabase, string, QuorumPeerConfig.isReconfigEnabled());
        this.jvmPauseMonitor = jvmPauseMonitor;
        if (jvmPauseMonitor != null) {
            LOG.c("Added JvmPauseMonitor to server");
        }
    }

    public ZooKeeperServer(FileTxnSnapLog fileTxnSnapLog, int n2, String string) {
        this(fileTxnSnapLog, n2, -1, -1, -1, new ZKDatabase(fileTxnSnapLog), string, QuorumPeerConfig.isReconfigEnabled());
    }

    public ServerStats serverStats() {
        return this.serverStats;
    }

    public RequestPathMetricsCollector getRequestPathMetricsCollector() {
        return this.requestPathMetricsCollector;
    }

    public BlueThrottle connThrottle() {
        return this.connThrottle;
    }

    public void dumpConf(PrintWriter printWriter) {
        printWriter.print("clientPort=");
        printWriter.println(this.getClientPort());
        printWriter.print("secureClientPort=");
        printWriter.println(this.getSecureClientPort());
        printWriter.print("dataDir=");
        printWriter.println(this.zkDb.snapLog.getSnapDir().getAbsolutePath());
        printWriter.print("dataDirSize=");
        printWriter.println(this.getDataDirSize());
        printWriter.print("dataLogDir=");
        printWriter.println(this.zkDb.snapLog.getDataLogDir().getAbsolutePath());
        printWriter.print("dataLogSize=");
        printWriter.println(this.getLogDirSize());
        printWriter.print("tickTime=");
        printWriter.println(this.getTickTime());
        printWriter.print("maxClientCnxns=");
        printWriter.println(this.getMaxClientCnxnsPerHost());
        printWriter.print("minSessionTimeout=");
        printWriter.println(this.getMinSessionTimeout());
        printWriter.print("maxSessionTimeout=");
        printWriter.println(this.getMaxSessionTimeout());
        printWriter.print("clientPortListenBacklog=");
        printWriter.println(this.getClientPortListenBacklog());
        printWriter.print("serverId=");
        printWriter.println(this.getServerId());
    }

    public ZooKeeperServerConf getConf() {
        return new ZooKeeperServerConf(this.getClientPort(), this.zkDb.snapLog.getSnapDir().getAbsolutePath(), this.zkDb.snapLog.getDataLogDir().getAbsolutePath(), this.getTickTime(), this.getMaxClientCnxnsPerHost(), this.getMinSessionTimeout(), this.getMaxSessionTimeout(), this.getServerId(), this.getClientPortListenBacklog());
    }

    public ZooKeeperServer(File file, File file2, int n2) throws IOException {
        this(new FileTxnSnapLog(file, file2), n2, "");
    }

    public ZooKeeperServer(FileTxnSnapLog fileTxnSnapLog) throws IOException {
        this(fileTxnSnapLog, 3000, -1, -1, -1, new ZKDatabase(fileTxnSnapLog), "", QuorumPeerConfig.isReconfigEnabled());
    }

    public ZKDatabase getZKDatabase() {
        return this.zkDb;
    }

    public void setZKDatabase(ZKDatabase zKDatabase) {
        this.zkDb = zKDatabase;
    }

    public void loadData() throws IOException, InterruptedException {
        if (this.zkDb.isInitialized()) {
            this.setZxid(this.zkDb.getDataTreeLastProcessedZxid());
        } else {
            this.setZxid(this.zkDb.loadDataBase());
        }
        this.zkDb.getSessions().stream().filter(l2 -> this.zkDb.getSessionWithTimeOuts().get(l2) == null).forEach(l2 -> this.killSession((long)l2, this.zkDb.getDataTreeLastProcessedZxid()));
        this.takeSnapshot();
    }

    public File takeSnapshot() throws IOException {
        return this.takeSnapshot(false);
    }

    public File takeSnapshot(boolean bl2) throws IOException {
        return this.takeSnapshot(bl2, true, false);
    }

    public synchronized File takeSnapshot(boolean bl2, boolean bl3, boolean bl4) throws IOException {
        long l2 = Time.currentElapsedTime();
        File file = null;
        try {
            if (bl4) {
                this.zkDb.fastForwardDataBase();
            }
            file = this.txnLogFactory.save(this.zkDb.getDataTree(), this.zkDb.getSessionWithTimeOuts(), bl2);
        }
        catch (IOException iOException) {
            if (bl3) {
                LOG.d("Severe unrecoverable error, exiting", iOException);
                ServiceUtils.requestSystemExit(ExitCode.TXNLOG_ERROR_TAKING_SNAPSHOT.getValue());
            }
            throw iOException;
        }
        long l3 = Time.currentElapsedTime() - l2;
        LOG.c("Snapshot taken in {} ms", (Object)l3);
        ServerMetrics.getMetrics().SNAPSHOT_TIME.add(l3);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long restoreFromSnapshot(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream can not be null when restoring from snapshot");
        }
        long l2 = Time.currentElapsedTime();
        LOG.c("Before restore database. lastProcessedZxid={}, nodeCount={}\uff0csessionCount={}", this.getZKDatabase().getDataTreeLastProcessedZxid(), this.getZKDatabase().dataTree.getNodeCount(), this.getZKDatabase().getSessionCount());
        ZKDatabase zKDatabase = new ZKDatabase(this.txnLogFactory);
        CheckedInputStream checkedInputStream = new CheckedInputStream(new BufferedInputStream(inputStream), new Adler32());
        hme hme2 = hme.a(checkedInputStream);
        zKDatabase.deserializeSnapshot(hme2, checkedInputStream);
        LOG.c("Restored to a new database. lastProcessedZxid={}, nodeCount={}, sessionCount={}", zKDatabase.getDataTreeLastProcessedZxid(), zKDatabase.dataTree.getNodeCount(), zKDatabase.getSessionCount());
        this.restoreLatch = new CountDownLatch(1);
        try {
            this.setZKDatabase(zKDatabase);
            this.createSessionTracker();
        }
        finally {
            this.restoreLatch.countDown();
            this.restoreLatch = null;
        }
        LOG.c("After restore database. lastProcessedZxid={}, nodeCount={}, sessionCount={}", this.getZKDatabase().getDataTreeLastProcessedZxid(), this.getZKDatabase().dataTree.getNodeCount(), this.getZKDatabase().getSessionCount());
        long l3 = Time.currentElapsedTime() - l2;
        LOG.c("Restore taken in {} ms", (Object)l3);
        ServerMetrics.getMetrics().RESTORE_TIME.add(l3);
        return this.getLastProcessedZxid();
    }

    public boolean shouldForceWriteInitialSnapshotAfterLeaderElection() {
        return this.txnLogFactory.shouldForceWriteInitialSnapshotAfterLeaderElection();
    }

    @Override
    public long getDataDirSize() {
        if (this.zkDb == null) {
            return 0L;
        }
        File file = this.zkDb.snapLog.getSnapDir();
        return this.getDirSize(file);
    }

    @Override
    public long getLogDirSize() {
        if (this.zkDb == null) {
            return 0L;
        }
        File file = this.zkDb.snapLog.getDataLogDir();
        return this.getDirSize(file);
    }

    private long getDirSize(File file) {
        long l2 = 0L;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    l2 += this.getDirSize(file2);
                }
            }
        } else {
            l2 = file.length();
        }
        return l2;
    }

    public long getZxid() {
        return this.hzxid.get();
    }

    public SessionTracker getSessionTracker() {
        return this.sessionTracker;
    }

    long getNextZxid() {
        return this.hzxid.incrementAndGet();
    }

    public void setZxid(long l2) {
        this.hzxid.set(l2);
    }

    private void close(long l2) {
        Request request = new Request(null, l2, 0, -11, null, null);
        this.submitRequest(request);
    }

    public void closeSession(long l2) {
        LOG.c("Closing session 0x{}", (Object)Long.toHexString(l2));
        this.close(l2);
    }

    protected void killSession(long l2, long l3) {
        this.zkDb.killSession(l2, l3);
        if (LOG.b()) {
            ZooTrace.logTraceMessage(LOG, 32L, "ZooKeeperServer --- killSession: 0x" + Long.toHexString(l2));
        }
        if (this.sessionTracker != null) {
            this.sessionTracker.removeSession(l2);
        }
    }

    @Override
    public void expire(SessionTracker.Session session) {
        long l2 = session.getSessionId();
        LOG.c("Expiring session 0x{}, timeout of {}ms exceeded", (Object)Long.toHexString(l2), (Object)session.getTimeout());
        this.close(l2);
    }

    public void expire(long l2) {
        LOG.c("forcibly expiring session 0x{}", (Object)Long.toHexString(l2));
        this.close(l2);
    }

    void touch(ServerCnxn serverCnxn) throws MissingSessionException {
        int n2;
        if (serverCnxn == null) {
            return;
        }
        long l2 = serverCnxn.getSessionId();
        if (!this.sessionTracker.touchSession(l2, n2 = serverCnxn.getSessionTimeout())) {
            throw new MissingSessionException("No session with sessionid 0x" + Long.toHexString(l2) + " exists, probably expired and removed");
        }
    }

    public void registerJMX() {
        try {
            this.jmxServerBean = new ZooKeeperServerBean(this);
            MBeanRegistry.getInstance().register(this.jmxServerBean, null);
            try {
                this.jmxDataTreeBean = new DataTreeBean(this.zkDb.getDataTree());
                MBeanRegistry.getInstance().register(this.jmxDataTreeBean, this.jmxServerBean);
            }
            catch (Exception exception) {
                LOG.c("Failed to register with JMX", exception);
                this.jmxDataTreeBean = null;
            }
        }
        catch (Exception exception) {
            LOG.c("Failed to register with JMX", exception);
            this.jmxServerBean = null;
        }
    }

    public void startdata() throws IOException, InterruptedException {
        if (this.zkDb == null) {
            this.zkDb = new ZKDatabase(this.txnLogFactory);
        }
        if (!this.zkDb.isInitialized()) {
            this.loadData();
        }
    }

    public synchronized void startup() {
        this.startupWithServerState(State.RUNNING);
    }

    public synchronized void startupWithoutServing() {
        this.startupWithServerState(State.INITIAL);
    }

    public synchronized void startServing() {
        this.setState(State.RUNNING);
        this.notifyAll();
    }

    private void startupWithServerState(State state) {
        if (this.sessionTracker == null) {
            this.createSessionTracker();
        }
        this.startSessionTracker();
        this.setupRequestProcessors();
        this.startRequestThrottler();
        this.registerJMX();
        this.startJvmPauseMonitor();
        this.registerMetrics();
        this.setState(state);
        this.requestPathMetricsCollector.start();
        this.localSessionEnabled = this.sessionTracker.isLocalSessionsEnabled();
        this.notifyAll();
    }

    protected void startJvmPauseMonitor() {
        if (this.jvmPauseMonitor != null) {
            this.jvmPauseMonitor.serviceStart();
        }
    }

    protected void startRequestThrottler() {
        this.requestThrottler = this.createRequestThrottler();
        this.requestThrottler.start();
    }

    protected RequestThrottler createRequestThrottler() {
        return new RequestThrottler(this);
    }

    public void setupRequestProcessors() {
        FinalRequestProcessor finalRequestProcessor = new FinalRequestProcessor(this);
        SyncRequestProcessor syncRequestProcessor = new SyncRequestProcessor(this, finalRequestProcessor);
        syncRequestProcessor.start();
        this.firstProcessor = new PrepRequestProcessor(this, syncRequestProcessor);
        ((PrepRequestProcessor)this.firstProcessor).start();
    }

    public ZooKeeperServerListener getZooKeeperServerListener() {
        return this.listener;
    }

    public void setCreateSessionTrackerServerId(int n2) {
        this.createSessionTrackerServerId = n2;
    }

    public void createSessionTracker() {
        this.sessionTracker = new SessionTrackerImpl(this, this.zkDb.getSessionWithTimeOuts(), this.tickTime, (long)this.createSessionTrackerServerId, this.getZooKeeperServerListener());
    }

    public void startSessionTracker() {
        ((SessionTrackerImpl)this.sessionTracker).start();
    }

    public void setState(State state) {
        this.state = state;
        if (this.zkShutdownHandler != null) {
            this.zkShutdownHandler.handle(state);
        } else {
            LOG.b("ZKShutdownHandler is not registered, so ZooKeeper server won't take any action on ERROR or SHUTDOWN server state changes");
        }
    }

    public boolean canShutdown() {
        return this.state == State.RUNNING || this.state == State.ERROR;
    }

    public boolean isRunning() {
        return this.state == State.RUNNING;
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public synchronized void shutdown(boolean bl2) {
        if (!this.canShutdown()) {
            if (bl2 && this.zkDb != null) {
                this.zkDb.clear();
            }
            LOG.b("ZooKeeper server is not running, so not proceeding to shutdown!");
            return;
        }
        LOG.c("shutting down");
        this.setState(State.SHUTDOWN);
        this.unregisterMetrics();
        if (this.requestThrottler != null) {
            this.requestThrottler.shutdown();
        }
        if (this.sessionTracker != null) {
            this.sessionTracker.shutdown();
        }
        if (this.firstProcessor != null) {
            this.firstProcessor.shutdown();
        }
        if (this.jvmPauseMonitor != null) {
            this.jvmPauseMonitor.serviceStop();
        }
        if (this.zkDb != null) {
            if (bl2) {
                this.zkDb.clear();
            } else {
                try {
                    this.zkDb.fastForwardDataBase();
                }
                catch (IOException iOException) {
                    LOG.d("Error updating DB", iOException);
                    this.zkDb.clear();
                }
            }
        }
        this.requestPathMetricsCollector.shutdown();
        this.unregisterJMX();
    }

    public void unregisterJMX() {
        try {
            if (this.jmxDataTreeBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxDataTreeBean);
            }
        }
        catch (Exception exception) {
            LOG.c("Failed to unregister with JMX", exception);
        }
        try {
            if (this.jmxServerBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxServerBean);
            }
        }
        catch (Exception exception) {
            LOG.c("Failed to unregister with JMX", exception);
        }
        this.jmxServerBean = null;
        this.jmxDataTreeBean = null;
    }

    public void incInProcess() {
        this.requestsInProcess.incrementAndGet();
    }

    public void decInProcess() {
        this.requestsInProcess.decrementAndGet();
        if (this.requestThrottler != null) {
            this.requestThrottler.throttleWake();
        }
    }

    public int getInProcess() {
        return this.requestsInProcess.get();
    }

    public int getInflight() {
        return this.requestThrottleInflight();
    }

    private int requestThrottleInflight() {
        if (this.requestThrottler != null) {
            return this.requestThrottler.getInflight();
        }
        return 0;
    }

    byte[] generatePasswd(long l2) {
        Random random = new Random(l2 ^ 0xB3415C00L);
        byte[] byArray = new byte[16];
        random.nextBytes(byArray);
        return byArray;
    }

    protected boolean checkPasswd(long l2, byte[] byArray) {
        return l2 != 0L && Arrays.equals(byArray, this.generatePasswd(l2));
    }

    long createSession(ServerCnxn serverCnxn, byte[] byArray, int n2) {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        long l2 = this.sessionTracker.createSession(n2);
        Random random = new Random(l2 ^ 0xB3415C00L);
        random.nextBytes(byArray);
        CreateSessionTxn createSessionTxn = new CreateSessionTxn(n2);
        serverCnxn.setSessionId(l2);
        Request request = new Request(serverCnxn, l2, 0, -10, RequestRecord.fromRecord(createSessionTxn), null);
        this.submitRequest(request);
        return l2;
    }

    public void setOwner(long l2, Object object) throws KeeperException.SessionExpiredException {
        this.sessionTracker.setOwner(l2, object);
    }

    public void revalidateSession(ServerCnxn serverCnxn, long l2, int n2) throws IOException {
        boolean bl2 = this.sessionTracker.touchSession(l2, n2);
        if (LOG.b()) {
            ZooTrace.logTraceMessage(LOG, 32L, "Session 0x" + Long.toHexString(l2) + " is valid: " + bl2);
        }
        this.finishSessionInit(serverCnxn, bl2);
    }

    public void reopenSession(ServerCnxn serverCnxn, long l2, byte[] byArray, int n2) throws IOException {
        if (this.checkPasswd(l2, byArray)) {
            this.revalidateSession(serverCnxn, l2, n2);
        } else {
            LOG.d("Incorrect password from {} for session 0x{}", (Object)serverCnxn.getRemoteSocketAddress(), (Object)Long.toHexString(l2));
            this.finishSessionInit(serverCnxn, false);
        }
    }

    public void finishSessionInit(ServerCnxn serverCnxn, boolean bl2) {
        try {
            if (bl2) {
                if (this.serverCnxnFactory != null && this.serverCnxnFactory.cnxns.contains(serverCnxn)) {
                    this.serverCnxnFactory.registerConnection(serverCnxn);
                } else if (this.secureServerCnxnFactory != null && this.secureServerCnxnFactory.cnxns.contains(serverCnxn)) {
                    this.secureServerCnxnFactory.registerConnection(serverCnxn);
                }
            }
        }
        catch (Exception exception) {
            LOG.c("Failed to register with JMX", exception);
        }
        try {
            ConnectResponse connectResponse = new ConnectResponse(0, bl2 ? serverCnxn.getSessionTimeout() : 0, bl2 ? serverCnxn.getSessionId() : 0L, bl2 ? this.generatePasswd(serverCnxn.getSessionId()) : new byte[16], this instanceof ReadOnlyZooKeeperServer);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ime ime2 = ime.a(byteArrayOutputStream);
            ime2.a(-1, "len");
            connectResponse.serialize(ime2, "connect");
            byteArrayOutputStream.close();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
            byteBuffer.putInt(byteBuffer.remaining() - 4).rewind();
            serverCnxn.sendBuffer(byteBuffer);
            if (bl2) {
                LOG.b("Established session 0x{} with negotiated timeout {} for client {}", Long.toHexString(serverCnxn.getSessionId()), serverCnxn.getSessionTimeout(), serverCnxn.getRemoteSocketAddress());
                serverCnxn.enableRecv();
            } else {
                LOG.c("Invalid session 0x{} for client {}, probably expired", (Object)Long.toHexString(serverCnxn.getSessionId()), (Object)serverCnxn.getRemoteSocketAddress());
                serverCnxn.sendBuffer(ServerCnxnFactory.closeConn);
            }
        }
        catch (Exception exception) {
            LOG.c("Exception while establishing session, closing", exception);
            serverCnxn.close(ServerCnxn.DisconnectReason.IO_EXCEPTION_IN_SESSION_INIT);
        }
    }

    public void closeSession(ServerCnxn serverCnxn, RequestHeader requestHeader) {
        this.closeSession(serverCnxn.getSessionId());
    }

    @Override
    public long getServerId() {
        return 0L;
    }

    public void setLocalSessionFlag(Request request) {
    }

    public void submitRequest(Request request) {
        if (this.restoreLatch != null) {
            try {
                LOG.c("Blocking request submission while restore is in progress");
                this.restoreLatch.await();
            }
            catch (InterruptedException interruptedException) {
                LOG.c("Unexpected interruption", interruptedException);
            }
        }
        this.enqueueRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueRequest(Request request) {
        if (this.requestThrottler == null) {
            ZooKeeperServer zooKeeperServer = this;
            synchronized (zooKeeperServer) {
                try {
                    while (this.state == State.INITIAL) {
                        this.wait(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    LOG.c("Unexpected interruption", interruptedException);
                }
                if (this.requestThrottler == null) {
                    throw new RuntimeException("Not started");
                }
            }
        }
        this.requestThrottler.submitRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitRequestNow(Request request) {
        if (this.firstProcessor == null) {
            ZooKeeperServer zooKeeperServer = this;
            synchronized (zooKeeperServer) {
                try {
                    while (this.state == State.INITIAL) {
                        this.wait(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    LOG.c("Unexpected interruption", interruptedException);
                }
                if (this.firstProcessor == null || this.state != State.RUNNING) {
                    throw new RuntimeException("Not started");
                }
            }
        }
        try {
            this.touch(request.cnxn);
            boolean bl2 = Request.isValid(request.type);
            if (bl2) {
                this.setLocalSessionFlag(request);
                this.firstProcessor.processRequest(request);
                if (request.cnxn != null) {
                    this.incInProcess();
                }
            } else {
                LOG.d("Received packet at server of unknown type {}", (Object)request.type);
                this.requestFinished(request);
                new UnimplementedRequestProcessor().processRequest(request);
            }
        }
        catch (MissingSessionException missingSessionException) {
            LOG.a("Dropping request.", missingSessionException);
            this.requestFinished(request);
        }
        catch (RequestProcessor.RequestProcessorException requestProcessorException) {
            LOG.d("Unable to process request", requestProcessorException);
            this.requestFinished(request);
        }
    }

    public static int getSnapCount() {
        int n2 = Integer.getInteger(SNAP_COUNT, 100000);
        if (n2 < 2) {
            LOG.d("SnapCount should be 2 or more. Now, snapCount is reset to 2");
            n2 = 2;
        }
        return n2;
    }

    public int getGlobalOutstandingLimit() {
        return Integer.getInteger(GLOBAL_OUTSTANDING_LIMIT, 1000);
    }

    public static long getSnapSizeInBytes() {
        long l2 = Long.getLong("zookeeper.snapSizeLimitInKb", 0x400000L);
        if (l2 <= 0L) {
            LOG.c("zookeeper.snapSizeLimitInKb set to a non-positive value {}; disabling feature", (Object)l2);
        }
        return l2 * 1024L;
    }

    public void setServerCnxnFactory(ServerCnxnFactory serverCnxnFactory) {
        this.serverCnxnFactory = serverCnxnFactory;
    }

    public ServerCnxnFactory getServerCnxnFactory() {
        return this.serverCnxnFactory;
    }

    public ServerCnxnFactory getSecureServerCnxnFactory() {
        return this.secureServerCnxnFactory;
    }

    public void setSecureServerCnxnFactory(ServerCnxnFactory serverCnxnFactory) {
        this.secureServerCnxnFactory = serverCnxnFactory;
    }

    @Override
    public long getLastProcessedZxid() {
        return this.zkDb.getDataTreeLastProcessedZxid();
    }

    @Override
    public long getOutstandingRequests() {
        return this.getInProcess();
    }

    @Override
    public int getNumAliveConnections() {
        int n2 = 0;
        if (this.serverCnxnFactory != null) {
            n2 += this.serverCnxnFactory.getNumAliveConnections();
        }
        if (this.secureServerCnxnFactory != null) {
            n2 += this.secureServerCnxnFactory.getNumAliveConnections();
        }
        return n2;
    }

    public void truncateLog(long l2) throws IOException {
        this.zkDb.truncateLog(l2);
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public void setTickTime(int n2) {
        LOG.c("tickTime set to {} ms", (Object)n2);
        this.tickTime = n2;
    }

    public static int getThrottledOpWaitTime() {
        return throttledOpWaitTime;
    }

    public static void setThrottledOpWaitTime(int n2) {
        LOG.c("throttledOpWaitTime set to {} ms", (Object)n2);
        throttledOpWaitTime = n2;
    }

    public int getMinSessionTimeout() {
        return this.minSessionTimeout;
    }

    public void setMinSessionTimeout(int n2) {
        this.minSessionTimeout = n2 == -1 ? this.tickTime * 2 : n2;
        LOG.c("minSessionTimeout set to {} ms", (Object)this.minSessionTimeout);
    }

    public int getMaxSessionTimeout() {
        return this.maxSessionTimeout;
    }

    public void setMaxSessionTimeout(int n2) {
        this.maxSessionTimeout = n2 == -1 ? this.tickTime * 20 : n2;
        LOG.c("maxSessionTimeout set to {} ms", (Object)this.maxSessionTimeout);
    }

    public int getClientPortListenBacklog() {
        return this.listenBacklog;
    }

    public void setClientPortListenBacklog(int n2) {
        this.listenBacklog = n2;
        LOG.c("clientPortListenBacklog set to {}", (Object)n2);
    }

    public int getClientPort() {
        return this.serverCnxnFactory != null ? this.serverCnxnFactory.getLocalPort() : -1;
    }

    public int getSecureClientPort() {
        return this.secureServerCnxnFactory != null ? this.secureServerCnxnFactory.getLocalPort() : -1;
    }

    public int getMaxClientCnxnsPerHost() {
        if (this.serverCnxnFactory != null) {
            return this.serverCnxnFactory.getMaxClientCnxnsPerHost();
        }
        if (this.secureServerCnxnFactory != null) {
            return this.secureServerCnxnFactory.getMaxClientCnxnsPerHost();
        }
        return -1;
    }

    public void setTxnLogFactory(FileTxnSnapLog fileTxnSnapLog) {
        this.txnLogFactory = fileTxnSnapLog;
    }

    public FileTxnSnapLog getTxnLogFactory() {
        return this.txnLogFactory;
    }

    public long getTxnLogElapsedSyncTime() {
        return this.txnLogFactory.getTxnLogElapsedSyncTime();
    }

    @Override
    public String getState() {
        return "standalone";
    }

    public void dumpEphemerals(PrintWriter printWriter) {
        this.zkDb.dumpEphemerals(printWriter);
    }

    public Map<Long, Set<String>> getEphemerals() {
        return this.zkDb.getEphemerals();
    }

    public double getConnectionDropChance() {
        return this.connThrottle.getDropChance();
    }

    public void processConnectRequest(ServerCnxn serverCnxn, ConnectRequest connectRequest) throws IOException, ClientCnxnLimitException {
        int n2;
        LOG.b("Session establishment request from client {} client's lastZxid is 0x{}", (Object)serverCnxn.getRemoteSocketAddress(), (Object)Long.toHexString(connectRequest.getLastZxidSeen()));
        long l2 = connectRequest.getSessionId();
        int n3 = 1;
        if (this.connThrottle.isConnectionWeightEnabled()) {
            n3 = l2 == 0L ? (this.localSessionEnabled ? this.connThrottle.getRequiredTokensForLocal() : this.connThrottle.getRequiredTokensForGlobal()) : this.connThrottle.getRequiredTokensForRenew();
        }
        if (!this.connThrottle.checkLimit(n3)) {
            throw new ClientCnxnLimitException();
        }
        ServerMetrics.getMetrics().CONNECTION_TOKEN_DEFICIT.add(this.connThrottle.getDeficit());
        ServerMetrics.getMetrics().CONNECTION_REQUEST_COUNT.add(1L);
        if (!serverCnxn.protocolManager.isReadonlyAvailable()) {
            LOG.d("Connection request from old client {}; will be dropped if server is in r-o mode", (Object)serverCnxn.getRemoteSocketAddress());
        }
        if (!connectRequest.getReadOnly() && this instanceof ReadOnlyZooKeeperServer) {
            String string = "Refusing session request for not-read-only client " + serverCnxn.getRemoteSocketAddress();
            LOG.c(string);
            throw new ServerCnxn.CloseRequestException(string, ServerCnxn.DisconnectReason.NOT_READ_ONLY_CLIENT);
        }
        if (connectRequest.getLastZxidSeen() > this.zkDb.dataTree.lastProcessedZxid) {
            String string = "Refusing session(0x" + Long.toHexString(l2) + ") request for client " + serverCnxn.getRemoteSocketAddress() + " as it has seen zxid 0x" + Long.toHexString(connectRequest.getLastZxidSeen()) + " our last zxid is 0x" + Long.toHexString(this.getZKDatabase().getDataTreeLastProcessedZxid()) + " client must try another server";
            LOG.c(string);
            throw new ServerCnxn.CloseRequestException(string, ServerCnxn.DisconnectReason.CLIENT_ZXID_AHEAD);
        }
        int n4 = connectRequest.getTimeOut();
        byte[] byArray = connectRequest.getPasswd();
        int n5 = this.getMinSessionTimeout();
        if (n4 < n5) {
            n4 = n5;
        }
        if (n4 > (n2 = this.getMaxSessionTimeout())) {
            n4 = n2;
        }
        serverCnxn.setSessionTimeout(n4);
        serverCnxn.disableRecv();
        if (l2 == 0L) {
            long l3 = this.createSession(serverCnxn, byArray, n4);
            LOG.b("Client attempting to establish new session: session = 0x{}, zxid = 0x{}, timeout = {}, address = {}", Long.toHexString(l3), Long.toHexString(connectRequest.getLastZxidSeen()), connectRequest.getTimeOut(), serverCnxn.getRemoteSocketAddress());
        } else {
            this.validateSession(serverCnxn, l2);
            LOG.b("Client attempting to renew session: session = 0x{}, zxid = 0x{}, timeout = {}, address = {}", Long.toHexString(l2), Long.toHexString(connectRequest.getLastZxidSeen()), connectRequest.getTimeOut(), serverCnxn.getRemoteSocketAddress());
            if (this.serverCnxnFactory != null) {
                this.serverCnxnFactory.closeSession(l2, ServerCnxn.DisconnectReason.CLIENT_RECONNECT);
            }
            if (this.secureServerCnxnFactory != null) {
                this.secureServerCnxnFactory.closeSession(l2, ServerCnxn.DisconnectReason.CLIENT_RECONNECT);
            }
            serverCnxn.setSessionId(l2);
            this.reopenSession(serverCnxn, l2, byArray, n4);
            ServerMetrics.getMetrics().CONNECTION_REVALIDATE_COUNT.add(1L);
        }
    }

    public void validateSession(ServerCnxn serverCnxn, long l2) throws IOException {
    }

    public boolean shouldThrottle(long l2) {
        int n2 = this.getGlobalOutstandingLimit();
        if (n2 < this.getInflight() || n2 < this.getInProcess()) {
            return l2 > 0L;
        }
        return false;
    }

    long getFlushDelay() {
        return flushDelay;
    }

    static void setFlushDelay(long l2) {
        LOG.c("{} = {} ms", (Object)FLUSH_DELAY, (Object)l2);
        flushDelay = l2;
    }

    long getMaxWriteQueuePollTime() {
        return maxWriteQueuePollTime;
    }

    static void setMaxWriteQueuePollTime(long l2) {
        LOG.c("{} = {} ms", (Object)MAX_WRITE_QUEUE_POLL_SIZE, (Object)l2);
        maxWriteQueuePollTime = l2;
    }

    int getMaxBatchSize() {
        return maxBatchSize;
    }

    static void setMaxBatchSize(int n2) {
        LOG.c("{}={}", (Object)MAX_BATCH_SIZE, (Object)n2);
        maxBatchSize = n2;
    }

    private void initLargeRequestThrottlingSettings() {
        this.setLargeRequestMaxBytes(Integer.getInteger("zookeeper.largeRequestMaxBytes", this.largeRequestMaxBytes));
        this.setLargeRequestThreshold(Integer.getInteger("zookeeper.largeRequestThreshold", -1));
    }

    public int getLargeRequestMaxBytes() {
        return this.largeRequestMaxBytes;
    }

    public void setLargeRequestMaxBytes(int n2) {
        if (n2 <= 0) {
            LOG.d("Invalid max bytes for all large requests {}. It should be a positive number.", (Object)n2);
            LOG.d("Will not change the setting. The max bytes stay at {}", (Object)this.largeRequestMaxBytes);
        } else {
            this.largeRequestMaxBytes = n2;
            LOG.c("The max bytes for all large requests are set to {}", (Object)this.largeRequestMaxBytes);
        }
    }

    public int getLargeRequestThreshold() {
        return this.largeRequestThreshold;
    }

    public void setLargeRequestThreshold(int n2) {
        if (n2 == 0 || n2 < -1) {
            LOG.d("Invalid large request threshold {}. It should be -1 or positive. Setting to -1 ", (Object)n2);
            this.largeRequestThreshold = -1;
        } else {
            this.largeRequestThreshold = n2;
            LOG.c("The large request threshold is set to {}", (Object)this.largeRequestThreshold);
        }
    }

    public int getLargeRequestBytes() {
        return this.currentLargeRequestBytes.get();
    }

    private boolean isLargeRequest(int n2) {
        if (this.largeRequestThreshold == -1) {
            return false;
        }
        return n2 > this.largeRequestThreshold;
    }

    public boolean checkRequestSizeWhenReceivingMessage(int n2) throws IOException {
        if (!this.isLargeRequest(n2)) {
            return true;
        }
        if (this.currentLargeRequestBytes.get() + n2 <= this.largeRequestMaxBytes) {
            return true;
        }
        ServerMetrics.getMetrics().LARGE_REQUESTS_REJECTED.add(1L);
        throw new IOException("Rejecting large request");
    }

    private boolean checkRequestSizeWhenMessageReceived(int n2) throws IOException {
        if (!this.isLargeRequest(n2)) {
            return true;
        }
        int n3 = this.currentLargeRequestBytes.addAndGet(n2);
        if (n3 > this.largeRequestMaxBytes) {
            this.currentLargeRequestBytes.addAndGet(-n2);
            ServerMetrics.getMetrics().LARGE_REQUESTS_REJECTED.add(1L);
            throw new IOException("Rejecting large request");
        }
        return true;
    }

    public void requestFinished(Request request) {
        int n2 = request.getLargeRequestSize();
        if (n2 != -1) {
            this.currentLargeRequestBytes.addAndGet(-n2);
        }
    }

    public void processPacket(ServerCnxn serverCnxn, RequestHeader requestHeader, RequestRecord requestRecord) throws IOException {
        serverCnxn.incrOutstandingAndCheckThrottle(requestHeader);
        if (requestHeader.getType() == 100) {
            LOG.c("got auth packet {}", (Object)serverCnxn.getRemoteSocketAddress());
            AuthPacket authPacket = requestRecord.readRecord(AuthPacket::new);
            String string = authPacket.getScheme();
            ServerAuthenticationProvider serverAuthenticationProvider = ProviderRegistry.getServerProvider(string);
            KeeperException.Code code = KeeperException.Code.AUTHFAILED;
            if (serverAuthenticationProvider != null) {
                try {
                    code = serverAuthenticationProvider.handleAuthentication(new ServerAuthenticationProvider.ServerObjs(this, serverCnxn), authPacket.getAuth());
                }
                catch (RuntimeException runtimeException) {
                    LOG.d("Caught runtime exception from AuthenticationProvider: {}", (Object)string, (Object)runtimeException);
                    code = KeeperException.Code.AUTHFAILED;
                }
            }
            if (code == KeeperException.Code.OK) {
                LOG.c("Session 0x{}: auth success for scheme {} and address {}", Long.toHexString(serverCnxn.getSessionId()), string, serverCnxn.getRemoteSocketAddress());
                ReplyHeader replyHeader = new ReplyHeader(requestHeader.getXid(), 0L, KeeperException.Code.OK.intValue());
                serverCnxn.sendResponse(replyHeader, null, null);
            } else {
                if (serverAuthenticationProvider == null) {
                    LOG.d("No authentication provider for scheme: {} has {}", (Object)string, (Object)ProviderRegistry.listProviders());
                } else {
                    LOG.d("Authentication failed for scheme: {}", (Object)string);
                }
                ReplyHeader replyHeader = new ReplyHeader(requestHeader.getXid(), 0L, KeeperException.Code.AUTHFAILED.intValue());
                serverCnxn.sendResponse(replyHeader, null, null);
                serverCnxn.sendBuffer(ServerCnxnFactory.closeConn);
                serverCnxn.disableRecv();
            }
            return;
        }
        if (requestHeader.getType() == 102) {
            this.processSasl(requestRecord, serverCnxn, requestHeader);
        } else {
            if (!this.authHelper.enforceAuthentication(serverCnxn, requestHeader.getXid())) {
                return;
            }
            Request request = new Request(serverCnxn, serverCnxn.getSessionId(), requestHeader.getXid(), requestHeader.getType(), requestRecord, serverCnxn.getAuthInfo());
            int n2 = requestRecord.limit();
            if (this.isLargeRequest(n2)) {
                this.checkRequestSizeWhenMessageReceived(n2);
                request.setLargeRequestSize(n2);
            }
            request.setOwner(ServerCnxn.me);
            this.submitRequest(request);
        }
    }

    private static boolean isSaslSuperUser(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        Properties properties = System.getProperties();
        int n2 = SASL_SUPER_USER.length();
        for (String string2 : properties.stringPropertyNames()) {
            String string3;
            if (!string2.startsWith(SASL_SUPER_USER) || string2.length() != n2 && string2.charAt(n2) != '.' || (string3 = properties.getProperty(string2)) == null || !string3.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldAllowSaslFailedClientsConnect() {
        return Boolean.getBoolean(ALLOW_SASL_FAILED_CLIENTS);
    }

    private void processSasl(RequestRecord requestRecord, ServerCnxn serverCnxn, RequestHeader requestHeader) throws IOException {
        Object object;
        Object object2;
        byte[] byArray;
        block10: {
            LOG.b("Responding to client SASL token.");
            GetSASLRequest getSASLRequest = requestRecord.readRecord(GetSASLRequest::new);
            byte[] byArray2 = getSASLRequest.getToken();
            LOG.b("Size of client SASL token: {}", (Object)byArray2.length);
            byArray = null;
            try {
                object2 = serverCnxn.zooKeeperSaslServer;
                try {
                    byArray = ((ZooKeeperSaslServer)object2).evaluateResponse(byArray2);
                    if (((ZooKeeperSaslServer)object2).isComplete()) {
                        object = ((ZooKeeperSaslServer)object2).getAuthorizationID();
                        LOG.c("Session 0x{}: adding SASL authorization for authorizationID: {}", (Object)Long.toHexString(serverCnxn.getSessionId()), object);
                        serverCnxn.addAuthInfo(new Id("sasl", (String)object));
                        if (ZooKeeperServer.isSaslSuperUser((String)object)) {
                            serverCnxn.addAuthInfo(new Id("super", ""));
                            LOG.c("Session 0x{}: Authenticated Id '{}' as super user", (Object)Long.toHexString(serverCnxn.getSessionId()), object);
                        }
                    }
                }
                catch (SaslException saslException) {
                    int n2;
                    LOG.d("Client {} failed to SASL authenticate: {}", (Object)serverCnxn.getRemoteSocketAddress(), (Object)saslException);
                    if (ZooKeeperServer.shouldAllowSaslFailedClientsConnect() && !this.authHelper.isSaslAuthRequired()) {
                        LOG.d("Maintaining client connection despite SASL authentication failure.");
                        break block10;
                    }
                    if (this.authHelper.isSaslAuthRequired()) {
                        LOG.d("Closing client connection due to server requires client SASL authenticaiton,but client SASL authentication has failed, or client is not configured with SASL authentication.");
                        n2 = KeeperException.Code.SESSIONCLOSEDREQUIRESASLAUTH.intValue();
                    } else {
                        LOG.d("Closing client connection due to SASL authentication failure.");
                        n2 = KeeperException.Code.AUTHFAILED.intValue();
                    }
                    ReplyHeader replyHeader = new ReplyHeader(requestHeader.getXid(), 0L, n2);
                    serverCnxn.sendResponse(replyHeader, new SetSASLResponse(null), "response");
                    serverCnxn.sendCloseSession();
                    serverCnxn.disableRecv();
                    return;
                }
            }
            catch (NullPointerException nullPointerException) {
                LOG.e("cnxn.saslServer is null: cnxn object did not initialize its saslServer properly.");
            }
        }
        if (byArray != null) {
            LOG.b("Size of server SASL response: {}", (Object)byArray.length);
        }
        object2 = new ReplyHeader(requestHeader.getXid(), 0L, KeeperException.Code.OK.intValue());
        object = new SetSASLResponse(byArray);
        serverCnxn.sendResponse((ReplyHeader)object2, (mme)object, "response");
    }

    public DataTree.ProcessTxnResult processTxn(TxnHeader txnHeader, mme mme2) {
        this.processTxnForSessionEvents(null, txnHeader, mme2);
        return this.processTxnInDB(txnHeader, mme2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataTree.ProcessTxnResult processTxn(Request request) {
        TxnHeader txnHeader = request.getHdr();
        this.processTxnForSessionEvents(request, txnHeader, request.getTxn());
        boolean bl2 = txnHeader != null;
        boolean bl3 = request.isQuorum();
        if (!bl2 && !bl3) {
            return new DataTree.ProcessTxnResult();
        }
        Deque<ChangeRecord> deque = this.outstandingChanges;
        synchronized (deque) {
            DataTree.ProcessTxnResult processTxnResult = this.processTxnInDB(txnHeader, request.getTxn(), request.getTxnDigest());
            if (bl2) {
                long l2 = txnHeader.getZxid();
                while (!this.outstandingChanges.isEmpty() && this.outstandingChanges.peek().zxid <= l2) {
                    ChangeRecord changeRecord = this.outstandingChanges.remove();
                    ServerMetrics.getMetrics().OUTSTANDING_CHANGES_REMOVED.add(1L);
                    if (changeRecord.zxid < l2) {
                        LOG.d("Zxid outstanding 0x{} is less than current 0x{}", (Object)Long.toHexString(changeRecord.zxid), (Object)Long.toHexString(l2));
                    }
                    if (this.outstandingChangesForPath.get(changeRecord.path) != changeRecord) continue;
                    this.outstandingChangesForPath.remove(changeRecord.path);
                }
            }
            if (bl3) {
                this.getZKDatabase().addCommittedProposal(request);
            }
            return processTxnResult;
        }
    }

    private void processTxnForSessionEvents(Request request, TxnHeader txnHeader, mme mme2) {
        long l2;
        int n2 = request == null ? txnHeader.getType() : request.type;
        long l3 = l2 = request == null ? txnHeader.getClientId() : request.sessionId;
        if (n2 == -10) {
            if (txnHeader != null && mme2 instanceof CreateSessionTxn) {
                CreateSessionTxn createSessionTxn = (CreateSessionTxn)mme2;
                this.sessionTracker.commitSession(l2, createSessionTxn.getTimeOut());
            } else if (request == null || !request.isLocalSession()) {
                LOG.d("*****>>>>> Got {} {}", (Object)mme2.getClass(), (Object)mme2.toString());
            }
        } else if (n2 == -11) {
            this.sessionTracker.removeSession(l2);
        }
    }

    private DataTree.ProcessTxnResult processTxnInDB(TxnHeader txnHeader, mme mme2, TxnDigest txnDigest) {
        if (txnHeader == null) {
            return new DataTree.ProcessTxnResult();
        }
        return this.getZKDatabase().processTxn(txnHeader, mme2, txnDigest);
    }

    public Map<Long, Set<Long>> getSessionExpiryMap() {
        return this.sessionTracker.getSessionExpiryMap();
    }

    void registerServerShutdownHandler(ZooKeeperServerShutdownHandler zooKeeperServerShutdownHandler) {
        this.zkShutdownHandler = zooKeeperServerShutdownHandler;
    }

    public boolean isResponseCachingEnabled() {
        return this.isResponseCachingEnabled;
    }

    public void setResponseCachingEnabled(boolean bl2) {
        this.isResponseCachingEnabled = bl2;
    }

    public ResponseCache getReadResponseCache() {
        return this.isResponseCachingEnabled ? this.readResponseCache : null;
    }

    public ResponseCache getGetChildrenResponseCache() {
        return this.isResponseCachingEnabled ? this.getChildrenResponseCache : null;
    }

    public void registerMetrics() {
        MetricsContext metricsContext = ServerMetrics.getMetrics().getMetricsProvider().getRootContext();
        ZKDatabase zKDatabase = this.getZKDatabase();
        ServerStats serverStats = this.serverStats();
        metricsContext.registerGauge("avg_latency", serverStats::getAvgLatency);
        metricsContext.registerGauge("max_latency", serverStats::getMaxLatency);
        metricsContext.registerGauge("min_latency", serverStats::getMinLatency);
        metricsContext.registerGauge("packets_received", serverStats::getPacketsReceived);
        metricsContext.registerGauge("packets_sent", serverStats::getPacketsSent);
        metricsContext.registerGauge("num_alive_connections", serverStats::getNumAliveClientConnections);
        metricsContext.registerGauge("outstanding_requests", serverStats::getOutstandingRequests);
        metricsContext.registerGauge("uptime", serverStats::getUptime);
        metricsContext.registerGauge("znode_count", zKDatabase::getNodeCount);
        metricsContext.registerGauge("watch_count", zKDatabase.getDataTree()::getWatchCount);
        metricsContext.registerGauge("ephemerals_count", zKDatabase.getDataTree()::getEphemeralsCount);
        metricsContext.registerGauge("approximate_data_size", zKDatabase.getDataTree()::cachedApproximateDataSize);
        metricsContext.registerGauge("global_sessions", zKDatabase::getSessionCount);
        metricsContext.registerGauge("local_sessions", this.getSessionTracker()::getLocalSessionCount);
        OSMXBean oSMXBean = new OSMXBean();
        metricsContext.registerGauge("open_file_descriptor_count", oSMXBean::getOpenFileDescriptorCount);
        metricsContext.registerGauge("max_file_descriptor_count", oSMXBean::getMaxFileDescriptorCount);
        metricsContext.registerGauge("connection_drop_probability", this::getConnectionDropChance);
        metricsContext.registerGauge("last_client_response_size", serverStats.getClientResponseStats()::getLastBufferSize);
        metricsContext.registerGauge("max_client_response_size", serverStats.getClientResponseStats()::getMaxBufferSize);
        metricsContext.registerGauge("min_client_response_size", serverStats.getClientResponseStats()::getMinBufferSize);
        metricsContext.registerGauge("outstanding_tls_handshake", this::getOutstandingHandshakeNum);
        metricsContext.registerGauge("auth_failed_count", serverStats::getAuthFailedCount);
        metricsContext.registerGauge("non_mtls_remote_conn_count", serverStats::getNonMTLSRemoteConnCount);
        metricsContext.registerGauge("non_mtls_local_conn_count", serverStats::getNonMTLSLocalConnCount);
        metricsContext.registerGaugeSet("quota_count_limit_per_namespace", () -> QuotaMetricsUtils.getQuotaCountLimit(this.zkDb.getDataTree()));
        metricsContext.registerGaugeSet("quota_bytes_limit_per_namespace", () -> QuotaMetricsUtils.getQuotaBytesLimit(this.zkDb.getDataTree()));
        metricsContext.registerGaugeSet("quota_count_usage_per_namespace", () -> QuotaMetricsUtils.getQuotaCountUsage(this.zkDb.getDataTree()));
        metricsContext.registerGaugeSet("quota_bytes_usage_per_namespace", () -> QuotaMetricsUtils.getQuotaBytesUsage(this.zkDb.getDataTree()));
    }

    public void unregisterMetrics() {
        MetricsContext metricsContext = ServerMetrics.getMetrics().getMetricsProvider().getRootContext();
        metricsContext.unregisterGauge("avg_latency");
        metricsContext.unregisterGauge("max_latency");
        metricsContext.unregisterGauge("min_latency");
        metricsContext.unregisterGauge("packets_received");
        metricsContext.unregisterGauge("packets_sent");
        metricsContext.unregisterGauge("num_alive_connections");
        metricsContext.unregisterGauge("outstanding_requests");
        metricsContext.unregisterGauge("uptime");
        metricsContext.unregisterGauge("znode_count");
        metricsContext.unregisterGauge("watch_count");
        metricsContext.unregisterGauge("ephemerals_count");
        metricsContext.unregisterGauge("approximate_data_size");
        metricsContext.unregisterGauge("global_sessions");
        metricsContext.unregisterGauge("local_sessions");
        metricsContext.unregisterGauge("open_file_descriptor_count");
        metricsContext.unregisterGauge("max_file_descriptor_count");
        metricsContext.unregisterGauge("connection_drop_probability");
        metricsContext.unregisterGauge("last_client_response_size");
        metricsContext.unregisterGauge("max_client_response_size");
        metricsContext.unregisterGauge("min_client_response_size");
        metricsContext.unregisterGauge("auth_failed_count");
        metricsContext.unregisterGauge("non_mtls_remote_conn_count");
        metricsContext.unregisterGauge("non_mtls_local_conn_count");
        metricsContext.unregisterGaugeSet("quota_count_limit_per_namespace");
        metricsContext.unregisterGaugeSet("quota_bytes_limit_per_namespace");
        metricsContext.unregisterGaugeSet("quota_count_usage_per_namespace");
        metricsContext.unregisterGaugeSet("quota_bytes_usage_per_namespace");
    }

    public void dumpMonitorValues(BiConsumer<String, Object> biConsumer) {
        ServerStats serverStats = this.serverStats();
        biConsumer.accept("version", Version.getFullVersion());
        biConsumer.accept("server_state", serverStats.getServerState());
    }

    public void checkACL(ServerCnxn serverCnxn, List<ACL> list, int n2, List<Id> list2, String string, List<ACL> list3) throws KeeperException.NoAuthException {
        if (skipACL) {
            return;
        }
        LOG.b("Permission requested: {} ", (Object)n2);
        LOG.b("ACLs for node: {}", (Object)list);
        LOG.b("Client credentials: {}", (Object)list2);
        if (list == null || list.size() == 0) {
            return;
        }
        for (Id mme2 : list2) {
            if (!mme2.getScheme().equals("super")) continue;
            return;
        }
        for (ACL aCL : list) {
            Id id2 = aCL.getId();
            if ((aCL.getPerms() & n2) == 0) continue;
            if (id2.getScheme().equals("world") && id2.getId().equals("anyone")) {
                return;
            }
            ServerAuthenticationProvider serverAuthenticationProvider = ProviderRegistry.getServerProvider(id2.getScheme());
            if (serverAuthenticationProvider == null) continue;
            for (Id id3 : list2) {
                if (!id3.getScheme().equals(id2.getScheme()) || !serverAuthenticationProvider.matches(new ServerAuthenticationProvider.ServerObjs(this, serverCnxn), new ServerAuthenticationProvider.MatchValues(string, id3.getId(), id2.getId(), n2, list3))) continue;
                return;
            }
        }
        throw new KeeperException.NoAuthException();
    }

    public void checkQuota(String string, byte[] byArray, byte[] byArray2, int n2) throws KeeperException.QuotaExceededException {
        if (!enforceQuota) {
            return;
        }
        long l2 = byArray2 == null ? 0L : (long)byArray2.length;
        ZKDatabase zKDatabase = this.getZKDatabase();
        String string2 = zKDatabase.getDataTree().getMaxPrefixWithQuota(string);
        if (StringUtils.isEmpty(string2)) {
            return;
        }
        String string3 = PathUtils.getTopNamespace(string);
        switch (n2) {
            case 1: {
                this.checkQuota(string2, l2, 1L, string3);
                break;
            }
            case 5: {
                this.checkQuota(string2, l2 - (long)(byArray == null ? 0 : byArray.length), 0L, string3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported OpCode for checkQuota: " + n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkQuota(String string, long l2, long l3, String string2) throws KeeperException.QuotaExceededException {
        String string3;
        long l4;
        boolean bl2;
        StatsTrack statsTrack;
        boolean bl3;
        StatsTrack statsTrack2;
        LOG.b("checkQuota: lastPrefix={}, bytesDiff={}, countDiff={}", string, l2, l3);
        String string4 = Quotas.limitPath(string);
        DataNode dataNode = this.getZKDatabase().getNode(string4);
        if (dataNode == null) {
            LOG.e("Missing limit node for quota {}", (Object)string4);
            return;
        }
        DataNode dataNode2 = dataNode;
        synchronized (dataNode2) {
            statsTrack2 = new StatsTrack(dataNode.data);
        }
        boolean bl4 = l3 != 0L && (statsTrack2.getCount() > -1L || statsTrack2.getCountHardLimit() > -1L);
        boolean bl5 = bl3 = l2 != 0L && (statsTrack2.getBytes() > -1L || statsTrack2.getByteHardLimit() > -1L);
        if (!bl4 && !bl3) {
            return;
        }
        String string5 = Quotas.statPath(string);
        dataNode = this.getZKDatabase().getNode(string5);
        if (dataNode == null) {
            LOG.e("Missing node for stat {}", (Object)string5);
            return;
        }
        DataNode dataNode3 = dataNode;
        synchronized (dataNode3) {
            statsTrack = new StatsTrack(dataNode.data);
        }
        if (bl4) {
            long l5 = statsTrack.getCount() + l3;
            bl2 = statsTrack2.getCountHardLimit() > -1L;
            long l6 = l4 = bl2 ? statsTrack2.getCountHardLimit() : statsTrack2.getCount();
            if (l5 > l4) {
                string3 = "Quota exceeded: " + string + " [current count=" + l5 + ", " + (bl2 ? "hard" : "soft") + "CountLimit=" + l4 + "]";
                RATE_LOGGER.rateLimitLog(string3);
                if (bl2) {
                    ZooKeeperServer.updateQuotaExceededMetrics(string2);
                    throw new KeeperException.QuotaExceededException(string);
                }
            }
        }
        if (bl3) {
            long l7 = statsTrack.getBytes() + l2;
            bl2 = statsTrack2.getByteHardLimit() > -1L;
            long l8 = l4 = bl2 ? statsTrack2.getByteHardLimit() : statsTrack2.getBytes();
            if (l7 > l4) {
                string3 = "Quota exceeded: " + string + " [current bytes=" + l7 + ", " + (bl2 ? "hard" : "soft") + "ByteLimit=" + l4 + "]";
                RATE_LOGGER.rateLimitLog(string3);
                if (bl2) {
                    ZooKeeperServer.updateQuotaExceededMetrics(string2);
                    throw new KeeperException.QuotaExceededException(string);
                }
            }
        }
    }

    public static boolean isDigestEnabled() {
        return digestEnabled;
    }

    public static void setDigestEnabled(boolean bl2) {
        LOG.c("{} = {}", (Object)ZOOKEEPER_DIGEST_ENABLED, (Object)bl2);
        digestEnabled = bl2;
    }

    public static boolean isSerializeLastProcessedZxidEnabled() {
        return serializeLastProcessedZxidEnabled;
    }

    public static void setSerializeLastProcessedZxidEnabled(boolean bl2) {
        serializeLastProcessedZxidEnabled = bl2;
        LOG.c("{} = {}", (Object)ZOOKEEPER_SERIALIZE_LAST_PROCESSED_ZXID_ENABLED, (Object)bl2);
    }

    private String parentPath(String string) throws KeeperException.BadArgumentsException {
        int n2 = string.lastIndexOf(47);
        if (n2 == -1 || string.indexOf(0) != -1 || this.getZKDatabase().isSpecialPath(string)) {
            throw new KeeperException.BadArgumentsException(string);
        }
        return n2 == 0 ? "/" : string.substring(0, n2);
    }

    private String effectiveACLPath(Request request) throws KeeperException.BadArgumentsException, KeeperException.InvalidACLException {
        boolean bl2 = false;
        String string = null;
        List<ACL> list = null;
        switch (request.type) {
            case 1: 
            case 15: {
                CreateRequest createRequest = request.readRequestRecordNoException(CreateRequest::new);
                if (createRequest == null) break;
                bl2 = true;
                list = createRequest.getAcl();
                string = this.parentPath(createRequest.getPath());
                break;
            }
            case 2: {
                DeleteRequest deleteRequest = request.readRequestRecordNoException(DeleteRequest::new);
                if (deleteRequest == null) break;
                string = this.parentPath(deleteRequest.getPath());
                break;
            }
            case 5: {
                SetDataRequest setDataRequest = request.readRequestRecordNoException(SetDataRequest::new);
                if (setDataRequest == null) break;
                string = setDataRequest.getPath();
                break;
            }
            case 7: {
                SetACLRequest setACLRequest = request.readRequestRecordNoException(SetACLRequest::new);
                if (setACLRequest == null) break;
                bl2 = true;
                list = setACLRequest.getAcl();
                string = setACLRequest.getPath();
                break;
            }
        }
        if (bl2) {
            PrepRequestProcessor.fixupACL(string, request.authInfo, list);
        }
        return string;
    }

    private int effectiveACLPerms(Request request) {
        switch (request.type) {
            case 1: 
            case 15: {
                return 4;
            }
            case 2: {
                return 8;
            }
            case 5: {
                return 2;
            }
            case 7: {
                return 16;
            }
        }
        return 31;
    }

    public boolean authWriteRequest(Request request) {
        if (!enableEagerACLCheck) {
            return true;
        }
        int n2 = KeeperException.Code.OK.intValue();
        try {
            String string = this.effectiveACLPath(request);
            if (string != null) {
                this.checkACL(request.cnxn, this.zkDb.getACL(string, null), this.effectiveACLPerms(request), request.authInfo, string, null);
            }
        }
        catch (KeeperException.NoAuthException noAuthException) {
            LOG.a("Request failed ACL check", noAuthException);
            n2 = noAuthException.code().intValue();
        }
        catch (KeeperException.InvalidACLException invalidACLException) {
            LOG.a("Request has an invalid ACL check", invalidACLException);
            n2 = invalidACLException.code().intValue();
        }
        catch (KeeperException.NoNodeException noNodeException) {
            LOG.b("ACL check against non-existent node: {}", (Object)noNodeException.getMessage());
        }
        catch (KeeperException.BadArgumentsException badArgumentsException) {
            LOG.b("ACL check against illegal node path: {}", (Object)badArgumentsException.getMessage());
        }
        catch (Throwable throwable) {
            LOG.d("Uncaught exception in authWriteRequest with: ", throwable);
            throw throwable;
        }
        finally {
            if (n2 != KeeperException.Code.OK.intValue()) {
                this.decInProcess();
                ReplyHeader replyHeader = new ReplyHeader(request.cxid, 0L, n2);
                try {
                    request.cnxn.sendResponse(replyHeader, null, null);
                }
                catch (IOException iOException) {
                    LOG.d("IOException : {}", iOException);
                }
            }
        }
        return n2 == KeeperException.Code.OK.intValue();
    }

    public int getOutstandingHandshakeNum() {
        if (this.serverCnxnFactory instanceof NettyServerCnxnFactory) {
            return ((NettyServerCnxnFactory)this.serverCnxnFactory).getOutstandingHandshakeNum();
        }
        return 0;
    }

    public boolean isReconfigEnabled() {
        return this.reconfigEnabled;
    }

    public ZooKeeperServerShutdownHandler getZkShutdownHandler() {
        return this.zkShutdownHandler;
    }

    static void updateQuotaExceededMetrics(String string) {
        if (string == null) {
            return;
        }
        ServerMetrics.getMetrics().QUOTA_EXCEEDED_ERROR_PER_NAMESPACE.add(string, 1L);
    }

    static {
        closeSessionTxnEnabled = true;
        LOG = goe.a(ZooKeeperServer.class);
        RATE_LOGGER = new RateLogger(LOG);
        ZookeeperBanner.printBanner(LOG);
        Environment.logEnv("Server environment:", LOG);
        enableEagerACLCheck = Boolean.getBoolean(ENABLE_EAGER_ACL_CHECK);
        LOG.c("{} = {}", (Object)ENABLE_EAGER_ACL_CHECK, (Object)enableEagerACLCheck);
        skipACL = System.getProperty(SKIP_ACL, "no").equals("yes");
        if (skipACL) {
            LOG.c("{}==\"yes\", ACL checks will be skipped", (Object)SKIP_ACL);
        }
        if (enforceQuota = Boolean.parseBoolean(System.getProperty(ENFORCE_QUOTA, "false"))) {
            LOG.c("{} = {}, Quota Enforce enables", (Object)ENFORCE_QUOTA, (Object)enforceQuota);
        }
        digestEnabled = Boolean.parseBoolean(System.getProperty(ZOOKEEPER_DIGEST_ENABLED, "true"));
        LOG.c("{} = {}", (Object)ZOOKEEPER_DIGEST_ENABLED, (Object)digestEnabled);
        closeSessionTxnEnabled = Boolean.parseBoolean(System.getProperty(CLOSE_SESSION_TXN_ENABLED, "true"));
        LOG.c("{} = {}", (Object)CLOSE_SESSION_TXN_ENABLED, (Object)closeSessionTxnEnabled);
        ZooKeeperServer.setSerializeLastProcessedZxidEnabled(Boolean.parseBoolean(System.getProperty(ZOOKEEPER_SERIALIZE_LAST_PROCESSED_ZXID_ENABLED, "true")));
        throttledOpWaitTime = Integer.getInteger("zookeeper.throttled_op_wait_time", 0);
        ok = new Exception("No prob");
        long l2 = Long.getLong(FLUSH_DELAY, 0L);
        ZooKeeperServer.setFlushDelay(l2);
        ZooKeeperServer.setMaxWriteQueuePollTime(Long.getLong(MAX_WRITE_QUEUE_POLL_SIZE, l2 / 3L));
        ZooKeeperServer.setMaxBatchSize(Integer.getInteger(MAX_BATCH_SIZE, 1000));
        intBufferStartingSizeBytes = Integer.getInteger(INT_BUFFER_STARTING_SIZE_BYTES, 1024);
        if (intBufferStartingSizeBytes < 32) {
            String string = "Buffer starting size (" + intBufferStartingSizeBytes + ") must be greater than or equal to 32. Configure with \"-Dzookeeper.intBufferStartingSizeBytes=<size>\" ";
            LOG.e(string);
            throw new IllegalArgumentException(string);
        }
        LOG.c("{} = {}", (Object)INT_BUFFER_STARTING_SIZE_BYTES, (Object)intBufferStartingSizeBytes);
    }

    static class ChangeRecord {
        PrecalculatedDigest precalculatedDigest;
        byte[] data;
        long zxid;
        String path;
        StatPersisted stat;
        int childCount;
        List<ACL> acl;

        ChangeRecord(long l2, String string, StatPersisted statPersisted, int n2, List<ACL> list) {
            this.zxid = l2;
            this.path = string;
            this.stat = statPersisted;
            this.childCount = n2;
            this.acl = list;
        }

        ChangeRecord duplicate(long l2) {
            StatPersisted statPersisted = new StatPersisted();
            if (this.stat != null) {
                DataTree.copyStatPersisted(this.stat, statPersisted);
            }
            ChangeRecord changeRecord = new ChangeRecord(l2, this.path, statPersisted, this.childCount, this.acl == null ? new ArrayList<ACL>() : new ArrayList<ACL>(this.acl));
            changeRecord.precalculatedDigest = this.precalculatedDigest;
            changeRecord.data = this.data;
            return changeRecord;
        }
    }

    static class PrecalculatedDigest {
        final long nodeDigest;
        final long treeDigest;

        PrecalculatedDigest(long l2, long l3) {
            this.nodeDigest = l2;
            this.treeDigest = l3;
        }
    }

    public static class MissingSessionException
    extends IOException {
        private static final long serialVersionUID = 7467414635467261007L;

        public MissingSessionException(String string) {
            super(string);
        }
    }

    public static enum State {
        INITIAL,
        RUNNING,
        SHUTDOWN,
        ERROR;

    }
}

