/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class WorkerService {
    private static final foe LOG = goe.a(WorkerService.class);
    private final ArrayList<ExecutorService> workers = new ArrayList();
    private final String threadNamePrefix;
    private int numWorkerThreads;
    private boolean threadsAreAssignable;
    private volatile boolean stopped = true;

    public WorkerService(String string, int n2, boolean bl2) {
        this.threadNamePrefix = (string == null ? "" : string) + "Thread";
        this.numWorkerThreads = n2;
        this.threadsAreAssignable = bl2;
        this.start();
    }

    public void schedule(WorkRequest workRequest) {
        this.schedule(workRequest, 0L);
    }

    public void schedule(WorkRequest workRequest, long l2) {
        if (this.stopped) {
            workRequest.cleanup();
            return;
        }
        ScheduledWorkRequest scheduledWorkRequest = new ScheduledWorkRequest(workRequest);
        int n2 = this.workers.size();
        if (n2 > 0) {
            try {
                int n3 = ((int)(l2 % (long)n2) + n2) % n2;
                ExecutorService executorService = this.workers.get(n3);
                executorService.execute(scheduledWorkRequest);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                LOG.c("ExecutorService rejected execution", rejectedExecutionException);
                workRequest.cleanup();
            }
        } else {
            scheduledWorkRequest.run();
        }
    }

    public void start() {
        if (this.numWorkerThreads > 0) {
            if (this.threadsAreAssignable) {
                for (int i2 = 1; i2 <= this.numWorkerThreads; ++i2) {
                    this.workers.add(Executors.newFixedThreadPool(1, new DaemonThreadFactory(this.threadNamePrefix, i2)));
                }
            } else {
                this.workers.add(Executors.newFixedThreadPool(this.numWorkerThreads, new DaemonThreadFactory(this.threadNamePrefix)));
            }
        }
        this.stopped = false;
    }

    public void stop() {
        this.stopped = true;
        for (ExecutorService executorService : this.workers) {
            executorService.shutdown();
        }
    }

    public void join(long l2) {
        long l3 = Time.currentElapsedTime();
        long l4 = l3 + l2;
        for (ExecutorService executorService : this.workers) {
            boolean bl2 = false;
            while ((l3 = Time.currentElapsedTime()) <= l4) {
                try {
                    bl2 = executorService.awaitTermination(l4 - l3, TimeUnit.MILLISECONDS);
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
            if (bl2) continue;
            executorService.shutdownNow();
        }
    }

    static class DaemonThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        DaemonThreadFactory(String string) {
            this(string, 1);
        }

        DaemonThreadFactory(String string, int n2) {
            this.threadNumber.set(n2);
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = string + "-";
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!thread.isDaemon()) {
                thread.setDaemon(true);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }

    class ScheduledWorkRequest
    implements Runnable {
        private final WorkRequest workRequest;

        ScheduledWorkRequest(WorkRequest workRequest) {
            this.workRequest = workRequest;
        }

        @Override
        public void run() {
            try {
                if (WorkerService.this.stopped) {
                    this.workRequest.cleanup();
                    return;
                }
                this.workRequest.doWork();
            }
            catch (Exception exception) {
                LOG.c("Unexpected exception", exception);
                this.workRequest.cleanup();
            }
        }
    }

    public static abstract class WorkRequest {
        public abstract void doWork() throws Exception;

        public void cleanup() {
        }
    }
}

