/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.hme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataNode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataTree;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileSnap;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.SnapStream;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.zip.CheckedInputStream;

public class SnapshotRecursiveSummary {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 3) {
            System.err.println(SnapshotRecursiveSummary.getUsage());
            System.exit(2);
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(stringArray[2]);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(SnapshotRecursiveSummary.getUsage());
            System.exit(2);
        }
        new SnapshotRecursiveSummary().run(stringArray[0], stringArray[1], n2);
    }

    public void run(String string, String string2, int n2) throws IOException {
        File file = new File(string);
        try (CheckedInputStream checkedInputStream = SnapStream.getInputStream(file);){
            hme hme2 = hme.a(checkedInputStream);
            DataTree dataTree = new DataTree();
            HashMap<Long, Integer> hashMap = new HashMap<Long, Integer>();
            FileSnap.deserialize(dataTree, hashMap, hme2);
            this.printZnodeDetails(dataTree, string2, n2);
        }
    }

    private void printZnodeDetails(DataTree dataTree, String string, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        this.printZnode(dataTree, string, stringBuilder, 0, n2);
        System.out.println(stringBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] printZnode(DataTree dataTree, String string, StringBuilder stringBuilder, int n2, int n3) {
        Set<String> set;
        DataNode dataNode = dataTree.getNode(string);
        long l2 = 0L;
        Object object = dataNode;
        synchronized (object) {
            if (dataNode.data != null) {
                l2 += (long)dataNode.data.length;
            }
            set = dataNode.getChildren();
        }
        object = new long[]{1L, l2};
        if (set.size() == 0) {
            return object;
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        for (String string2 : set) {
            long[] lArray = this.printZnode(dataTree, string + (string.equals("/") ? "" : "/") + string2, stringBuilder2, n2 + 1, n3);
            object[0] = object[0] + lArray[0];
            object[1] = object[1] + lArray[1];
        }
        if (n3 == 0 || n2 <= n3) {
            String string3 = String.join((CharSequence)"", Collections.nCopies(n2, "--"));
            stringBuilder.append((String)string3 + " " + string + "\n");
            stringBuilder.append((String)string3 + "   children: " + (long)(object[0] - 1L) + "\n");
            stringBuilder.append((String)string3 + "   data: " + (long)object[1] + "\n");
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        return object;
    }

    public static String getUsage() {
        String string = System.getProperty("line.separator");
        return String.join((CharSequence)string, "USAGE:", string, "SnapshotRecursiveSummary  <snapshot_file>  <starting_node>  <max_depth>", string, "snapshot_file:    path to the zookeeper snapshot", "starting_node:    the path in the zookeeper tree where the traversal should begin", "max_depth:        defines the depth where the tool still writes to the output. 0 means there is no depth limit, every non-leaf node's stats will be displayed, 1 means it will only contain the starting node's and it's children's stats, 2 ads another level and so on. This ONLY affects the level of details displayed, NOT the calculation.");
    }
}

