/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.hme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ZKUtil;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.StatPersisted;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataNode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataTree;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ExitCode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileSnap;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.SnapStream;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.Util;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.util.ServiceUtils;
import com.fasterxml.jackson.core.io.JsonStringEncoder;
import java.io.File;
import java.io.IOException;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.CheckedInputStream;

public class SnapshotFormatter {
    private static Integer INODE_IDX = 1000;

    public static void main(String[] stringArray) throws Exception {
        int n2;
        String string = null;
        boolean bl2 = false;
        boolean bl3 = false;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2].equals("-d")) {
                bl2 = true;
                continue;
            }
            if (stringArray[n2].equals("-json")) {
                bl3 = true;
                continue;
            }
            string = stringArray[n2];
            ++n2;
            break;
        }
        if (stringArray.length != n2 || string == null) {
            System.err.println("USAGE: SnapshotFormatter [-d|-json] snapshot_file");
            System.err.println("       -d dump the data for each znode");
            System.err.println("       -json dump znode info in json format");
            ServiceUtils.requestSystemExit(ExitCode.INVALID_INVOCATION.getValue());
            return;
        }
        String string2 = ZKUtil.validateFileInput(string);
        if (null != string2) {
            System.err.println(string2);
            ServiceUtils.requestSystemExit(ExitCode.INVALID_INVOCATION.getValue());
        }
        if (bl2 && bl3) {
            System.err.println("Cannot specify both data dump (-d) and json mode (-json) in same call");
            ServiceUtils.requestSystemExit(ExitCode.INVALID_INVOCATION.getValue());
        }
        new SnapshotFormatter().run(string, bl2, bl3);
    }

    public void run(String string, boolean bl2, boolean bl3) throws IOException {
        File file = new File(string);
        try (CheckedInputStream checkedInputStream = SnapStream.getInputStream(file);){
            hme hme2 = hme.a(checkedInputStream);
            DataTree dataTree = new DataTree();
            HashMap<Long, Integer> hashMap = new HashMap<Long, Integer>();
            FileSnap.deserialize(dataTree, hashMap, hme2);
            long l2 = Util.getZxidFromName(file.getName(), "snapshot");
            if (bl3) {
                this.printSnapshotJson(dataTree);
            } else {
                this.printDetails(dataTree, hashMap, bl2, l2);
            }
        }
    }

    private void printDetails(DataTree dataTree, Map<Long, Integer> map, boolean bl2, long l2) {
        long l3 = this.printZnodeDetails(dataTree, bl2);
        this.printSessionDetails(dataTree, map);
        DataTree.ZxidDigest zxidDigest = dataTree.getDigestFromLoadedSnapshot();
        if (zxidDigest != null) {
            System.out.println(String.format("Target zxid digest is: %s, %s", Long.toHexString(zxidDigest.zxid), zxidDigest.digest));
        }
        System.out.println(String.format("----%nLast zxid: 0x%s", Long.toHexString(Math.max(l2, l3))));
    }

    private long printZnodeDetails(DataTree dataTree, boolean bl2) {
        System.out.println(String.format("ZNode Details (count=%d):", dataTree.getNodeCount()));
        long l2 = this.printZnode(dataTree, "/", bl2);
        System.out.println("----");
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long printZnode(DataTree dataTree, String string, boolean bl2) {
        Set<String> set;
        long l2;
        System.out.println("----");
        DataNode dataNode = dataTree.getNode(string);
        DataNode dataNode2 = dataNode;
        synchronized (dataNode2) {
            System.out.println(string);
            this.printStat(dataNode.stat);
            l2 = Math.max(dataNode.stat.getMzxid(), dataNode.stat.getPzxid());
            if (bl2) {
                System.out.println("  data = " + (dataNode.data == null ? "" : Base64.getEncoder().encodeToString(dataNode.data)));
            } else {
                System.out.println("  dataLength = " + (dataNode.data == null ? 0 : dataNode.data.length));
            }
            set = dataNode.getChildren();
        }
        if (set != null) {
            for (String string2 : set) {
                long l3 = this.printZnode(dataTree, string + (string.equals("/") ? "" : "/") + string2, bl2);
                l2 = Math.max(l2, l3);
            }
        }
        return l2;
    }

    private void printSessionDetails(DataTree dataTree, Map<Long, Integer> map) {
        System.out.println("Session Details (sid, timeout, ephemeralCount):");
        for (Map.Entry<Long, Integer> entry : map.entrySet()) {
            long l2 = entry.getKey();
            System.out.println(String.format("%#016x, %d, %d", l2, entry.getValue(), dataTree.getEphemerals(l2).size()));
        }
    }

    private void printStat(StatPersisted statPersisted) {
        this.printHex("cZxid", statPersisted.getCzxid());
        System.out.println("  ctime = " + new Date(statPersisted.getCtime()).toString());
        this.printHex("mZxid", statPersisted.getMzxid());
        System.out.println("  mtime = " + new Date(statPersisted.getMtime()).toString());
        this.printHex("pZxid", statPersisted.getPzxid());
        System.out.println("  cversion = " + statPersisted.getCversion());
        System.out.println("  dataVersion = " + statPersisted.getVersion());
        System.out.println("  aclVersion = " + statPersisted.getAversion());
        this.printHex("ephemeralOwner", statPersisted.getEphemeralOwner());
    }

    private void printHex(String string, long l2) {
        System.out.println(String.format("  %s = %#016x", string, l2));
    }

    private void printSnapshotJson(DataTree dataTree) {
        JsonStringEncoder jsonStringEncoder = JsonStringEncoder.getInstance();
        System.out.printf("[1,0,{\"progname\":\"SnapshotFormatter.java\",\"progver\":\"0.01\",\"timestamp\":%d}", System.currentTimeMillis());
        this.printZnodeJson(dataTree, "/", jsonStringEncoder);
        System.out.print("]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printZnodeJson(DataTree dataTree, String string, JsonStringEncoder jsonStringEncoder) {
        Set<String> set;
        int n2;
        DataNode dataNode = dataTree.getNode(string);
        if (null == dataNode) {
            System.err.println("DataTree Node for " + string + " doesn't exist");
            return;
        }
        String string2 = string.equals("/") ? string : string.substring(string.lastIndexOf("/") + 1);
        System.out.print(",");
        Object object = dataNode;
        synchronized (object) {
            n2 = dataNode.data == null ? 0 : dataNode.data.length;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("{");
        ((StringBuilder)object).append("\"name\":\"").append(jsonStringEncoder.quoteAsString(string2)).append("\"").append(",");
        ((StringBuilder)object).append("\"asize\":").append(n2).append(",");
        ((StringBuilder)object).append("\"dsize\":").append(n2).append(",");
        ((StringBuilder)object).append("\"dev\":").append(0).append(",");
        INODE_IDX = INODE_IDX + 1;
        ((StringBuilder)object).append("\"ino\":").append(INODE_IDX);
        ((StringBuilder)object).append("}");
        DataNode dataNode2 = dataNode;
        synchronized (dataNode2) {
            set = dataNode.getChildren();
        }
        if (set != null && set.size() > 0) {
            System.out.print("[" + object);
            for (String string3 : set) {
                this.printZnodeJson(dataTree, string + (string.equals("/") ? "" : "/") + string3, jsonStringEncoder);
            }
            System.out.print("]");
        } else {
            System.out.print(object);
        }
    }
}

