/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Stat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class ResponseCache {
    private static final foe LOG = goe.a(ResponseCache.class);
    public static final int DEFAULT_RESPONSE_CACHE_SIZE = 400;
    private final int cacheSize;
    private final Map<String, Entry> cache;

    public ResponseCache(int n2, String string) {
        this.cacheSize = n2;
        this.cache = Collections.synchronizedMap(new LRUCache(n2));
        LOG.c("{} response cache size is initialized with value {}.", (Object)string, (Object)n2);
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void put(String string, byte[] byArray, Stat stat) {
        Entry entry = new Entry();
        entry.data = byArray;
        entry.stat = stat;
        this.cache.put(string, entry);
    }

    public byte[] get(String string, Stat stat) {
        Entry entry = this.cache.get(string);
        if (entry == null) {
            return null;
        }
        if (!stat.equals(entry.stat)) {
            this.cache.remove(string);
            return null;
        }
        return entry.data;
    }

    public boolean isEnabled() {
        return this.cacheSize > 0;
    }

    static class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private int cacheSize;

        LRUCache(int n2) {
            super(n2 / 4);
            this.cacheSize = n2;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
            return this.size() >= this.cacheSize;
        }
    }

    static class Entry {
        public Stat stat;
        public byte[] data;

        private Entry() {
        }
    }
}

