/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ExitCode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperCriticalThread;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.util.ServiceUtils;
import java.util.concurrent.LinkedBlockingQueue;

public class RequestThrottler
extends ZooKeeperCriticalThread {
    private static final foe LOG = goe.a(RequestThrottler.class);
    private final LinkedBlockingQueue<Request> submittedRequests = new LinkedBlockingQueue();
    private final ZooKeeperServer zks;
    private volatile boolean stopping;
    private volatile boolean killed;
    private static final String SHUTDOWN_TIMEOUT = "zookeeper.request_throttler.shutdownTimeout";
    private static int shutdownTimeout = Integer.getInteger("zookeeper.request_throttler.shutdownTimeout", 10000);
    private static volatile int maxRequests;
    private static volatile int stallTime;
    private static volatile boolean dropStaleRequests;

    protected boolean shouldThrottleOp(Request request, long l2) {
        return request.isThrottlable() && ZooKeeperServer.getThrottledOpWaitTime() > 0 && l2 > (long)ZooKeeperServer.getThrottledOpWaitTime();
    }

    public RequestThrottler(ZooKeeperServer zooKeeperServer) {
        super("RequestThrottler", zooKeeperServer.getZooKeeperServerListener());
        this.zks = zooKeeperServer;
        this.stopping = false;
        this.killed = false;
    }

    public static int getMaxRequests() {
        return maxRequests;
    }

    public static void setMaxRequests(int n2) {
        maxRequests = n2;
    }

    public static int getStallTime() {
        return stallTime;
    }

    public static void setStallTime(int n2) {
        stallTime = n2;
    }

    public static boolean getDropStaleRequests() {
        return dropStaleRequests;
    }

    public static void setDropStaleRequests(boolean bl2) {
        dropStaleRequests = bl2;
    }

    @Override
    public void run() {
        try {
            Request request;
            while (!this.killed && Request.requestOfDeath != (request = this.submittedRequests.take())) {
                if (request.mustDrop()) continue;
                if (maxRequests > 0) {
                    while (!this.killed) {
                        if (dropStaleRequests && request.isStale()) {
                            this.dropRequest(request);
                            ServerMetrics.getMetrics().STALE_REQUESTS_DROPPED.add(1L);
                            request = null;
                            break;
                        }
                        if (this.zks.getInProcess() < maxRequests) break;
                        this.throttleSleep(stallTime);
                    }
                }
                if (!this.killed) {
                    if (request == null) continue;
                    if (request.isStale()) {
                        ServerMetrics.getMetrics().STALE_REQUESTS.add(1L);
                    }
                    long l2 = Time.currentElapsedTime() - request.requestThrottleQueueTime;
                    ServerMetrics.getMetrics().REQUEST_THROTTLE_QUEUE_TIME.add(l2);
                    if (this.shouldThrottleOp(request, l2)) {
                        request.setIsThrottled(true);
                        ServerMetrics.getMetrics().THROTTLED_OPS.add(1L);
                    }
                    this.zks.submitRequestNow(request);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            LOG.d("Unexpected interruption", interruptedException);
        }
        int n2 = this.drainQueue();
        LOG.c("RequestThrottler shutdown. Dropped {} requests", (Object)n2);
    }

    synchronized void throttleSleep(int n2) throws InterruptedException {
        ServerMetrics.getMetrics().REQUEST_THROTTLE_WAIT_COUNT.add(1L);
        this.wait(n2);
    }

    public synchronized void throttleWake() {
        this.notify();
    }

    private int drainQueue() {
        Request request;
        int n2 = 0;
        LOG.c("Draining request throttler queue");
        while ((request = this.submittedRequests.poll()) != null) {
            ++n2;
            this.dropRequest(request);
        }
        return n2;
    }

    private void dropRequest(Request request) {
        ServerCnxn serverCnxn = request.getConnection();
        if (serverCnxn != null) {
            serverCnxn.setInvalid();
        }
        this.zks.requestFinished(request);
    }

    public void submitRequest(Request request) {
        if (this.stopping) {
            LOG.b("Shutdown in progress. Request cannot be processed");
            this.dropRequest(request);
        } else {
            request.requestThrottleQueueTime = Time.currentElapsedTime();
            this.submittedRequests.add(request);
        }
    }

    public int getInflight() {
        return this.submittedRequests.size();
    }

    public void shutdown() {
        LOG.c("Shutting down");
        this.stopping = true;
        this.submittedRequests.add(Request.requestOfDeath);
        try {
            this.join(shutdownTimeout);
        }
        catch (InterruptedException interruptedException) {
            LOG.d("Interrupted while waiting for {} to finish", (Object)this);
        }
        this.killed = true;
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            LOG.d("Interrupted while waiting for {} to finish", (Object)this);
            ServiceUtils.requestSystemExit(ExitCode.UNEXPECTED_ERROR.getValue());
        }
    }

    static {
        LOG.c("{} = {} ms", (Object)SHUTDOWN_TIMEOUT, (Object)shutdownTimeout);
        maxRequests = Integer.getInteger("zookeeper.request_throttle_max_requests", 0);
        stallTime = Integer.getInteger("zookeeper.request_throttle_stall_time", 100);
        dropStaleRequests = Boolean.parseBoolean(System.getProperty("zookeeper.request_throttle_drop_stale", "true"));
    }
}

