/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XcoreXdatabricksX240X9088.jme;
import XcoreXdatabricksX240X9088.kme;
import XcoreXdatabricksX240X9088.lme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ZooDefs;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.ACL;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class ReferenceCountedACLCache {
    private static final foe LOG = goe.a(ReferenceCountedACLCache.class);
    final Map<Long, List<ACL>> longKeyMap = new HashMap<Long, List<ACL>>();
    final Map<List<ACL>, Long> aclKeyMap = new HashMap<List<ACL>, Long>();
    final Map<Long, AtomicLongWithEquals> referenceCounter = new HashMap<Long, AtomicLongWithEquals>();
    private static final long OPEN_UNSAFE_ACL_ID = -1L;
    long aclIndex = 0L;

    public synchronized Long convertAcls(List<ACL> list) {
        if (list == null) {
            return -1L;
        }
        Long l2 = this.aclKeyMap.get(list);
        if (l2 == null) {
            l2 = this.incrementIndex();
            this.longKeyMap.put(l2, list);
            this.aclKeyMap.put(list, l2);
        }
        this.addUsage(l2);
        return l2;
    }

    public synchronized List<ACL> convertLong(Long l2) {
        if (l2 == null) {
            return null;
        }
        if (l2 == -1L) {
            return ZooDefs.Ids.OPEN_ACL_UNSAFE;
        }
        List<ACL> list = this.longKeyMap.get(l2);
        if (list == null) {
            LOG.e("ERROR: ACL not available for long {}", (Object)l2);
            throw new RuntimeException("Failed to fetch acls for " + l2);
        }
        return list;
    }

    private long incrementIndex() {
        return ++this.aclIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserialize(kme kme2) throws IOException {
        Object object;
        Object object2;
        this.clear();
        LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>();
        for (int i2 = kme2.c("map"); i2 > 0; --i2) {
            object2 = kme2.d("long");
            ArrayList arrayList = new ArrayList();
            jme object3 = kme2.i("acls");
            if (object3 == null) {
                throw new RuntimeException("Incorrent format of InputArchive when deserialize DataTree - missing acls");
            }
            while (!object3.a()) {
                object = new ACL();
                ((ACL)object).deserialize(kme2, "acl");
                arrayList.add(object);
                object3.b();
            }
            linkedHashMap.put(object2, arrayList);
        }
        object2 = this;
        synchronized (object2) {
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                object = (Long)entry.getKey();
                List list = (List)entry.getValue();
                if (this.aclIndex < (Long)object) {
                    this.aclIndex = (Long)object;
                }
                this.longKeyMap.put((Long)object, list);
                this.aclKeyMap.put(list, (Long)object);
                this.referenceCounter.put((Long)object, new AtomicLongWithEquals(0L));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(lme lme2) throws IOException {
        HashMap<Long, List<ACL>> hashMap;
        ReferenceCountedACLCache referenceCountedACLCache = this;
        synchronized (referenceCountedACLCache) {
            hashMap = new HashMap<Long, List<ACL>>(this.longKeyMap);
        }
        lme2.a(hashMap.size(), "map");
        for (Map.Entry entry : hashMap.entrySet()) {
            lme2.a((Long)entry.getKey(), "long");
            List list = (List)entry.getValue();
            lme2.a(list, "acls");
            for (ACL aCL : list) {
                aCL.serialize(lme2, "acl");
            }
            lme2.b(list, "acls");
        }
    }

    public int size() {
        return this.aclKeyMap.size();
    }

    private void clear() {
        this.aclKeyMap.clear();
        this.longKeyMap.clear();
        this.referenceCounter.clear();
    }

    public synchronized void addUsage(Long l2) {
        if (l2 == -1L) {
            return;
        }
        if (!this.longKeyMap.containsKey(l2)) {
            LOG.c("Ignoring acl {} as it does not exist in the cache", (Object)l2);
            return;
        }
        AtomicLong atomicLong = this.referenceCounter.get(l2);
        if (atomicLong == null) {
            this.referenceCounter.put(l2, new AtomicLongWithEquals(1L));
        } else {
            atomicLong.incrementAndGet();
        }
    }

    public synchronized void removeUsage(Long l2) {
        if (l2 == -1L) {
            return;
        }
        if (!this.longKeyMap.containsKey(l2)) {
            LOG.c("Ignoring acl {} as it does not exist in the cache", (Object)l2);
            return;
        }
        long l3 = this.referenceCounter.get(l2).decrementAndGet();
        if (l3 <= 0L) {
            this.referenceCounter.remove(l2);
            this.aclKeyMap.remove(this.longKeyMap.get(l2));
            this.longKeyMap.remove(l2);
        }
    }

    public synchronized void purgeUnused() {
        Iterator<Map.Entry<Long, AtomicLongWithEquals>> iterator = this.referenceCounter.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, AtomicLongWithEquals> entry = iterator.next();
            if (entry.getValue().get() > 0L) continue;
            Long l2 = entry.getKey();
            this.aclKeyMap.remove(this.longKeyMap.get(l2));
            this.longKeyMap.remove(l2);
            iterator.remove();
        }
    }

    static class AtomicLongWithEquals
    extends AtomicLong {
        private static final long serialVersionUID = 3355155896813725462L;

        public AtomicLongWithEquals(long l2) {
            super(l2);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            return this.equals((AtomicLongWithEquals)object);
        }

        public boolean equals(AtomicLongWithEquals atomicLongWithEquals) {
            return this.get() == atomicLongWithEquals.get();
        }

        public int hashCode() {
            return 31 * Long.valueOf(this.get()).hashCode();
        }
    }
}

