/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ExitCode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.Util;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.util.ServiceUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class PurgeTxnLog {
    private static final foe LOG = goe.a(PurgeTxnLog.class);
    private static final String COUNT_ERR_MSG = "count should be greater than or equal to 3";
    private static final String PREFIX_SNAPSHOT = "snapshot";
    private static final String PREFIX_LOG = "log";

    static void printUsage() {
        System.out.println("Usage:");
        System.out.println("PurgeTxnLog dataLogDir [snapDir] -n count");
        System.out.println("\tdataLogDir -- path to the txn log directory");
        System.out.println("\tsnapDir -- path to the snapshot directory");
        System.out.println("\tcount -- the number of old snaps/logs you want to keep, value should be greater than or equal to 3");
    }

    public static void purge(File file, File file2, int n2) throws IOException {
        if (n2 < 3) {
            throw new IllegalArgumentException(COUNT_ERR_MSG);
        }
        FileTxnSnapLog fileTxnSnapLog = new FileTxnSnapLog(file, file2);
        List<File> list = fileTxnSnapLog.findNValidSnapshots(n2);
        int n3 = list.size();
        if (n3 > 0) {
            PurgeTxnLog.purgeOlderSnapshots(fileTxnSnapLog, list.get(n3 - 1));
        }
    }

    static void purgeOlderSnapshots(FileTxnSnapLog fileTxnSnapLog, File file) {
        File[] fileArray;
        final long l2 = Util.getZxidFromName(file.getName(), PREFIX_SNAPSHOT);
        final HashSet<File> hashSet = new HashSet<File>();
        hashSet.addAll(Arrays.asList(fileTxnSnapLog.getSnapshotLogs(l2)));
        class MyFileFilter
        implements FileFilter {
            private final String prefix;

            MyFileFilter(String string) {
                this.prefix = string;
            }

            @Override
            public boolean accept(File file) {
                if (!file.getName().startsWith(this.prefix + ".")) {
                    return false;
                }
                if (hashSet.contains(file)) {
                    return false;
                }
                long l22 = Util.getZxidFromName(file.getName(), this.prefix);
                return l22 < l2;
            }
        }
        File[] fileArray2 = fileTxnSnapLog.getDataLogDir().listFiles(new MyFileFilter(PREFIX_LOG));
        ArrayList<File> arrayList = new ArrayList<File>();
        if (fileArray2 != null) {
            arrayList.addAll(Arrays.asList(fileArray2));
        }
        if ((fileArray = fileTxnSnapLog.getSnapDir().listFiles(new MyFileFilter(PREFIX_SNAPSHOT))) != null) {
            arrayList.addAll(Arrays.asList(fileArray));
        }
        for (File file2 : arrayList) {
            String string = String.format("Removing file: %s\t%s", DateFormat.getDateTimeInstance().format(file2.lastModified()), file2.getPath());
            LOG.c(string);
            System.out.println(string);
            if (file2.delete()) continue;
            System.err.println("Failed to remove " + file2.getPath());
        }
    }

    public static void main(String[] stringArray) throws IOException {
        File file;
        if (stringArray.length < 3 || stringArray.length > 4) {
            PurgeTxnLog.printUsageThenExit();
        }
        File file2 = file = PurgeTxnLog.validateAndGetFile(stringArray[0]);
        int n2 = -1;
        String string = "";
        if (stringArray.length == 3) {
            string = stringArray[1];
            n2 = PurgeTxnLog.validateAndGetCount(stringArray[2]);
        } else {
            file2 = PurgeTxnLog.validateAndGetFile(stringArray[1]);
            string = stringArray[2];
            n2 = PurgeTxnLog.validateAndGetCount(stringArray[3]);
        }
        if (!"-n".equals(string)) {
            PurgeTxnLog.printUsageThenExit();
        }
        PurgeTxnLog.purge(file, file2, n2);
    }

    private static File validateAndGetFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            System.err.println("Path '" + file.getAbsolutePath() + "' does not exist. ");
            PurgeTxnLog.printUsageThenExit();
        }
        return file;
    }

    private static int validateAndGetCount(String string) {
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string);
            if (n2 < 3) {
                System.err.println(COUNT_ERR_MSG);
                PurgeTxnLog.printUsageThenExit();
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("'" + string + "' can not be parsed to integer.");
            PurgeTxnLog.printUsageThenExit();
        }
        return n2;
    }

    private static void printUsageThenExit() {
        PurgeTxnLog.printUsage();
        ServiceUtils.requestSystemExit(ExitCode.UNEXPECTED_ERROR.getValue());
    }
}

