/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ExpiryQueue;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.NIOServerCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.RateLogger;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxnFactory;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.WorkerService;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperThread;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

public class NIOServerCnxnFactory
extends ServerCnxnFactory {
    private static final foe LOG = goe.a(NIOServerCnxnFactory.class);
    public static final String ZOOKEEPER_NIO_SESSIONLESS_CNXN_TIMEOUT = "zookeeper.nio.sessionlessCnxnTimeout";
    public static final String ZOOKEEPER_NIO_NUM_SELECTOR_THREADS = "zookeeper.nio.numSelectorThreads";
    public static final String ZOOKEEPER_NIO_NUM_WORKER_THREADS = "zookeeper.nio.numWorkerThreads";
    public static final String ZOOKEEPER_NIO_DIRECT_BUFFER_BYTES = "zookeeper.nio.directBufferBytes";
    public static final String ZOOKEEPER_NIO_SHUTDOWN_TIMEOUT = "zookeeper.nio.shutdownTimeout";
    ServerSocketChannel ss;
    private static final ThreadLocal<ByteBuffer> directBuffer;
    private final ConcurrentHashMap<InetAddress, Set<NIOServerCnxn>> ipMap = new ConcurrentHashMap();
    protected int maxClientCnxns = 60;
    int listenBacklog = -1;
    int sessionlessCnxnTimeout;
    private ExpiryQueue<NIOServerCnxn> cnxnExpiryQueue;
    protected WorkerService workerPool;
    private static int directBufferBytes;
    private int numSelectorThreads;
    private int numWorkerThreads;
    private long workerShutdownTimeoutMS;
    private volatile boolean stopped = true;
    private ConnectionExpirerThread expirerThread;
    private AcceptThread acceptThread;
    private final Set<SelectorThread> selectorThreads = new HashSet<SelectorThread>();

    public static ByteBuffer getDirectBuffer() {
        return directBufferBytes > 0 ? directBuffer.get() : null;
    }

    @Override
    public void configure(InetSocketAddress inetSocketAddress, int n2, int n3, boolean bl2) throws IOException {
        if (bl2) {
            throw new UnsupportedOperationException("SSL isn't supported in NIOServerCnxn");
        }
        this.configureSaslLogin();
        this.maxClientCnxns = n2;
        this.initMaxCnxns();
        this.sessionlessCnxnTimeout = Integer.getInteger(ZOOKEEPER_NIO_SESSIONLESS_CNXN_TIMEOUT, 10000);
        this.cnxnExpiryQueue = new ExpiryQueue(this.sessionlessCnxnTimeout);
        this.expirerThread = new ConnectionExpirerThread();
        int n4 = Runtime.getRuntime().availableProcessors();
        this.numSelectorThreads = Integer.getInteger(ZOOKEEPER_NIO_NUM_SELECTOR_THREADS, Math.max((int)Math.sqrt((float)n4 / 2.0f), 1));
        if (this.numSelectorThreads < 1) {
            throw new IOException("numSelectorThreads must be at least 1");
        }
        this.numWorkerThreads = Integer.getInteger(ZOOKEEPER_NIO_NUM_WORKER_THREADS, 2 * n4);
        this.workerShutdownTimeoutMS = Long.getLong(ZOOKEEPER_NIO_SHUTDOWN_TIMEOUT, 5000L);
        String string = "Configuring NIO connection handler with " + this.sessionlessCnxnTimeout / 1000 + "s sessionless connection timeout, " + this.numSelectorThreads + " selector thread(s), " + (this.numWorkerThreads > 0 ? Integer.valueOf(this.numWorkerThreads) : "no") + " worker threads, and " + (directBufferBytes == 0 ? "gathered writes." : "" + directBufferBytes / 1024 + " kB direct buffers.");
        LOG.c(string);
        for (int i2 = 0; i2 < this.numSelectorThreads; ++i2) {
            this.selectorThreads.add(new SelectorThread(i2));
        }
        this.listenBacklog = n3;
        this.ss = ServerSocketChannel.open();
        this.ss.socket().setReuseAddress(true);
        LOG.c("binding to port {}", (Object)inetSocketAddress);
        if (this.listenBacklog == -1) {
            this.ss.socket().bind(inetSocketAddress);
        } else {
            this.ss.socket().bind(inetSocketAddress, this.listenBacklog);
        }
        if (inetSocketAddress.getPort() == 0) {
            LOG.c("bound to port {}", (Object)this.ss.getLocalAddress());
        }
        this.ss.configureBlocking(false);
        this.acceptThread = new AcceptThread(this.ss, inetSocketAddress, this.selectorThreads);
    }

    private void tryClose(ServerSocketChannel serverSocketChannel) {
        try {
            serverSocketChannel.close();
        }
        catch (IOException iOException) {
            LOG.d("Error while closing server socket.", iOException);
        }
    }

    @Override
    public void reconfigure(InetSocketAddress inetSocketAddress) {
        ServerSocketChannel serverSocketChannel = this.ss;
        try {
            this.acceptThread.setReconfiguring();
            this.tryClose(serverSocketChannel);
            this.acceptThread.wakeupSelector();
            try {
                this.acceptThread.join();
            }
            catch (InterruptedException interruptedException) {
                LOG.d("Error joining old acceptThread when reconfiguring client port.", interruptedException);
                Thread.currentThread().interrupt();
            }
            this.ss = ServerSocketChannel.open();
            this.ss.socket().setReuseAddress(true);
            LOG.c("binding to port {}", (Object)inetSocketAddress);
            this.ss.socket().bind(inetSocketAddress);
            this.ss.configureBlocking(false);
            this.acceptThread = new AcceptThread(this.ss, inetSocketAddress, this.selectorThreads);
            this.acceptThread.start();
        }
        catch (IOException iOException) {
            LOG.e("Error reconfiguring client port to {}", (Object)inetSocketAddress, (Object)iOException);
            this.tryClose(serverSocketChannel);
        }
    }

    @Override
    public int getMaxClientCnxnsPerHost() {
        return this.maxClientCnxns;
    }

    @Override
    public void setMaxClientCnxnsPerHost(int n2) {
        this.maxClientCnxns = n2;
    }

    @Override
    public int getSocketListenBacklog() {
        return this.listenBacklog;
    }

    @Override
    public void start() {
        this.stopped = false;
        if (this.workerPool == null) {
            this.workerPool = new WorkerService("NIOWorker", this.numWorkerThreads, false);
        }
        for (SelectorThread selectorThread : this.selectorThreads) {
            if (selectorThread.getState() != Thread.State.NEW) continue;
            selectorThread.start();
        }
        if (this.acceptThread.getState() == Thread.State.NEW) {
            this.acceptThread.start();
        }
        if (this.expirerThread.getState() == Thread.State.NEW) {
            this.expirerThread.start();
        }
    }

    @Override
    public void startup(ZooKeeperServer zooKeeperServer, boolean bl2) throws IOException, InterruptedException {
        this.start();
        this.setZooKeeperServer(zooKeeperServer);
        if (bl2) {
            zooKeeperServer.startdata();
            zooKeeperServer.startup();
        }
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.ss.socket().getLocalSocketAddress();
    }

    @Override
    public int getLocalPort() {
        return this.ss.socket().getLocalPort();
    }

    public boolean removeCnxn(NIOServerCnxn nIOServerCnxn) {
        Set<NIOServerCnxn> set;
        if (!this.cnxns.remove(nIOServerCnxn)) {
            return false;
        }
        this.cnxnExpiryQueue.remove(nIOServerCnxn);
        this.removeCnxnFromSessionMap(nIOServerCnxn);
        InetAddress inetAddress = nIOServerCnxn.getSocketAddress();
        if (inetAddress != null && (set = this.ipMap.get(inetAddress)) != null) {
            set.remove(nIOServerCnxn);
        }
        this.unregisterConnection(nIOServerCnxn);
        return true;
    }

    public void touchCnxn(NIOServerCnxn nIOServerCnxn) {
        this.cnxnExpiryQueue.update(nIOServerCnxn, nIOServerCnxn.getSessionTimeout());
    }

    private void addCnxn(NIOServerCnxn nIOServerCnxn) throws IOException {
        Set<NIOServerCnxn> set;
        InetAddress inetAddress = nIOServerCnxn.getSocketAddress();
        if (inetAddress == null) {
            throw new IOException("Socket of " + nIOServerCnxn + " has been closed");
        }
        Set<NIOServerCnxn> set2 = this.ipMap.get(inetAddress);
        if (set2 == null && (set = this.ipMap.putIfAbsent(inetAddress, set2 = Collections.newSetFromMap(new ConcurrentHashMap(2)))) != null) {
            set2 = set;
        }
        set2.add(nIOServerCnxn);
        this.cnxns.add(nIOServerCnxn);
        this.touchCnxn(nIOServerCnxn);
    }

    public NIOServerCnxn createConnection(SocketChannel socketChannel, SelectionKey selectionKey, SelectorThread selectorThread) throws IOException {
        return new NIOServerCnxn(this.zkServer, socketChannel, selectionKey, this, selectorThread);
    }

    private int getClientCnxnCount(InetAddress inetAddress) {
        Set<NIOServerCnxn> set = this.ipMap.get(inetAddress);
        if (set == null) {
            return 0;
        }
        return set.size();
    }

    @Override
    public void closeAll(ServerCnxn.DisconnectReason disconnectReason) {
        for (ServerCnxn serverCnxn : this.cnxns) {
            try {
                serverCnxn.close(disconnectReason);
            }
            catch (Exception exception) {
                LOG.d("Ignoring exception closing cnxn session id 0x{}", (Object)Long.toHexString(serverCnxn.getSessionId()), (Object)exception);
            }
        }
    }

    public void stop() {
        this.stopped = true;
        try {
            this.ss.close();
        }
        catch (IOException iOException) {
            LOG.c("Error closing listen socket", iOException);
        }
        if (this.acceptThread != null) {
            if (this.acceptThread.isAlive()) {
                this.acceptThread.wakeupSelector();
            } else {
                this.acceptThread.closeSelector();
            }
        }
        if (this.expirerThread != null) {
            this.expirerThread.interrupt();
        }
        for (SelectorThread selectorThread : this.selectorThreads) {
            if (selectorThread.isAlive()) {
                selectorThread.wakeupSelector();
                continue;
            }
            selectorThread.closeSelector();
        }
        if (this.workerPool != null) {
            this.workerPool.stop();
        }
    }

    @Override
    public void shutdown() {
        try {
            this.stop();
            this.join();
            this.closeAll(ServerCnxn.DisconnectReason.SERVER_SHUTDOWN);
            if (this.login != null) {
                this.login.shutdown();
            }
        }
        catch (InterruptedException interruptedException) {
            LOG.c("Ignoring interrupted exception during shutdown", interruptedException);
        }
        catch (Exception exception) {
            LOG.c("Ignoring unexpected exception during shutdown", exception);
        }
        if (this.zkServer != null) {
            this.zkServer.shutdown();
        }
    }

    @Override
    public void join() throws InterruptedException {
        if (this.acceptThread != null) {
            this.acceptThread.join();
        }
        for (SelectorThread selectorThread : this.selectorThreads) {
            selectorThread.join();
        }
        if (this.workerPool != null) {
            this.workerPool.join(this.workerShutdownTimeoutMS);
        }
    }

    @Override
    public Iterable<ServerCnxn> getConnections() {
        return this.cnxns;
    }

    public void dumpConnections(PrintWriter printWriter) {
        printWriter.print("Connections ");
        this.cnxnExpiryQueue.dump(printWriter);
    }

    @Override
    public void resetAllConnectionStats() {
        for (ServerCnxn serverCnxn : this.cnxns) {
            serverCnxn.resetStats();
        }
    }

    @Override
    public Iterable<Map<String, Object>> getAllConnectionInfo(boolean bl2) {
        HashSet<Map<String, Object>> hashSet = new HashSet<Map<String, Object>>();
        for (ServerCnxn serverCnxn : this.cnxns) {
            hashSet.add(serverCnxn.getConnectionInfo(bl2));
        }
        return hashSet;
    }

    static {
        Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> LOG.e("Thread {} died", (Object)thread, (Object)throwable));
        directBufferBytes = Integer.getInteger(ZOOKEEPER_NIO_DIRECT_BUFFER_BYTES, 65536);
        directBuffer = new ThreadLocal<ByteBuffer>(){

            @Override
            protected ByteBuffer initialValue() {
                return ByteBuffer.allocateDirect(directBufferBytes);
            }
        };
    }

    class ConnectionExpirerThread
    extends ZooKeeperThread {
        ConnectionExpirerThread() {
            super("ConnnectionExpirer");
        }

        @Override
        public void run() {
            try {
                while (!NIOServerCnxnFactory.this.stopped) {
                    long l2 = NIOServerCnxnFactory.this.cnxnExpiryQueue.getWaitTime();
                    if (l2 > 0L) {
                        Thread.sleep(l2);
                        continue;
                    }
                    for (NIOServerCnxn nIOServerCnxn : NIOServerCnxnFactory.this.cnxnExpiryQueue.poll()) {
                        ServerMetrics.getMetrics().SESSIONLESS_CONNECTIONS_EXPIRED.add(1L);
                        nIOServerCnxn.close(ServerCnxn.DisconnectReason.CONNECTION_EXPIRED);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                LOG.c("ConnnectionExpirerThread interrupted");
            }
        }
    }

    class IOWorkRequest
    extends WorkerService.WorkRequest {
        private final SelectorThread selectorThread;
        private final SelectionKey key;
        private final NIOServerCnxn cnxn;

        IOWorkRequest(SelectorThread selectorThread, SelectionKey selectionKey) {
            this.selectorThread = selectorThread;
            this.key = selectionKey;
            this.cnxn = (NIOServerCnxn)selectionKey.attachment();
        }

        @Override
        public void doWork() throws InterruptedException {
            if (!this.key.isValid()) {
                this.selectorThread.cleanupSelectionKey(this.key);
                return;
            }
            if (this.key.isReadable() || this.key.isWritable()) {
                this.cnxn.doIO(this.key);
                if (NIOServerCnxnFactory.this.stopped) {
                    this.cnxn.close(ServerCnxn.DisconnectReason.SERVER_SHUTDOWN);
                    return;
                }
                if (!this.key.isValid()) {
                    this.selectorThread.cleanupSelectionKey(this.key);
                    return;
                }
                NIOServerCnxnFactory.this.touchCnxn(this.cnxn);
            }
            this.cnxn.enableSelectable();
            if (!this.selectorThread.addInterestOpsUpdateRequest(this.key)) {
                this.cnxn.close(ServerCnxn.DisconnectReason.CONNECTION_MODE_CHANGED);
            }
        }

        @Override
        public void cleanup() {
            this.cnxn.close(ServerCnxn.DisconnectReason.CLEAN_UP);
        }
    }

    public class SelectorThread
    extends AbstractSelectThread {
        private final int id;
        private final Queue<SocketChannel> acceptedQueue;
        private final Queue<SelectionKey> updateQueue;

        public SelectorThread(int n2) throws IOException {
            super("NIOServerCxnFactory.SelectorThread-" + n2);
            this.id = n2;
            this.acceptedQueue = new LinkedBlockingQueue<SocketChannel>();
            this.updateQueue = new LinkedBlockingQueue<SelectionKey>();
        }

        public boolean addAcceptedConnection(SocketChannel socketChannel) {
            if (NIOServerCnxnFactory.this.stopped || !this.acceptedQueue.offer(socketChannel)) {
                return false;
            }
            this.wakeupSelector();
            return true;
        }

        public boolean addInterestOpsUpdateRequest(SelectionKey selectionKey) {
            if (NIOServerCnxnFactory.this.stopped || !this.updateQueue.offer(selectionKey)) {
                return false;
            }
            this.wakeupSelector();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!NIOServerCnxnFactory.this.stopped) {
                    try {
                        this.select();
                        this.processAcceptedConnections();
                        this.processInterestOpsUpdateRequests();
                    }
                    catch (RuntimeException runtimeException) {
                        LOG.c("Ignoring unexpected runtime exception", runtimeException);
                    }
                    catch (Exception exception) {
                        LOG.c("Ignoring unexpected exception", exception);
                    }
                }
                Object object = this.selector.keys().iterator();
                while (object.hasNext()) {
                    SelectionKey selectionKey = object.next();
                    NIOServerCnxn nIOServerCnxn = (NIOServerCnxn)selectionKey.attachment();
                    if (nIOServerCnxn.isSelectable()) {
                        nIOServerCnxn.close(ServerCnxn.DisconnectReason.SERVER_SHUTDOWN);
                    }
                    this.cleanupSelectionKey(selectionKey);
                }
                while ((object = this.acceptedQueue.poll()) != null) {
                    this.fastCloseSock((SocketChannel)object);
                }
                this.updateQueue.clear();
            }
            finally {
                this.closeSelector();
                NIOServerCnxnFactory.this.stop();
                LOG.c("selector thread exitted run method");
            }
        }

        private void select() {
            try {
                this.selector.select();
                Set<SelectionKey> set = this.selector.selectedKeys();
                ArrayList<SelectionKey> arrayList = new ArrayList<SelectionKey>(set);
                Collections.shuffle(arrayList);
                Iterator<SelectionKey> iterator = arrayList.iterator();
                while (!NIOServerCnxnFactory.this.stopped && iterator.hasNext()) {
                    SelectionKey selectionKey = iterator.next();
                    set.remove(selectionKey);
                    if (!selectionKey.isValid()) {
                        this.cleanupSelectionKey(selectionKey);
                        continue;
                    }
                    if (selectionKey.isReadable() || selectionKey.isWritable()) {
                        this.handleIO(selectionKey);
                        continue;
                    }
                    LOG.d("Unexpected ops in select {}", (Object)selectionKey.readyOps());
                }
            }
            catch (IOException iOException) {
                LOG.c("Ignoring IOException while selecting", iOException);
            }
        }

        private void handleIO(SelectionKey selectionKey) {
            IOWorkRequest iOWorkRequest = new IOWorkRequest(this, selectionKey);
            NIOServerCnxn nIOServerCnxn = (NIOServerCnxn)selectionKey.attachment();
            nIOServerCnxn.disableSelectable();
            selectionKey.interestOps(0);
            NIOServerCnxnFactory.this.touchCnxn(nIOServerCnxn);
            NIOServerCnxnFactory.this.workerPool.schedule(iOWorkRequest);
        }

        private void processAcceptedConnections() {
            SocketChannel socketChannel;
            while (!NIOServerCnxnFactory.this.stopped && (socketChannel = this.acceptedQueue.poll()) != null) {
                SelectionKey selectionKey = null;
                try {
                    selectionKey = socketChannel.register(this.selector, 1);
                    NIOServerCnxn nIOServerCnxn = NIOServerCnxnFactory.this.createConnection(socketChannel, selectionKey, this);
                    selectionKey.attach(nIOServerCnxn);
                    NIOServerCnxnFactory.this.addCnxn(nIOServerCnxn);
                }
                catch (IOException iOException) {
                    this.cleanupSelectionKey(selectionKey);
                    this.fastCloseSock(socketChannel);
                }
            }
        }

        private void processInterestOpsUpdateRequests() {
            SelectionKey selectionKey;
            while (!NIOServerCnxnFactory.this.stopped && (selectionKey = this.updateQueue.poll()) != null) {
                NIOServerCnxn nIOServerCnxn;
                if (!selectionKey.isValid()) {
                    this.cleanupSelectionKey(selectionKey);
                }
                if (!(nIOServerCnxn = (NIOServerCnxn)selectionKey.attachment()).isSelectable()) continue;
                selectionKey.interestOps(nIOServerCnxn.getInterestOps());
            }
        }
    }

    class AcceptThread
    extends AbstractSelectThread {
        private final ServerSocketChannel acceptSocket;
        private final SelectionKey acceptKey;
        private final RateLogger acceptErrorLogger;
        private final Collection<SelectorThread> selectorThreads;
        private Iterator<SelectorThread> selectorIterator;
        private volatile boolean reconfiguring;

        public AcceptThread(ServerSocketChannel serverSocketChannel, InetSocketAddress inetSocketAddress, Set<SelectorThread> set) throws IOException {
            super("NIOServerCxnFactory.AcceptThread:" + inetSocketAddress);
            this.acceptErrorLogger = new RateLogger(LOG);
            this.reconfiguring = false;
            this.acceptSocket = serverSocketChannel;
            this.acceptKey = this.acceptSocket.register(this.selector, 16);
            this.selectorThreads = Collections.unmodifiableList(new ArrayList<SelectorThread>(set));
            this.selectorIterator = this.selectorThreads.iterator();
        }

        @Override
        public void run() {
            try {
                while (!NIOServerCnxnFactory.this.stopped && !this.acceptSocket.socket().isClosed()) {
                    try {
                        this.select();
                    }
                    catch (RuntimeException runtimeException) {
                        LOG.c("Ignoring unexpected runtime exception", runtimeException);
                    }
                    catch (Exception exception) {
                        LOG.c("Ignoring unexpected exception", exception);
                    }
                }
            }
            finally {
                this.closeSelector();
                if (!this.reconfiguring) {
                    NIOServerCnxnFactory.this.stop();
                }
                LOG.c("accept thread exitted run method");
            }
        }

        public void setReconfiguring() {
            this.reconfiguring = true;
        }

        private void select() {
            try {
                this.selector.select();
                Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                while (!NIOServerCnxnFactory.this.stopped && iterator.hasNext()) {
                    SelectionKey selectionKey = iterator.next();
                    iterator.remove();
                    if (!selectionKey.isValid()) continue;
                    if (selectionKey.isAcceptable()) {
                        if (this.doAccept()) continue;
                        this.pauseAccept(10L);
                        continue;
                    }
                    LOG.d("Unexpected ops in accept select {}", (Object)selectionKey.readyOps());
                }
            }
            catch (IOException iOException) {
                LOG.c("Ignoring IOException while selecting", iOException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pauseAccept(long l2) {
            this.acceptKey.interestOps(0);
            try {
                this.selector.select(l2);
            }
            catch (IOException iOException) {
            }
            finally {
                this.acceptKey.interestOps(16);
            }
        }

        private boolean doAccept() {
            boolean bl2 = false;
            SocketChannel socketChannel = null;
            try {
                SelectorThread selectorThread;
                socketChannel = this.acceptSocket.accept();
                bl2 = true;
                if (NIOServerCnxnFactory.this.limitTotalNumberOfCnxns()) {
                    throw new IOException("Too many connections max allowed is " + NIOServerCnxnFactory.this.maxCnxns);
                }
                InetAddress inetAddress = socketChannel.socket().getInetAddress();
                int n2 = NIOServerCnxnFactory.this.getClientCnxnCount(inetAddress);
                if (NIOServerCnxnFactory.this.maxClientCnxns > 0 && n2 >= NIOServerCnxnFactory.this.maxClientCnxns) {
                    throw new IOException("Too many connections from " + inetAddress + " - max is " + NIOServerCnxnFactory.this.maxClientCnxns);
                }
                LOG.b("Accepted socket connection from {}", (Object)socketChannel.socket().getRemoteSocketAddress());
                socketChannel.configureBlocking(false);
                if (!this.selectorIterator.hasNext()) {
                    this.selectorIterator = this.selectorThreads.iterator();
                }
                if (!(selectorThread = this.selectorIterator.next()).addAcceptedConnection(socketChannel)) {
                    throw new IOException("Unable to add connection to selector queue" + (NIOServerCnxnFactory.this.stopped ? " (shutdown in progress)" : ""));
                }
                this.acceptErrorLogger.flush();
            }
            catch (IOException iOException) {
                ServerMetrics.getMetrics().CONNECTION_REJECTED.add(1L);
                this.acceptErrorLogger.rateLimitLog("Error accepting new connection: " + iOException.getMessage());
                this.fastCloseSock(socketChannel);
            }
            return bl2;
        }
    }

    abstract class AbstractSelectThread
    extends ZooKeeperThread {
        protected final Selector selector;

        public AbstractSelectThread(String string) throws IOException {
            super(string);
            this.setDaemon(true);
            this.selector = Selector.open();
        }

        public void wakeupSelector() {
            this.selector.wakeup();
        }

        protected void closeSelector() {
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                LOG.c("ignored exception during selector close.", iOException);
            }
        }

        protected void cleanupSelectionKey(SelectionKey selectionKey) {
            if (selectionKey != null) {
                try {
                    selectionKey.cancel();
                }
                catch (Exception exception) {
                    LOG.a("ignoring exception during selectionkey cancel", exception);
                }
            }
        }

        protected void fastCloseSock(SocketChannel socketChannel) {
            if (socketChannel != null) {
                try {
                    socketChannel.socket().setSoLinger(true, 0);
                }
                catch (SocketException socketException) {
                    LOG.c("Unable to set socket linger to 0, socket close may stall in CLOSE_WAIT", socketException);
                }
                NIOServerCnxn.closeSock(socketChannel);
            }
        }
    }
}

