/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class ExpiryQueue<E> {
    private final ConcurrentHashMap<E, Long> elemMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, Set<E>> expiryMap = new ConcurrentHashMap();
    private final AtomicLong nextExpirationTime = new AtomicLong();
    private final int expirationInterval;

    public ExpiryQueue(int n2) {
        this.expirationInterval = n2;
        this.nextExpirationTime.set(this.roundToNextInterval(Time.currentElapsedTime()));
    }

    private long roundToNextInterval(long l2) {
        return (l2 / (long)this.expirationInterval + 1L) * (long)this.expirationInterval;
    }

    public Long remove(E e2) {
        Set<E> set;
        Long l2 = this.elemMap.remove(e2);
        if (l2 != null && (set = this.expiryMap.get(l2)) != null) {
            set.remove(e2);
        }
        return l2;
    }

    public Long update(E e2, int n2) {
        Set<E> set;
        Long l2 = this.elemMap.get(e2);
        long l3 = Time.currentElapsedTime();
        Long l4 = this.roundToNextInterval(l3 + (long)n2);
        if (l4.equals(l2)) {
            return null;
        }
        Set<Object> set2 = this.expiryMap.get(l4);
        if (set2 == null && (set = this.expiryMap.putIfAbsent(l4, set2 = Collections.newSetFromMap(new ConcurrentHashMap()))) != null) {
            set2 = set;
        }
        set2.add(e2);
        l2 = this.elemMap.put(e2, l4);
        if (l2 != null && !l4.equals(l2) && (set = this.expiryMap.get(l2)) != null) {
            set.remove(e2);
        }
        return l4;
    }

    public long getWaitTime() {
        long l2;
        long l3 = Time.currentElapsedTime();
        return l3 < (l2 = this.nextExpirationTime.get()) ? l2 - l3 : 0L;
    }

    public Set<E> poll() {
        long l2;
        long l3 = Time.currentElapsedTime();
        if (l3 < (l2 = this.nextExpirationTime.get())) {
            return Collections.emptySet();
        }
        Set<E> set = null;
        long l4 = l2 + (long)this.expirationInterval;
        if (this.nextExpirationTime.compareAndSet(l2, l4)) {
            set = this.expiryMap.remove(l2);
        }
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    public void dump(PrintWriter printWriter) {
        printWriter.print("Sets (");
        printWriter.print(this.expiryMap.size());
        printWriter.print(")/(");
        printWriter.print(this.elemMap.size());
        printWriter.println("):");
        ArrayList arrayList = new ArrayList(this.expiryMap.keySet());
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            long l2 = (Long)iterator.next();
            Set<E> set = this.expiryMap.get(l2);
            if (set == null) continue;
            printWriter.print(set.size());
            printWriter.print(" expire at ");
            printWriter.print(Time.elapsedTimeToDate(l2));
            printWriter.println(":");
            for (E e2 : set) {
                printWriter.print("\t");
                printWriter.println(e2.toString());
            }
        }
    }

    public Map<Long, Set<E>> getExpiryMap() {
        return Collections.unmodifiableMap(this.expiryMap);
    }
}

