/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.CreateMode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.EphemeralTypeEmulate353;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum EphemeralType {
    VOID,
    NORMAL,
    CONTAINER,
    TTL{

        @Override
        public long maxValue() {
            return 0xFFFFFFFFFFL;
        }

        @Override
        public long toEphemeralOwner(long l2) {
            if (l2 > TTL.maxValue() || l2 <= 0L) {
                throw new IllegalArgumentException("ttl must be positive and cannot be larger than: " + TTL.maxValue());
            }
            return 0xFF00000000000000L | l2;
        }

        @Override
        public long getValue(long l2) {
            return EphemeralType.getExtendedFeatureValue(l2);
        }
    };

    public static final long CONTAINER_EPHEMERAL_OWNER = Long.MIN_VALUE;
    public static final long MAX_EXTENDED_SERVER_ID = 254L;
    private static final long EXTENDED_MASK = -72057594037927936L;
    private static final long EXTENDED_BIT_TTL = 0L;
    private static final long RESERVED_BITS_MASK = 0xFFFF0000000000L;
    private static final long RESERVED_BITS_SHIFT = 40L;
    private static final Map<Long, EphemeralType> extendedFeatureMap;
    private static final long EXTENDED_FEATURE_VALUE_MASK = 0xFFFFFFFFFFL;
    static final String EXTENDED_TYPES_ENABLED_PROPERTY = "zookeeper.extendedTypesEnabled";
    static final String TTL_3_5_3_EMULATION_PROPERTY = "zookeeper.emulate353TTLNodes";

    public long maxValue() {
        return 0L;
    }

    public long toEphemeralOwner(long l2) {
        return 0L;
    }

    public long getValue(long l2) {
        return 0L;
    }

    public static boolean extendedEphemeralTypesEnabled() {
        return Boolean.getBoolean(EXTENDED_TYPES_ENABLED_PROPERTY);
    }

    public static EphemeralType get(long l2) {
        if (EphemeralType.extendedEphemeralTypesEnabled()) {
            if (Boolean.getBoolean(TTL_3_5_3_EMULATION_PROPERTY) && EphemeralTypeEmulate353.get(l2) == EphemeralTypeEmulate353.TTL) {
                return TTL;
            }
            if ((l2 & 0xFF00000000000000L) == -72057594037927936L) {
                long l3 = EphemeralType.getExtendedFeatureBit(l2);
                EphemeralType ephemeralType = extendedFeatureMap.get(l3);
                if (ephemeralType == null) {
                    throw new IllegalArgumentException(String.format("Invalid ephemeralOwner. [%s]", Long.toHexString(l2)));
                }
                return ephemeralType;
            }
        }
        if (l2 == Long.MIN_VALUE) {
            return CONTAINER;
        }
        return l2 == 0L ? VOID : NORMAL;
    }

    public static void validateServerId(long l2) {
        if (EphemeralType.extendedEphemeralTypesEnabled() && l2 > 254L) {
            throw new RuntimeException("extendedTypesEnabled is true but Server ID is too large. Cannot be larger than 254");
        }
    }

    public static void validateTTL(CreateMode createMode, long l2) {
        if (createMode.isTTL()) {
            TTL.toEphemeralOwner(l2);
        } else if (l2 >= 0L) {
            throw new IllegalArgumentException("ttl not valid for mode: " + (Object)((Object)createMode));
        }
    }

    private static long getExtendedFeatureBit(long l2) {
        return (l2 & 0xFFFF0000000000L) >> 40;
    }

    private static long getExtendedFeatureValue(long l2) {
        return l2 & 0xFFFFFFFFFFL;
    }

    static {
        HashMap<Long, EphemeralType> hashMap = new HashMap<Long, EphemeralType>();
        hashMap.put(0L, TTL);
        extendedFeatureMap = Collections.unmodifiableMap(hashMap);
    }
}

